/*
 * Decompiled with CFR 0.152.
 */
package com.isomorphic.js;

import com.isomorphic.base.Config;
import com.isomorphic.util.DataTools;

public class TrailingCommaException
extends Exception {
    public static final String N_CONTEXT_LINES_CONFIG = "jsscan.trailingcomma.contextlines";
    public static final String BEFORE_MARKER = "// VVVVVVVVVVVVVVVVVVVV";
    public static final String AFTER_MARKER = "// ^^^^^^^^^^^^^^^^^^^^";
    public int commaCharPos;
    public int commaLineNum;
    public String commaLine;
    public String fileName;
    public char terminator;

    public TrailingCommaException() {
    }

    public TrailingCommaException(String buffer, String fileName, char terminator, int commaCharPos) {
        this.commaCharPos = commaCharPos;
        this.fileName = fileName;
        this.terminator = terminator;
        int lines = Config.getGlobal().getInteger((Object)N_CONTEXT_LINES_CONFIG, 5);
        this.commaLine = DataTools.getLinesContainingCharPosition(buffer, commaCharPos, lines, BEFORE_MARKER, AFTER_MARKER);
        this.commaLineNum = DataTools.countLines(buffer, commaCharPos);
    }

    @Override
    public String toString() {
        String closureType = this.terminator == '}' ? "object literal" : "array literal";
        return this.fileName + " - trailing comma in " + closureType + ", line " + this.commaLineNum + " :\n" + this.commaLine;
    }
}

