/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.user.server.rpc.jakarta;

import com.google.gwt.user.client.rpc.RpcTokenException;
import com.google.gwt.user.client.rpc.XsrfToken;
import com.google.gwt.user.client.rpc.XsrfTokenService;
import com.google.gwt.user.server.jakarta.Util;
import com.google.gwt.user.server.rpc.jakarta.RemoteServiceServlet;
import com.google.gwt.util.tools.shared.Md5Utils;
import com.google.gwt.util.tools.shared.StringUtils;
import jakarta.servlet.http.Cookie;

public class XsrfTokenServiceServlet
extends RemoteServiceServlet
implements XsrfTokenService {
    public static final String COOKIE_NAME_PARAM = "gwt.xsrf.session_cookie_name";
    static final String COOKIE_NAME_NOT_SET_ERROR_MSG = "Session cookie name not set! Use 'gwt.xsrf.session_cookie_name' context-param to specify session cookie name";
    private String sessionCookieName = null;

    public XsrfTokenServiceServlet() {
        this(null);
    }

    public XsrfTokenServiceServlet(String sessionCookieName) {
        this.sessionCookieName = sessionCookieName;
    }

    @Override
    public XsrfToken getNewXsrfToken() {
        return new XsrfToken(this.generateTokenValue());
    }

    public void init() {
        if (this.sessionCookieName == null) {
            this.sessionCookieName = this.getInitParameterValue(COOKIE_NAME_PARAM);
        }
        if (this.sessionCookieName == null) {
            throw new IllegalStateException(COOKIE_NAME_NOT_SET_ERROR_MSG);
        }
    }

    private String generateTokenValue() {
        if (this.sessionCookieName == null) {
            throw new IllegalStateException(COOKIE_NAME_NOT_SET_ERROR_MSG);
        }
        Cookie sessionCookie = Util.getCookie(this.getThreadLocalRequest(), this.sessionCookieName, false);
        if (sessionCookie == null || sessionCookie.getValue() == null || sessionCookie.getValue().length() == 0) {
            throw new RpcTokenException("Session cookie is not set or empty! Unable to generate XSRF cookie");
        }
        byte[] cookieBytes = sessionCookie.getValue().getBytes();
        return StringUtils.toHexString(Md5Utils.getMd5Digest(cookieBytes));
    }

    private String getInitParameterValue(String name) {
        String paramValue = null;
        paramValue = this.getServletConfig().getInitParameter(name);
        if (paramValue == null) {
            paramValue = this.getServletContext().getInitParameter(name);
        }
        return paramValue;
    }
}

