/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.user.cellview.client;

import com.google.gwt.core.client.GWT;
import com.google.gwt.dom.client.Document;
import com.google.gwt.dom.client.Style;
import com.google.gwt.dom.client.TableCellElement;
import com.google.gwt.dom.client.TableColElement;
import com.google.gwt.dom.client.TableElement;
import com.google.gwt.dom.client.TableRowElement;
import com.google.gwt.dom.client.TableSectionElement;
import com.google.gwt.resources.client.ClientBundle;
import com.google.gwt.resources.client.CssResource;
import com.google.gwt.resources.client.ImageResource;
import com.google.gwt.user.cellview.client.AbstractCellTable;
import com.google.gwt.user.cellview.client.CellBasedWidgetImpl;
import com.google.gwt.user.cellview.client.Column;
import com.google.gwt.user.cellview.client.LoadingStateChangeEvent;
import com.google.gwt.user.client.ui.DeckPanel;
import com.google.gwt.user.client.ui.Image;
import com.google.gwt.user.client.ui.SimplePanel;
import com.google.gwt.user.client.ui.Widget;
import com.google.gwt.view.client.ProvidesKey;
import java.util.HashSet;

public class CellTable<T>
extends AbstractCellTable<T>
implements AbstractCellTable.TableSectionChangeHandler {
    private static final int DEFAULT_PAGESIZE = 15;
    private static Resources DEFAULT_RESOURCES;
    final TableColElement colgroup;
    private final SimplePanel emptyTableWidgetContainer = new SimplePanel();
    private final SimplePanel loadingIndicatorContainer = new SimplePanel();
    private final DeckPanel messagesPanel = new DeckPanel();
    private final Style style;
    private final TableElement table;
    private TableSectionElement tbody;
    private final TableSectionElement tbodyLoading;
    private final TableCellElement tbodyLoadingCell;
    private TableSectionElement tfoot;
    private TableSectionElement thead;
    private boolean colGroupEnabled = true;
    private boolean removeColumnsOnHide = false;

    private static Resources getDefaultResources() {
        if (DEFAULT_RESOURCES == null) {
            DEFAULT_RESOURCES = (Resources)GWT.create(Resources.class);
        }
        return DEFAULT_RESOURCES;
    }

    private static Widget createDefaultLoadingIndicator(Resources resources) {
        ImageResource loadingImg = resources.cellTableLoading();
        return loadingImg == null ? null : new Image(loadingImg);
    }

    public CellTable() {
        this(15);
    }

    public CellTable(int pageSize) {
        this(pageSize, CellTable.getDefaultResources());
    }

    public CellTable(ProvidesKey<T> keyProvider) {
        this(15, keyProvider);
    }

    public CellTable(int pageSize, Resources resources) {
        this(pageSize, resources, null);
    }

    public CellTable(int pageSize, ProvidesKey<T> keyProvider) {
        this(pageSize, CellTable.getDefaultResources(), keyProvider);
    }

    public CellTable(int pageSize, Resources resources, ProvidesKey<T> keyProvider) {
        this(pageSize, resources, keyProvider, CellTable.createDefaultLoadingIndicator(resources));
    }

    public CellTable(int pageSize, Resources resources, ProvidesKey<T> keyProvider, Widget loadingIndicator) {
        this(pageSize, resources, keyProvider, loadingIndicator, true, true);
    }

    public CellTable(int pageSize, Resources resources, ProvidesKey<T> keyProvider, Widget loadingIndicator, boolean enableColGroup, boolean attachLoadingPanel) {
        super(Document.get().createTableElement(), pageSize, (AbstractCellTable.Resources)new ResourcesAdapter(resources), keyProvider);
        this.style = resources.cellTableStyle();
        this.style.ensureInjected();
        this.colGroupEnabled = enableColGroup;
        this.table = (TableElement)this.getElement().cast();
        this.table.setCellSpacing(0);
        if (enableColGroup) {
            this.colgroup = Document.get().createColGroupElement();
            this.table.appendChild(this.colgroup);
        } else {
            this.colgroup = null;
        }
        this.thead = this.table.createTHead();
        if (this.table.getTBodies().getLength() > 0) {
            this.tbody = this.table.getTBodies().getItem(0);
        } else {
            this.tbody = Document.get().createTBodyElement();
            this.table.appendChild(this.tbody);
        }
        this.tbodyLoading = Document.get().createTBodyElement();
        if (attachLoadingPanel) {
            this.table.appendChild(this.tbodyLoading);
        }
        this.tfoot = this.table.createTFoot();
        this.tbodyLoadingCell = Document.get().createTDElement();
        TableRowElement tr = Document.get().createTRElement();
        this.tbodyLoading.appendChild(tr);
        tr.appendChild(this.tbodyLoadingCell);
        this.tbodyLoadingCell.setAlign("center");
        this.tbodyLoadingCell.appendChild(this.messagesPanel.getElement());
        this.adopt(this.messagesPanel);
        this.messagesPanel.add(this.emptyTableWidgetContainer);
        this.messagesPanel.add(this.loadingIndicatorContainer);
        this.loadingIndicatorContainer.setStyleName(this.style.cellTableLoading());
        this.setLoadingIndicator(loadingIndicator);
        HashSet<String> eventTypes = new HashSet<String>();
        eventTypes.add("mouseover");
        eventTypes.add("mouseout");
        CellBasedWidgetImpl.get().sinkEvents(this, eventTypes);
    }

    @Override
    public void addColumnStyleName(int index, String styleName) {
        this.assertColumnGroupEnabled("Cannot add column style when colgroup is disabled");
        this.ensureTableColElement(index).addClassName(styleName);
    }

    public int getBodyHeight() {
        return this.tbody.getClientHeight();
    }

    public int getHeaderHeight() {
        return this.thead.getClientHeight();
    }

    public TableSectionElement getTableLoadingSection() {
        return this.tbodyLoading;
    }

    @Override
    public void onTableBodyChange(TableSectionElement newTBody) {
        this.tbody = newTBody;
    }

    @Override
    public void onTableFootChange(TableSectionElement newTFoot) {
        this.tfoot = newTFoot;
    }

    @Override
    public void onTableHeadChange(TableSectionElement newTHead) {
        this.thead = newTHead;
    }

    @Override
    public void removeColumnStyleName(int index, String styleName) {
        this.assertColumnGroupEnabled("Cannot remove column style when colgroup is disabled");
        if (index >= this.colgroup.getChildCount()) {
            return;
        }
        this.ensureTableColElement(index).removeClassName(styleName);
    }

    @Override
    public void setColumnWidth(Column<T, ?> column, String width) {
        this.assertColumnGroupEnabled("Cannot set column width when colgroup is disabled");
        super.setColumnWidth(column, width);
    }

    @Override
    public void setColumnWidth(Column<T, ?> column, double width, Style.Unit unit) {
        super.setColumnWidth(column, width, unit);
    }

    @Override
    public void setEmptyTableWidget(Widget widget) {
        this.emptyTableWidgetContainer.setWidget(widget);
        super.setEmptyTableWidget(widget);
    }

    @Override
    public void setLoadingIndicator(Widget widget) {
        this.loadingIndicatorContainer.setWidget(widget);
        super.setLoadingIndicator(widget);
    }

    public void setTableLayoutFixed(boolean isFixed) {
        if (isFixed && !this.colGroupEnabled) {
            throw new IllegalStateException("Cannot set table to fixed layout when colgroup is disabled");
        }
        if (isFixed) {
            this.table.getStyle().setTableLayout(Style.TableLayout.FIXED);
        } else {
            this.table.getStyle().clearTableLayout();
        }
    }

    public final void setWidth(String width, boolean isFixedLayout) {
        super.setWidth(width);
        this.setTableLayoutFixed(isFixedLayout);
    }

    public void setRemoveColumnsOnHide(boolean removeColumnsOnHide) {
        this.removeColumnsOnHide = removeColumnsOnHide;
    }

    @Override
    protected void doSetColumnWidth(int column, String width) {
        if (this.colGroupEnabled) {
            if (width == null) {
                this.ensureTableColElement(column).getStyle().clearWidth();
            } else {
                this.ensureTableColElement(column).getStyle().setProperty("width", width);
            }
        }
    }

    @Override
    protected void doSetHeaderVisible(boolean isFooter, boolean isVisible) {
        CellTable.setVisible(isFooter ? this.tfoot : this.thead, isVisible);
    }

    @Override
    protected TableSectionElement getTableBodyElement() {
        return this.tbody;
    }

    @Override
    protected TableSectionElement getTableFootElement() {
        return this.tfoot;
    }

    @Override
    protected TableSectionElement getTableHeadElement() {
        return this.thead;
    }

    @Override
    protected void onLoadingStateChanged(LoadingStateChangeEvent.LoadingState state) {
        SimplePanel message = null;
        if (state == LoadingStateChangeEvent.LoadingState.LOADING) {
            message = this.loadingIndicatorContainer;
        } else if (state == LoadingStateChangeEvent.LoadingState.LOADED && this.getPresenter().isEmpty()) {
            message = this.emptyTableWidgetContainer;
        }
        if (message != null) {
            this.messagesPanel.showWidget(this.messagesPanel.getWidgetIndex(message));
        }
        this.tbodyLoadingCell.setColSpan(Math.max(1, this.getRealColumnCount()));
        this.showOrHide(this.getChildContainer(), message == null);
        this.showOrHide(this.tbodyLoading, message != null);
        super.onLoadingStateChanged(state);
    }

    @Override
    protected void refreshColumnWidths() {
        super.refreshColumnWidths();
        if (this.colGroupEnabled) {
            int i;
            int colCount = this.colgroup.getChildCount();
            int lastColumn = this.getRealColumnCount();
            for (i = 0; i < lastColumn; ++i) {
                this.ensureTableColElement(i).getStyle().clearDisplay();
            }
            for (i = colCount - 1; i >= lastColumn; --i) {
                if (this.removeColumnsOnHide) {
                    this.colgroup.removeChild(this.colgroup.getChild(i));
                    continue;
                }
                this.doSetColumnWidth(i, "0px");
                this.ensureTableColElement(i).getStyle().setDisplay(Style.Display.NONE);
            }
        }
    }

    @Override
    protected void doAttachChildren() {
        super.doAttachChildren();
        this.doAttach(this.messagesPanel);
    }

    @Override
    protected void doDetachChildren() {
        super.doDetachChildren();
        this.doDetach(this.messagesPanel);
    }

    private void assertColumnGroupEnabled(String message) {
        if (!this.colGroupEnabled) {
            throw new IllegalStateException(message);
        }
    }

    private TableColElement ensureTableColElement(int index) {
        for (int i = this.colgroup.getChildCount(); i <= index; ++i) {
            this.colgroup.appendChild(Document.get().createColElement());
        }
        return (TableColElement)this.colgroup.getChild(index).cast();
    }

    public static interface Resources
    extends ClientBundle {
        @ClientBundle.Source(value={"cellTableHeaderBackground.png"})
        @ImageResource.ImageOptions(repeatStyle=ImageResource.RepeatStyle.Horizontal, flipRtl=true)
        public ImageResource cellTableFooterBackground();

        @ImageResource.ImageOptions(repeatStyle=ImageResource.RepeatStyle.Horizontal, flipRtl=true)
        public ImageResource cellTableHeaderBackground();

        @ImageResource.ImageOptions(flipRtl=true)
        public ImageResource cellTableLoading();

        @ClientBundle.Source(value={"cellListSelectedBackground.png"})
        @ImageResource.ImageOptions(repeatStyle=ImageResource.RepeatStyle.Horizontal, flipRtl=true)
        public ImageResource cellTableSelectedBackground();

        @ClientBundle.Source(value={"sortAscending.png"})
        @ImageResource.ImageOptions(flipRtl=true)
        public ImageResource cellTableSortAscending();

        @ClientBundle.Source(value={"sortDescending.png"})
        @ImageResource.ImageOptions(flipRtl=true)
        public ImageResource cellTableSortDescending();

        @ClientBundle.Source(value={"com/google/gwt/user/cellview/client/CellTable.css"})
        public Style cellTableStyle();
    }

    private static class ResourcesAdapter
    implements AbstractCellTable.Resources {
        private final Resources resources;
        private final StyleAdapter style;

        public ResourcesAdapter(Resources resources) {
            this.resources = resources;
            this.style = new StyleAdapter(resources.cellTableStyle());
        }

        @Override
        public ImageResource sortAscending() {
            return this.resources.cellTableSortAscending();
        }

        @Override
        public ImageResource sortDescending() {
            return this.resources.cellTableSortDescending();
        }

        @Override
        public AbstractCellTable.Style style() {
            return this.style;
        }
    }

    @CssResource.ImportedWithPrefix(value="gwt-CellTable")
    public static interface Style
    extends CssResource {
        public static final String DEFAULT_CSS = "com/google/gwt/user/cellview/client/CellTable.css";

        public String cellTableCell();

        public String cellTableEvenRow();

        public String cellTableEvenRowCell();

        public String cellTableFirstColumn();

        public String cellTableFirstColumnFooter();

        public String cellTableFirstColumnHeader();

        public String cellTableFooter();

        public String cellTableHeader();

        public String cellTableHoveredRow();

        public String cellTableHoveredRowCell();

        public String cellTableKeyboardSelectedCell();

        public String cellTableKeyboardSelectedRow();

        public String cellTableKeyboardSelectedRowCell();

        public String cellTableLastColumn();

        public String cellTableLastColumnFooter();

        public String cellTableLastColumnHeader();

        public String cellTableLoading();

        public String cellTableOddRow();

        public String cellTableOddRowCell();

        public String cellTableSelectedRow();

        public String cellTableSelectedRowCell();

        public String cellTableSortableHeader();

        public String cellTableSortedHeaderAscending();

        public String cellTableSortedHeaderDescending();

        public String cellTableWidget();
    }

    private static class StyleAdapter
    implements AbstractCellTable.Style {
        private final Style style;

        public StyleAdapter(Style style) {
            this.style = style;
        }

        @Override
        public String cell() {
            return this.style.cellTableCell();
        }

        @Override
        public String evenRow() {
            return this.style.cellTableEvenRow();
        }

        @Override
        public String evenRowCell() {
            return this.style.cellTableEvenRowCell();
        }

        @Override
        public String firstColumn() {
            return this.style.cellTableFirstColumn();
        }

        @Override
        public String firstColumnFooter() {
            return this.style.cellTableFirstColumnFooter();
        }

        @Override
        public String firstColumnHeader() {
            return this.style.cellTableFirstColumnHeader();
        }

        @Override
        public String footer() {
            return this.style.cellTableFooter();
        }

        @Override
        public String header() {
            return this.style.cellTableHeader();
        }

        @Override
        public String hoveredRow() {
            return this.style.cellTableHoveredRow();
        }

        @Override
        public String hoveredRowCell() {
            return this.style.cellTableHoveredRowCell();
        }

        @Override
        public String keyboardSelectedCell() {
            return this.style.cellTableKeyboardSelectedCell();
        }

        @Override
        public String keyboardSelectedRow() {
            return this.style.cellTableKeyboardSelectedRow();
        }

        @Override
        public String keyboardSelectedRowCell() {
            return this.style.cellTableKeyboardSelectedRowCell();
        }

        @Override
        public String lastColumn() {
            return this.style.cellTableLastColumn();
        }

        @Override
        public String lastColumnFooter() {
            return this.style.cellTableLastColumnFooter();
        }

        @Override
        public String lastColumnHeader() {
            return this.style.cellTableLastColumnHeader();
        }

        @Override
        public String oddRow() {
            return this.style.cellTableOddRow();
        }

        @Override
        public String oddRowCell() {
            return this.style.cellTableOddRowCell();
        }

        @Override
        public String selectedRow() {
            return this.style.cellTableSelectedRow();
        }

        @Override
        public String selectedRowCell() {
            return this.style.cellTableSelectedRowCell();
        }

        @Override
        public String sortableHeader() {
            return this.style.cellTableSortableHeader();
        }

        @Override
        public String sortedHeaderAscending() {
            return this.style.cellTableSortedHeaderAscending();
        }

        @Override
        public String sortedHeaderDescending() {
            return this.style.cellTableSortedHeaderDescending();
        }

        @Override
        public String widget() {
            return this.style.cellTableWidget();
        }
    }

    @CssResource.ImportedWithPrefix(value="gwt-CellTable")
    static interface BasicStyle
    extends Style {
        public static final String DEFAULT_CSS = "com/google/gwt/user/cellview/client/CellTableBasic.css";
    }

    public static interface BasicResources
    extends Resources {
        @Override
        @ClientBundle.Source(value={"com/google/gwt/user/cellview/client/CellTableBasic.css"})
        public BasicStyle cellTableStyle();
    }
}

