/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.cell.client;

import com.google.gwt.cell.client.AbstractInputCell;
import com.google.gwt.cell.client.Cell;
import com.google.gwt.cell.client.ValueUpdater;
import com.google.gwt.core.client.GWT;
import com.google.gwt.dom.client.Element;
import com.google.gwt.dom.client.NativeEvent;
import com.google.gwt.dom.client.SelectElement;
import com.google.gwt.safehtml.client.SafeHtmlTemplates;
import com.google.gwt.safehtml.shared.SafeHtml;
import com.google.gwt.safehtml.shared.SafeHtmlBuilder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class SelectionCell
extends AbstractInputCell<String, String> {
    private static Template template;
    private HashMap<String, Integer> indexForOption = new HashMap();
    private final List<String> options;

    public SelectionCell(List<String> options) {
        super("change");
        if (template == null) {
            template = (Template)GWT.create(Template.class);
        }
        this.options = new ArrayList<String>(options);
        int index = 0;
        for (String option : options) {
            this.indexForOption.put(option, index++);
        }
    }

    @Override
    public void onBrowserEvent(Cell.Context context, Element parent, String value, NativeEvent event, ValueUpdater<String> valueUpdater) {
        super.onBrowserEvent(context, parent, value, event, valueUpdater);
        String type = event.getType();
        if ("change".equals(type)) {
            Object key = context.getKey();
            SelectElement select = (SelectElement)parent.getFirstChild().cast();
            String newValue = this.options.get(select.getSelectedIndex());
            this.setViewData(key, newValue);
            this.finishEditing(parent, newValue, key, valueUpdater);
            if (valueUpdater != null) {
                valueUpdater.update(newValue);
            }
        }
    }

    @Override
    public void render(Cell.Context context, String value, SafeHtmlBuilder sb) {
        Object key = context.getKey();
        String viewData = (String)this.getViewData(key);
        if (viewData != null && viewData.equals(value)) {
            this.clearViewData(key);
            viewData = null;
        }
        int selectedIndex = this.getSelectedIndex(viewData == null ? value : viewData);
        sb.appendHtmlConstant("<select tabindex=\"-1\">");
        int index = 0;
        for (String option : this.options) {
            if (index++ == selectedIndex) {
                sb.append(template.selected(option));
                continue;
            }
            sb.append(template.deselected(option));
        }
        sb.appendHtmlConstant("</select>");
    }

    private int getSelectedIndex(String value) {
        Integer index = this.indexForOption.get(value);
        if (index == null) {
            return -1;
        }
        return index;
    }

    static interface Template
    extends SafeHtmlTemplates {
        @SafeHtmlTemplates.Template(value="<option value=\"{0}\">{0}</option>")
        public SafeHtml deselected(String var1);

        @SafeHtmlTemplates.Template(value="<option value=\"{0}\" selected=\"selected\">{0}</option>")
        public SafeHtml selected(String var1);
    }
}

