
package com.smartgwt.client.docs;

/**
 * A common set of context variables and helper functions are available when using templates for 
 * CoTTask.prompt,  CoTProcess.optionalPrompts entries, and  CoTTask.taskPrompt. <p> <h4>Context
 * variables</h4> The following objects/values are always available to template expressions: <ul>
 * <li><b>task</b> &mdash; the current  CoTTask instance (ID, title,     description, etc)</li>
 * <li><b>process</b> &mdash; the owning  CoTProcess instance     (ID, policies, etc)</li>
 * <li><b>goal</b> &mdash; equivalent to process.goal <li><b>state</b> &mdash; the shared {@link
 * com.smartgwt.client.util.workflow.Process#getState CoTProcess.state} object for the
 * workflow</li> <li><b>inputs</b> &mdash; inputs to this task if specified as {@link
 * com.smartgwt.client.util.workflow.Task#getInputs task.inputs};     the same data returned by
 * {@link com.smartgwt.client.util.workflow.Task#getInputRecord Task.getInputRecord()} (may be
 * absent if inputs were not defined)</li> </ul> <p> <h4>Helper functions</h4> <ul>
 * <li><b>json(x)</b> &mdash; render a compact JSON representation of <code>x</code> suitable    
 * for inclusion in a prompt (intended for small/medium objects).</li>
 * <li><b>promptPart(nameOrNames, omitNewlines?)</b> / <b>prt(...)</b> &mdash; insert one or    
 * more prompt parts as returned by  CoTProcess.getPromptPart(). </ul>
 */
public interface CoTPromptScope {
}
