package com.smartgwt.sample.showcase.client.dataintegration.java.serversummaries;

import com.smartgwt.client.data.AdvancedCriteria;
import com.smartgwt.client.data.Criterion;
import com.smartgwt.client.data.DataSource;
import com.smartgwt.client.data.Record;
import com.smartgwt.client.types.ListGridFieldType;
import com.smartgwt.client.types.OperatorId;
import com.smartgwt.client.widgets.Canvas;
import com.smartgwt.client.widgets.form.DynamicForm;
import com.smartgwt.client.widgets.form.fields.ButtonItem;
import com.smartgwt.client.widgets.form.fields.FloatItem;
import com.smartgwt.client.widgets.form.fields.IntegerItem;
import com.smartgwt.client.widgets.form.fields.TextItem;
import com.smartgwt.client.widgets.form.fields.events.ClickEvent;
import com.smartgwt.client.widgets.form.fields.events.ClickHandler;
import com.smartgwt.client.widgets.grid.ListGrid;
import com.smartgwt.client.widgets.grid.ListGridField;
import com.smartgwt.client.widgets.grid.ListGridRecord;
import com.smartgwt.client.widgets.layout.VLayout;
import com.smartgwt.sample.showcase.client.PanelFactory;
import com.smartgwt.sample.showcase.client.ShowcasePanel;
import com.smartgwt.sample.showcase.client.SourceEntity;

public class CustomAggregationQuerySample extends ShowcasePanel {

    private static final String DESCRIPTION =
		"The Server Summaries feature can be used in combination with the SQL Templating feature to manage aggregation\r" +
		"behavior.\r" +
		"<p>\r" +
		"In the sample below we have a fetch from the <code>orderItem</code> DataSource with the following criteria:\r" +
		"<ul><li> Only retrieve customers with average order <code>amount</code> values greater than 10</li>\r" +
		"    <li> Only count orders that have multiple items matching the specified <code>itemDescription</code></li>\r" +
		"</ul>\r" +
		"So data needs to be filtered in 3 steps:\r" +
		"<ul>\r" +
		"<li/> first retrieve orders with the correct itemDescription (<code>where itemDescription like “%widget%”</code>)\r" +
		"<li/> second we are grouping data by orders and filtering them by aggregated count of items within\r" +
		"the order (<code>having sum(quantity) &gt; 1</code>)\r" +
		"<li/> lastly after getting the complete result set, we want to aggregate data one more time by grouping\r" +
		"it by customers and filter them by average amount per all their orders (<code>having avg(amount) &gt; 10</code>)\r" +
		"</ul>\r" +
		"This is achieved by customizing entire query in <code>operationBinding.customSQL</code> of the\r" +
		"<code>orderItem</code> DataSource using <code>$sql.havingWithout(fieldNames)</code> and\r" +
		"<code>$sql.partialHaving(fieldNames)</code> APIs.<br>\r" +
		"(See the \r" +
		"<a href=https://www.smartclient.com/smartgwtee-latest/javadoc/index.html?com/smartgwt/client/docs/ServerSummaries.html>server summaries documentation</a> \r" +
		"for details on these APIs).";

    public static class Factory implements PanelFactory {
        private String id;

        public ShowcasePanel create() {
        	CustomAggregationQuerySample panel = new CustomAggregationQuerySample();
            id = panel.getID();
            return panel;
        }

        public String getID() {
            return id;
        }

        public String getDescription() {
            return DESCRIPTION;
        }
    }

    protected boolean isTopIntro() {
        return true;
    }

    public Canvas getViewPanel() {

    	final ListGrid orderList = new ListGrid();
    	orderList.setDataSource(DataSource.get("aggregationCustomSQL2_orderItem"));
    	orderList.setWidth(300);
    	orderList.setHeight(200);
    	orderList.setShowFilterEditor(false);
    	orderList.setAutoFetchData(false);
    	orderList.setCanEdit(false);
    	orderList.setCanRemoveRecords(false);
    	orderList.setSortField(0);
    	
    	ListGridField orderCustomerNameField = new ListGridField("orderCustomerName");
    	orderCustomerNameField.setWidth(200);
    	orderCustomerNameField.setTitle("Customer");
    	ListGridField amountField = new ListGridField("amount");
    	amountField.setType(ListGridFieldType.INTEGER);
    	amountField.setTitle("Amount");
    	
    	orderList.setFields(orderCustomerNameField,amountField);  
    	
    	final DynamicForm orderItemCriteriaForm = new DynamicForm();
    	orderItemCriteriaForm.setNumCols(2);
    	orderItemCriteriaForm.setWidth(300);
    	
    	TextItem itemDescription = new TextItem("itemDescription");
    	itemDescription.setTitle("Item");
    	itemDescription.setDefaultValue("widget");
    	IntegerItem quantity = new IntegerItem();
    	quantity.setName("quantity");
    	quantity.setTitle("Quantity");
    	quantity.setDefaultValue(4);
    	FloatItem amount = new FloatItem();
    	amount.setName("amount");
    	amount.setTitle("Amount");
    	amount.setDefaultValue(10);
    	ButtonItem buttonItem = new ButtonItem();
    	buttonItem.setTitle("Filter");
    	buttonItem.setEndRow(false);
    	buttonItem.setStartRow(false);
    	buttonItem.addClickHandler(new ClickHandler() {
			@Override
			public void onClick(ClickEvent event) {
				Record record = orderItemCriteriaForm.getValuesAsRecord();
				AdvancedCriteria adCriteria = new AdvancedCriteria(OperatorId.AND, new Criterion[]{
			    	      new Criterion("itemDescription", OperatorId.CONTAINS, record.getAttribute("itemDescription")),
			    	      new Criterion("quantity", OperatorId.GREATER_THAN, record.getAttributeAsInt("quantity")),
			    	      new Criterion("amount", OperatorId.GREATER_THAN, record.getAttributeAsFloat("amount"))
			    	});
				orderList.setData(new ListGridRecord[0]);
                orderList.filterData(adCriteria);
			}
    	});
    	
    	orderItemCriteriaForm.setFields(itemDescription, quantity, amount, buttonItem);
    	
    	VLayout vLayout = new VLayout();
    	vLayout.setMembersMargin(20);
    	vLayout.setMembers(orderItemCriteriaForm, orderList);
    	
    	Record record = orderItemCriteriaForm.getValuesAsRecord();
		AdvancedCriteria adCriteria = new AdvancedCriteria(OperatorId.AND, new Criterion[]{
	    	      new Criterion("itemDescription", OperatorId.CONTAINS, record.getAttribute("itemDescription")),
	    	      new Criterion("quantity", OperatorId.GREATER_THAN, record.getAttributeAsInt("quantity")),
	    	      new Criterion("amount", OperatorId.GREATER_THAN, record.getAttributeAsFloat("amount"))
	    	});
        orderList.filterData(adCriteria);
    	
        return vLayout;
    }


    public String getIntro() {
        return DESCRIPTION;
    }
    
    public SourceEntity[] getSourceUrls() {
        return new SourceEntity[] {
            new SourceEntity("aggregationCustomSQL2_order.ds.xml", XML, "source/aggregationCustomSQL2_order.ds.xml.html", true)
        };
    }

}