/*
 * Isomorphic SmartGWT web presentation layer
 * Copyright 2000 and beyond Isomorphic Software, Inc.
 *
 * OWNERSHIP NOTICE
 * Isomorphic Software owns and reserves all rights not expressly granted in this source code,
 * including all intellectual property rights to the structure, sequence, and format of this code
 * and to all designs, interfaces, algorithms, schema, protocols, and inventions expressed herein.
 *
 *  If you have any questions, please email <sourcecode@isomorphic.com>.
 *
 *  This entire comment must accompany any portion of Isomorphic Software source code that is
 *  copied or moved from this file.
 */
package com.smartgwt.sample.showcase.client.chart;

import com.smartgwt.client.data.Record;

public class SimpleChartData extends Record {

    public SimpleChartData(String region, String product, Integer sales, String fuel) {
        setAttribute("region", region);
        setAttribute("product", product);
        setAttribute("sales", sales);
        setAttribute("fuel", fuel);
    }

    public static SimpleChartData[] getData() {
        return new SimpleChartData[] {
            new SimpleChartData("West", "Cars", 37, "Gas"),
            new SimpleChartData("North", "Cars", 29, "Gas"),
            new SimpleChartData("East", "Cars", 80, "Gas"),
            new SimpleChartData("South", "Cars", 87, "Gas"),

            new SimpleChartData("West", "Trucks", 23, "Gas"),
            new SimpleChartData("North", "Trucks", 45, "Gas"),
            new SimpleChartData("East", "Trucks", 32, "Gas"),
            new SimpleChartData("South", "Trucks", 67, "Gas"),

            new SimpleChartData("West", "Motorcycles", 12, "Gas"),
            new SimpleChartData("North", "Motorcycles", 4, "Gas"),
            new SimpleChartData("East", "Motorcycles", 23, "Gas"),
            new SimpleChartData("South", "Motorcycles", 45, "Gas"),

            new SimpleChartData("West", "Cars", 52, "Electric"),
            new SimpleChartData("North", "Cars", 92, "Electric"),
            new SimpleChartData("East", "Cars", 40, "Electric"),
            new SimpleChartData("South", "Cars", 12, "Electric"),

            new SimpleChartData("West", "Trucks", 43, "Electric"),
            new SimpleChartData("North", "Trucks", 25, "Electric"),
            new SimpleChartData("East", "Trucks", 52, "Electric"),
            new SimpleChartData("South", "Trucks", 7, "Electric"),

            new SimpleChartData("West", "Motorcycles", 22, "Electric"),
            new SimpleChartData("North", "Motorcycles", 60, "Electric"),
            new SimpleChartData("East", "Motorcycles", 33, "Electric"),
            new SimpleChartData("South", "Motorcycles", 81, "Electric")
        };
    }

}
