/*
 * Decompiled with CFR 0.152.
 */
package com.isomorphic.criteria;

import com.isomorphic.criteria.CanParseCriterion;
import com.isomorphic.criteria.Criterion;
import com.isomorphic.criteria.Evaluator;
import com.isomorphic.criteria.Operator;
import com.isomorphic.log.Logger;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public abstract class OperatorBase
implements CanParseCriterion,
Operator {
    public static final String CRITERIA_KEY = "criteria";
    public static final String VALUE_KEY = "value";
    public static final String FIELD_NAME_KEY = "fieldName";
    public static final String OPERATOR_KEY = "operator";
    public static final String NEVER_MATCHES_KEY = "__never_matches";
    public static final String FIELD_QUERY_KEY = "fieldQuery";
    public static final String VALUE_QUERY_KEY = "valueQuery";
    protected static Logger log = new Logger(OperatorBase.class.getName());

    @Override
    public Criterion parseCriterion(Map criteriaData) {
        String operatorId;
        String fieldName = (String)criteriaData.get(FIELD_NAME_KEY);
        Map fieldQuery = null;
        if (StringUtils.isEmpty((CharSequence)fieldName)) {
            fieldQuery = (Map)criteriaData.get(FIELD_QUERY_KEY);
            if (this.isRequiresFieldName() && fieldQuery == null) {
                log.warn("Incorrect criterion data: neither fieldName not fieldQuery is present.");
                return null;
            }
        }
        if (!(operatorId = (String)criteriaData.get(OPERATOR_KEY)).equals(this.getID())) {
            log.warn("Incorrect criterion data for '" + fieldName + "' field: operatorId does not match.");
            return null;
        }
        Object value = criteriaData.get(VALUE_KEY);
        Map valueQuery = null;
        if (value == null) {
            valueQuery = (Map)criteriaData.get(VALUE_QUERY_KEY);
            if (this.isRequiresValue() && value == null && valueQuery == null) {
                log.warn("Incorrect criterion data for '" + (String)(fieldName == null ? "fieldQuery criterion" : fieldName + "' field") + " neither value nor valueQuery is present.");
                return null;
            }
        }
        List rawCriteriaList = (List)criteriaData.get(CRITERIA_KEY);
        if (this.isRequiresCriteria() && rawCriteriaList == null) {
            log.warn("Incorrect criterion data for '" + fieldName + "' field: sub-criteria is missing.");
            return null;
        }
        ArrayList<Criterion> criteria = null;
        if (rawCriteriaList != null) {
            criteria = new ArrayList<Criterion>(rawCriteriaList.size());
            for (Object c : rawCriteriaList) {
                if (c instanceof Map) {
                    criteria.add(Evaluator.parseCriterion((Map)c));
                    continue;
                }
                if (!(c instanceof Criterion)) continue;
                criteria.add((Criterion)c);
            }
        }
        return this.parseCriterion(fieldName, value, criteria, fieldQuery, valueQuery);
    }

    public abstract boolean isRequiresFieldName();

    public abstract boolean isRequiresValue();

    public abstract boolean isRequiresCriteria();

    public abstract Criterion parseCriterion(String var1, Object var2, List<Criterion> var3, Map var4, Map var5);

    public abstract Map<String, Object> convertToMap(Criterion var1);
}

