/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.sql.results.graph.tuple;

import java.util.BitSet;
import org.hibernate.Internal;
import org.hibernate.spi.NavigablePath;
import org.hibernate.sql.results.graph.AssemblerCreationState;
import org.hibernate.sql.results.graph.DomainResult;
import org.hibernate.sql.results.graph.DomainResultAssembler;
import org.hibernate.sql.results.graph.FetchParentAccess;
import org.hibernate.sql.results.graph.basic.BasicResultGraphNode;
import org.hibernate.sql.results.graph.tuple.TupleResultAssembler;
import org.hibernate.type.descriptor.java.JavaType;

public class TupleResult<T>
implements DomainResult<T>,
BasicResultGraphNode<T> {
    private final String resultVariable;
    private final JavaType<T> javaType;
    private final NavigablePath navigablePath;
    private final TupleResultAssembler<T> assembler;

    public TupleResult(int[] jdbcValuesArrayPositions, String resultVariable, JavaType<T> javaType) {
        this(jdbcValuesArrayPositions, resultVariable, javaType, null);
    }

    public TupleResult(int[] jdbcValuesArrayPositions, String resultVariable, JavaType<T> javaType, NavigablePath navigablePath) {
        this.resultVariable = resultVariable;
        this.javaType = javaType;
        this.navigablePath = navigablePath;
        this.assembler = new TupleResultAssembler<T>(jdbcValuesArrayPositions, javaType);
    }

    @Override
    public String getResultVariable() {
        return this.resultVariable;
    }

    public JavaType<T> getResultJavaType() {
        return this.javaType;
    }

    @Override
    public NavigablePath getNavigablePath() {
        return this.navigablePath;
    }

    @Internal
    public DomainResultAssembler<T> getAssembler() {
        return this.assembler;
    }

    @Override
    public DomainResultAssembler<T> createResultAssembler(FetchParentAccess parentAccess, AssemblerCreationState creationState) {
        return this.assembler;
    }

    @Override
    public void collectValueIndexesToCache(BitSet valueIndexes) {
        for (int valuesArrayPosition : this.assembler.getValuesArrayPositions()) {
            valueIndexes.set(valuesArrayPosition);
        }
    }
}

