
package com.smartgwt.client.docs;

/**
 * <h3>Using <code>includeVia</code> with Composite Keys and <i>domainKey</i></h3>
 * In some legacy systems, composite primary keys are used to simulate multi-tenancy,
 *  often by including a <code>domainKey</code> or a similar field in the key. Smart GWT
 *  supports this pattern by allowing <code>includeVia</code> to work with composite keys.
 *  <p>
 *  This usage is generally discouraged in modern development. We strongly recommend using
 * {@link com.smartgwt.client.docs.MultiTenancy Smart GWT?s transparent multi-tenancy} approach
 * instead, which
 * provides true multi-tenant separation with less complexity and better long-term
 * maintainability.
 *  <p>
 * However, if you're working with an existing legacy system that uses this pattern,
 * <code>includeVia</code>
 * can be used to precisely define foreign key paths involving composite keys and indirect
 * relation chains.
 *  <p>
 * The examples below are based on the DataSources shown at the end of this section and are using
 * the
 * same data structure as in the {@link com.smartgwt.client.docs.IncludeViaSyntax
 * <code>includeVia</code> syntax and behavior},
 * but with an additional <i>domainKey</i> primary key field added to all DataSources to separate
 * data into
 * logical domains such as "live" and "test". Similarly all examples below also resolve the same
 * relation chain:
 *  <pre>
 *  Order &gt; Customer (via accountMgrEmployeeNumber) &gt; Employee &gt; Office
 *  </pre>
 *  <h4>Example 1: Full path specified</h4>
 *  Explicit composite keys at every step.
 *  <pre>
 *  includeFrom="Customer.Employee.Office.city"
 *  includeVia="Order.customerNumber-domainKey:Customer.accountMgrEmployeeNumber-domainKey:Employee.officeCode-domainKey"
 *  </pre>
 *  <h4>Example 2: Partial includeVia with omitted datasource names</h4>
 *  Unambiguous field names allow datasource names to be omitted.
 *  <pre>
 *  includeFrom="Customer.Employee.Office.city"
 *  includeVia="customerNumber-domainKey:accountMgrEmployeeNumber-domainKey"
 *  </pre>
 *  <h4>Example 3: Minimal includeVia</h4>
 *  Only the override for the non-default FK path is needed; the rest is resolved automatically.
 *  <pre>
 *  includeFrom="Customer.Employee.Office.city"
 *  includeVia="accountMgrEmployeeNumber-domainKey"
 *  </pre>
 *  <h4>Example 4: Shorter includeFrom with full includeVia</h4>
 * The includeFrom starts mid-chain, but includeVia ensures correct relation chain from the base
 * DataSource.
 *  <pre>
 *  includeFrom="Employee.Office.city"
 *  includeVia="Order.customerNumber-domainKey:Customer.accountMgrEmployeeNumber-domainKey:Employee.officeCode-domainKey"
 *  </pre>
 *  <h4>Example 5: Minimal includeFrom and includeVia</h4>
 *  System finds shortest valid path from base to target using the provided override.
 *  <pre>
 *  includeFrom="Office.city"
 *  includeVia="accountMgrEmployeeNumber-domainKey"
 *  </pre>
 *  <h4>Datasources used in samples:</h4>
 *  <pre>
 *  &lt;DataSource ID="Order" serverType="sql"&gt;
 *      &lt;fields&gt;
 *          &lt;field name="orderNumber" type="integer" primaryKey="true" /&gt;
 *          &lt;field name="domainKey" type="text" primaryKey="true" foreignKey="Customer.domainKey"/&gt;
 *          &lt;field name="orderDate" type="date" required="true"/&gt;
 *          &lt;field name="customerNumber" type="integer" foreignKey="Customer.customerNumber" /&gt;
 *      &lt;/fields&gt;
 *  &lt;/DataSource&gt;
 *  </pre>
 *  <pre>
 *  &lt;DataSource ID="Customer" serverType="sql"&gt;
 *      &lt;fields&gt;
 *          &lt;field name="customerNumber" type="integer" primaryKey="true" /&gt;
 *          &lt;field name="domainKey" type="text" primaryKey="true" foreignKey="Employee.domainKey" /&gt;
 *          &lt;field name="customerName" type="text" required="true"/&gt;
 *          &lt;field name="salesRepEmployeeNumber" type="integer" foreignKey="Employee.employeeNumber" /&gt;
 *          &lt;field name="accountMgrEmployeeNumber" type="integer" foreignKey="Employee.employeeNumber" /&gt;
 *      &lt;/fields&gt;
 *  &lt;/DataSource&gt;
 *  </pre>
 *  <pre>
 *  &lt;DataSource ID="Employee" serverType="sql"&gt;
 *      &lt;fields&gt;
 *          &lt;field name="employeeNumber" type="integer" primaryKey="true" /&gt;
 *          &lt;field name="domainKey" type="text" primaryKey="true" foreignKey="Office.domainKey"/&gt;
 *          &lt;field name="lastName" type="text" required="true"/&gt;
 *          &lt;field name="firstName" type="text" required="true"/&gt;
 *          &lt;field name="officeCode" type="text" foreignKey="Office.officeCode" /&gt;
 *      &lt;/fields&gt;
 *  &lt;/DataSource&gt;
 *  </pre>
 *  <pre>
 *  &lt;DataSource ID="Office" serverType="sql"&gt;
 *      &lt;fields&gt;
 *          &lt;field name="officeCode" type="text" primaryKey="true" /&gt;
 *          &lt;field name="domainKey" type="text" primaryKey="true" /&gt;
 *          &lt;field name="city" type="text" /&gt;
 *      &lt;/fields&gt;
 *  &lt;/DataSource&gt;
 *  </pre>
 */
public interface IncludeViaAndDomainKey {
}
