/*

  SmartClient Ajax RIA system
  Version v14.1p_2026-02-25/LGPL Deployment (2026-02-25)

  Copyright 2000 and beyond Isomorphic Software, Inc. All rights reserved.
  "SmartClient" is a trademark of Isomorphic Software, Inc.

  LICENSE NOTICE
     INSTALLATION OR USE OF THIS SOFTWARE INDICATES YOUR ACCEPTANCE OF
     ISOMORPHIC SOFTWARE LICENSE TERMS. If you have received this file
     without an accompanying Isomorphic Software license file, please
     contact licensing@isomorphic.com for details. Unauthorized copying and
     use of this software is a violation of international copyright law.

  DEVELOPMENT ONLY - DO NOT DEPLOY
     This software is provided for evaluation, training, and development
     purposes only. It may include supplementary components that are not
     licensed for deployment. The separate DEPLOY package for this release
     contains SmartClient components that are licensed for deployment.

  PROPRIETARY & PROTECTED MATERIAL
     This software contains proprietary materials that are protected by
     contract and intellectual property law. You are expressly prohibited
     from attempting to reverse engineer this software or modify this
     software for human readability.

  CONTACT ISOMORPHIC
     For more information regarding license rights and restrictions, or to
     report possible license violations, please contact Isomorphic Software
     by email (licensing@isomorphic.com) or web (www.isomorphic.com).

*/
//>	@staticMethod isc.getValueForKey()
// Given a key and an object of <code>key:value</code> pairs, return the value that corresponds to
// that key.
// <P>
// If the key is not found, <code>defaultValue</code> will be returned if provided, otherwise the
// key will be returned.
//
//	@param	key				(String | number)	key to look for
//	@param	valueMap		(Object)			object of key:value pairs
//	@param	[defaultValue]	(Any)				default value to return if key not found
//
//	@return					(Any)				returns value in valueMap under name key, or
//                                              defaultValue if key not found
// @visibility external
//<
isc.getValueForKey = function (key, valueMap, defaultValue) {
    
	if (valueMap && valueMap[key] != null && !isc.isAn.Array(valueMap)) return valueMap[key];
	return (arguments.length < 3 ? key : defaultValue);
}

//>	@staticMethod isc.getKeyForValue()
// Given a value and an object of <code>key:value</code> pairs, return a key that corresponds
// to that value.
// <P>
// If the key is not found, <code>defaultKey</code> will be returned if provided, otherwise the
// value will be returned.
//
//	@param	value			(String | number)	value to look for
//	@param	valueMap		(Object)			object of key:value pairs
//	@param	[defaultKey]	(Any)				default key to return if value not found
//
//	@return					(Any)				returns first key in valueMap with value, or
//                                              defaultKey if value not found
// @visibility external
//<
isc.getKeyForValue = function (value, valueMap, defaultKey) {
// JMD: handle null value here?
	if (valueMap) {
		for (var key in valueMap) {
			if (valueMap[key] == value) return key;
		}
	}
	return (arguments.length < 3 ? value : defaultKey);
}


//>	@staticMethod isc.makeReverseMap()
// Given a key:value map, return a new map as value:key.
// <P>
// If the same value appears more than once, the key will correspond to the last instance of that
// value.
//
//	@param	valueMap		(Object)			object of key:value pairs
//	@return					(Object)			reversed value map
// @visibility external
//<
isc.makeReverseMap = function (valueMap) {
	var newMap = {}, value;
	for (var key in valueMap) {
		value = valueMap[key];
		newMap[value] = key;
	}
	return newMap;
}

// returns a new value map, sorted by the key
// technically, maps can't be sorted, but in JS, objects "remember" the order in which key/value
// pairs were added
// XXX add support for normalizers
isc.sortByKey = function (valueMap) {
    var newMap = {},
        keys = isc.getKeys(valueMap).sort()
    ;
    for (var i = 0; i < keys.length; i++) {
        newMap[keys[i]] = valueMap[keys[i]];
    }
    return newMap;
}

// returns a new value map, sorted by the value
// technically, maps can't be sorted, but in JS, objects "remember" the order in which key/value
// pairs were added
// XXX add support for normalizers
isc.sortByValue = function (valueMap) {
    // make a reverse map of the input map; map is now: value -> key
    // call sortByKey on this reversed map
    // reverse the map again (so map is key -> value) and return it
    // XXX horribly inefficient
    return isc.makeReverseMap(isc.sortByKey(isc.makeReverseMap(valueMap)));
}


// A container that maps keys to arbitrary values.
// Note: This Map type does not have the same semantics as the proposed Map type of Harmony
// (ECMAScript 6). In particular, two Date keys are treated as the same key if they represent
// the same time.
isc.defineClass("Map", null, null, true).addClassProperties({
    _nextUniqueMapNumber: 1,
    _valuePropertyNamePrefix: "_valueInMap",

    _dateCompareFn : function (t1, d2) {
        return (t1 - d2.getTime());
    },

    _arePrimitiveKeysEqual : function (k1, k2) {
        return (k1 === k2 ||
                // Note: The check of the `typeof' is needed because `isNaN("a string")' is true!
                (typeof k1 === "number" && isNaN(k1) &&
                 typeof k2 === "number" && isNaN(k2)));
    }
});

isc.Map.addProperties({
    //> @attr Map.size (Integer : 0 : R)
    // The current number of key-value pairs in this map.
    //<

    init : function () {
        this.Super("init", arguments);

        // _valuePropertyName is the name of a special property set on objects that are added
        // as keys to this map. The value of this property is the value in this map.
        var uniqueMapNumber = this._uniqueMapNumber = isc.Map._nextUniqueMapNumber++;
        this._valuePropertyName = isc.Map._valuePropertyNamePrefix + uniqueMapNumber;

        if (this._cloning) return;

        // The times of any Date objects added as keys to this map. We store the times instead
        // of the actual Date objects because JS Dates are not immutable.
        // The times are kept sorted for efficient lookup via Array._binarySearch(). The value
        // for a Date key in the map is located at the same index in _valueForTimeIndex as its
        // time's index in _times.
        this._times = [];
        this._valueForTimeIndex = [];

        // An array of the objects added as keys to this map. This array is not accessed except
        // in remove() and clear() because if an object is a key of this map, then the value
        // in the map is stored in the object at the _valuePropertyName property.
        // We keep a list of the objects so that if clear() is called with some objects still
        // used as keys in this map, we can delete the _valuePropertyName property on those objects.
        this._objectKeys = [];

        // A JavaScriptObject map from the stringified primitive value keys to the actual primitive
        // value(s) that are used as keys in this map.
        // If two, different primitive values stringify to the same string, then the value within
        // this JavaScriptObject map is an array of the actual primitive values.
        this._primitiveKeysForStringifiedKey = {};
        this._valuesForStringifiedKey = {};

        this.size = 0;
        
    },

    destroy : function () {
        this.clear();
        this.Super("destroy", arguments);
    },

    hasKey : function (key) {
        var uniqueValue = {};
        return this.get(key, uniqueValue) !== uniqueValue;
    },

    get : function (key, defaultValue) {
        if (isc.isA.Date(key)) {
            var timeIndex = isc.Array._binarySearch(this._times, key, isc.Map._dateCompareFn);
            if (timeIndex < 0) return defaultValue;
            return this._valueForTimeIndex[timeIndex];
        }

        if (isc.isAn.Object(key)) {
            var valuePropertyName = this._valuePropertyName;
            if (!Object.hasOwn(key, valuePropertyName)) return defaultValue;
            return key[valuePropertyName];
        }

        if (!Object.hasOwn(this._primitiveKeysForStringifiedKey, key)) return defaultValue;

        var primitiveKeys = this._primitiveKeysForStringifiedKey[key],
            primitiveKey;
        if (isc.isAn.Array(primitiveKeys)) {
            this._assert(primitiveKeys.length >= 2);
            for (var i = 0; i < primitiveKeys.length; ++i) {
                primitiveKey = primitiveKeys[i];
                if (isc.Map._arePrimitiveKeysEqual(primitiveKey, key)) {
                    var values = this._valuesForStringifiedKey[key];
                    this._assert(isc.isAn.Array(values) && primitiveKeys.length == values.length);
                    return values[i];
                }
            }
            return defaultValue;
        }

        primitiveKey = primitiveKeys;
        if (!isc.Map._arePrimitiveKeysEqual(primitiveKey, key)) return defaultValue;
        return this._valuesForStringifiedKey[key];
    },

    put : function (key, value) {
        if (isc.isA.Date(key)) {
            var timeIndex = isc.Array._binarySearch(this._times, key, isc.Map._dateCompareFn);
            if (timeIndex >= 0) {
                this._valueForTimeIndex[timeIndex] = value;
                return;
            }

            timeIndex = -timeIndex - 1;
            this._times.addAt(key.getTime(), timeIndex);
            this._valueForTimeIndex.addAt(value, timeIndex);

        } else if (isc.isAn.Object(key)) {
            var valuePropertyName = this._valuePropertyName;
            if (Object.hasOwn(key, valuePropertyName)) {
                key[valuePropertyName] = value;
                return;
            }

            key[valuePropertyName] = value;
            this._objectKeys.add(key);

        } else if (Object.hasOwn(this._primitiveKeysForStringifiedKey, key)) {
            var primitiveKeys = this._primitiveKeysForStringifiedKey[key],
                primitiveKey,
                values;
            if (isc.isAn.Array(primitiveKeys)) {
                this._assert(primitiveKeys.length >= 2);
                for (var i = 0; i < primitiveKeys.length; ++i) {
                    primitiveKey = primitiveKeys[i];
                    if (isc.Map._arePrimitiveKeysEqual(primitiveKey, key)) {
                        values = this._valuesForStringifiedKey[key];
                        this._assert(isc.isAn.Array(values) && primitiveKeys.length == values.length);
                        values[i] = value;
                        return;
                    }
                }

                primitiveKeys.add(key);
                this._valuesForStringifiedKey.add(value);
            } else {
                primitiveKey = primitiveKeys;
                if (isc.Map._arePrimitiveKeysEqual(primitiveKey, key)) {
                    this._valuesForStringifiedKey[key] = value;
                    return;
                }

                this._primitiveKeysForStringifiedKey[key] = primitiveKeys = [primitiveKey, key];
                this._valuesForStringifiedKey[key] = [this._valuesForStringifiedKey[key], value];
            }

        } else {
            this._primitiveKeysForStringifiedKey[key] = key;
            this._valuesForStringifiedKey[key] = value;
        }

        ++this.size;
        
    },

    remove : function (key) {
        if (isc.isA.Date(key)) {
            var timeIndex = isc.Array._binarySearch(this._times, key, isc.Map._dateCompareFn);
            if (timeIndex < 0) return false;

            this._times.removeAt(timeIndex);
            this._valueForTimeIndex.removeAt(timeIndex);

        } else if (isc.isAn.Object(key)) {
            var valuePropertyName = this._valuePropertyName;
            if (!Object.hasOwn(key, valuePropertyName)) return false;

            delete key[valuePropertyName];
            this._objectKeys.remove(key);

        } else if (!Object.hasOwn(this._primitiveKeysForStringifiedKey, key)) {
            return false;

        } else {
            var primitiveKeys = this._primitiveKeysForStringifiedKey[key],
                primitiveKey;
            if (isc.isAn.Array(primitiveKeys)) {
                this._assert(primitiveKeys.length >= 2);
                var i = 0;
                for (; i < primitiveKeys.length; ++i) {
                    primitiveKey = primitiveKeys[i];
                    if (isc.Map._arePrimitiveKeysEqual(primitiveKey, key)) {
                        break;
                    }
                }
                if (i >= primitiveKeys.length) return false;

                var values = this._valuesForStringifiedKey[key];
                this._assert(isc.isAn.Array(values) && primitiveKeys.length == values.length);

                primitiveKeys.removeAt(i);
                values.removeAt(i);

                if (primitiveKeys.length == 1) {
                    this._primitiveKeysForStringifiedKey[key] = primitiveKeys[0];
                    this._valuesForStringifiedKey[key] = values[0];
                }

            } else {
                primitiveKey = primitiveKeys;
                if (!isc.Map._arePrimitiveKeysEqual(primitiveKey, key)) return false;

                delete this._primitiveKeysForStringifiedKey[key];
                delete this._valuesForStringifiedKey[key];
            }
        }

        --this.size;
        
        return true;
    },

    removeAll : function (keys) {
        for (var i = 0, numKeys = keys.getLength(); i < numKeys; ++i) {
            this.remove(keys.get(i));
        }
    },

    clear : function () {
        this._times.setLength(0);
        this._valueForTimeIndex.setLength(0);

        var objectKeys = this._objectKeys,
            valuePropertyName = this._valuePropertyName;
        for (var i = 0; i < objectKeys.length; ++i) {
            delete objectKeys[i][valuePropertyName];
        }
        objectKeys.setLength(0);

        this._primitiveKeysForStringifiedKey = {};
        this._valuesForStringifiedKey = {};

        this.size = 0;
        
    },

    isEmpty : function () {
        return this.size == 0;
    },

    getKeys : function () {
        var result = [];

        var times = this._times;
        for (var i = 0; i < times.length; ++i) {
            result.add(new Date(times[i]));
        }

        result.addAll(this._objectKeys);

        var primitiveKeysForStringifiedKey = this._primitiveKeysForStringifiedKey,
            stringifiedKeys = isc.getKeys(primitiveKeysForStringifiedKey);
        for (var i = 0; i < stringifiedKeys.length; ++i) {
            var primitiveKeys = primitiveKeysForStringifiedKey[stringifiedKeys[i]];
            if (isc.isAn.Array(primitiveKeys)) {
                this._assert(primitiveKeys.length >= 2);
                result.addAll(primitiveKeys);
            } else {
                var primitiveKey = primitiveKeys;
                result.add(primitiveKey);
            }
        }

        return result;
    },

    _clonable: true,
    clone : function (cloneForOrigObjectMap) {
        var clone = this.getClass().create({ // use getClass() in case this is a Set instance
            size: this.size,
            _cloning: true
        });
        delete clone._cloning;
        clone._times = isc.Comm._clone(this._times, !!cloneForOrigObjectMap, cloneForOrigObjectMap);
        clone._valueForTimeIndex = isc.Comm._clone(this._valueForTimeIndex, !!cloneForOrigObjectMap, cloneForOrigObjectMap);

        // the object keys are used identically, but the values are cloned
        var cloneObjectKeys = clone._objectKeys = this._objectKeys.duplicate(),
            cloneValuePropertyName = clone._valuePropertyName,
            thisValuePropertyName = this._valuePropertyName;
        for (var i = 0; i < cloneObjectKeys.length; ++i) {
            var sharedObjectKey = cloneObjectKeys[i];
            sharedObjectKey[cloneValuePropertyName] = isc.Comm._clone(sharedObjectKey[thisValuePropertyName], !!cloneForOrigObjectMap, cloneForOrigObjectMap);
        }

        clone._primitiveKeysForStringifiedKey = isc.Comm._clone(this._primitiveKeysForStringifiedKey, !!cloneForOrigObjectMap, cloneForOrigObjectMap);
        clone._valuesForStringifiedKey = isc.Comm._clone(this._valuesForStringifiedKey, !!cloneForOrigObjectMap, cloneForOrigObjectMap);

        
        return clone;
    }

    
});


