package com.smartgwt.sample.showcase.client.grid.appearance;

import com.smartgwt.client.types.Alignment;
import com.smartgwt.client.types.ListGridFieldType;
import com.smartgwt.client.widgets.Canvas;
import com.smartgwt.client.widgets.form.DynamicForm;
import com.smartgwt.client.widgets.form.fields.CheckboxItem;
import com.smartgwt.client.widgets.form.fields.events.ChangeEvent;
import com.smartgwt.client.widgets.form.fields.events.ChangeHandler;
import com.smartgwt.client.widgets.grid.ListGrid;
import com.smartgwt.client.widgets.grid.ListGridField;
import com.smartgwt.client.widgets.layout.VLayout;
import com.smartgwt.sample.showcase.client.PanelFactory;
import com.smartgwt.sample.showcase.client.ShowcasePanel;
import com.smartgwt.sample.showcase.client.data.CountrySampleData;

public class AlternateRecordStyleSample extends ShowcasePanel {
    private static final String DESCRIPTION = "This sample demonstrates applying alternate record"+
                "and field styles to cells in a grid, to provide a ledger-like visual distinction between "+
                "rows and/or columns without showing borders. Click the \"Alternate Record Styles\" checkbox "+
                "to show a different background-color in alternate rows, or the \"Alternate Field Styles\" "+
                "checkbox to see a similar visual distinction for alternate columns. When both checkboxes "+
                "are checked, both alternate rows and alternate columns are colored and, where they intersect, "+
                "a separate background-color is applied.";

    public static class Factory implements PanelFactory {
        private String id;

        public ShowcasePanel create() {
            AlternateRecordStyleSample panel = new AlternateRecordStyleSample();
            id = panel.getID();
            return panel;
        }

        public String getID() {
            return id;
        }

        public String getDescription() {
            return DESCRIPTION;
        }
    }

    @Override
    protected boolean isTopIntro() {
        return true;
    }
    
    public Canvas getViewPanel() {

        VLayout layout = new VLayout(10);

        final ListGrid countryGrid = new ListGrid();
        countryGrid.setWidth(500);
        countryGrid.setHeight(224);
        countryGrid.setAlternateRecordStyles(false);
        countryGrid.setAlternateFieldStyles(false);
        countryGrid.setShowAllRecords(true);

        ListGridField countryCodeField = new ListGridField("countryCode", "Code", 70);
        countryCodeField.setAlign(Alignment.CENTER);        
        ListGridField nameField = new ListGridField("countryName", "Country");
        ListGridField capitalField = new ListGridField("capital", "Capital");
        ListGridField continentField = new ListGridField("continent", "Continent");
        countryGrid.setFields(countryCodeField, nameField, capitalField, continentField);
        countryGrid.setCanResizeFields(true);
        countryGrid.setData(CountrySampleData.getRecords());
        layout.addMember(countryGrid);

        DynamicForm form = new DynamicForm();
        form.setWidth(300);
        form.setNumCols(4);

        CheckboxItem cbRecordStyleItem = new CheckboxItem("cbRecordStyleItem", "Alternate Record Styles");
        cbRecordStyleItem.setWidth(150);
        cbRecordStyleItem.addChangeHandler(new ChangeHandler() {
            @Override
            public void onChange(ChangeEvent event) {
                boolean checked = (Boolean) event.getValue();
                countryGrid.setAlternateRecordStyles(checked);
            }
        });
        CheckboxItem cbFieldStyleItem = new CheckboxItem("cbFieldStyleItem", "Alternate Field Styles");
        cbFieldStyleItem.setWidth(150);
        cbFieldStyleItem.addChangeHandler(new ChangeHandler() {
            @Override
            public void onChange(ChangeEvent event) {
                boolean checked = (Boolean) event.getValue();
                countryGrid.setAlternateFieldStyles(checked);
            }
        });
        form.setItems(cbRecordStyleItem, cbFieldStyleItem);
        layout.addMember(form);

        return layout;
    }

    public String getIntro() {
        return DESCRIPTION;
    }

}