/*
 * Decompiled with CFR 0.152.
 */
package org.htmlparser.parserapplications.filterbuilder;

import java.awt.Component;
import java.util.Vector;
import javax.swing.JTree;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.TreeCellRenderer;
import org.htmlparser.Attribute;
import org.htmlparser.Node;
import org.htmlparser.nodes.TagNode;
import org.htmlparser.nodes.TextNode;
import org.htmlparser.util.Translate;

public class HtmlTreeCellRenderer
extends DefaultTreeCellRenderer
implements TreeCellRenderer {
    public HtmlTreeCellRenderer() {
        this.setLeafIcon(null);
        this.setClosedIcon(null);
        this.setOpenIcon(null);
    }

    public String toHtml(TagNode tag) {
        Attribute attribute;
        int i;
        int length = 2;
        Vector attributes = tag.getAttributesEx();
        int size = attributes.size();
        for (i = 0; i < size; ++i) {
            attribute = (Attribute)attributes.elementAt(i);
            length += attribute.getLength();
        }
        StringBuffer ret = new StringBuffer(length);
        ret.append("<");
        for (i = 0; i < size; ++i) {
            attribute = (Attribute)attributes.elementAt(i);
            attribute.toString(ret);
        }
        ret.append(">");
        String s = Translate.encode((String)ret.toString());
        boolean children = null != tag.getChildren();
        ret = new StringBuffer(s.length() + 13 + (children ? 16 : 0));
        ret.append("<html>");
        if (children) {
            ret.append("<font color=\"blue\">");
        }
        ret.append(s);
        if (children) {
            ret.append("</font>");
        }
        ret.append("</html>");
        return ret.toString();
    }

    public String toText(TextNode node) {
        int startpos = node.getStartPosition();
        int endpos = node.getEndPosition();
        StringBuffer ret = new StringBuffer(endpos - startpos + 20);
        String s = node.toHtml();
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            switch (c) {
                case '\t': {
                    ret.append("\\t");
                    break;
                }
                case '\n': {
                    ret.append("\\n");
                    break;
                }
                case '\r': {
                    ret.append("\\r");
                    break;
                }
                default: {
                    ret.append(c);
                }
            }
            if (77 > ret.length()) continue;
            ret.append("...");
            break;
        }
        return ret.toString();
    }

    public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        super.getTreeCellRendererComponent(tree, value, selected, expanded, leaf, row, hasFocus);
        Node node = (Node)value;
        if (node instanceof TagNode) {
            this.setText(this.toHtml((TagNode)node));
        } else if (node instanceof TextNode) {
            this.setText(this.toText((TextNode)node));
        } else {
            this.setText(node.toHtml());
        }
        return this;
    }
}

