package com.smartgwt.client.types;


/*
 * Smart GWT (GWT for SmartClient)
 * Copyright 2008 and beyond, Isomorphic Software, Inc.
 *
 * Smart GWT is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License version 3
 * as published by the Free Software Foundation.  Smart GWT is also
 * available under typical commercial license terms - see
 * http://smartclient.com/license
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 */
/* sgwtgen */
 
/**
 * Enumeration of the supported authentication types for the {@link com.smartgwt.client.docs.ServerRestConnector
 * RestConnector} implementation.  Note, all of these authentication types are secure, but only if you use HTTPS
 */
public enum RESTAuthenticationType implements ValueEnum {
    /**
     * Use a "Basic" HTTP Authorization header. Requires both a  {@link
     * com.smartgwt.client.docs.serverds.RESTAuthentication#username username} and a {@link
     * com.smartgwt.client.docs.serverds.RESTAuthentication#password password}, which are combined and Base64-encoded in the
     * HTTP request header. Note, you can also use  this auth type for services that allow for Basic authentication using a
     * combination of user and long-lived API key (ie, an API key or token that is generated by the auth server and is used
     * instead of a password for this particular client application, but does not need to be  regularly renewed)
     * <P>
     * If this enumerated value is used in a {@link com.smartgwt.client.docs.ComponentXML Component XML}
     * file or server-side DataSource descriptor (.ds.xml file), use the value "basic".
     */
    BASIC("basic"),
    /**
     * Use a "Bearer" HTTP Authorization header with a bearer token obtained from an OAuth 2.0  client credentials server or
     * other auth scheme that can generate bearer tokens (also known  as API tokens or API keys). This auth type can handle
     * both long-lived tokens, such as API keys that are generated once for an application and never change, and so-called 
     * "access tokens" that are only valid for a limited period of time - usually no more than a  few hours - and must be
     * refreshed when they expire. See {@link com.smartgwt.client.docs.serverds.RESTAuthentication#dataSource
     * RESTAuthentication.dataSource}
     * <P>
     * If this enumerated value is used in a {@link com.smartgwt.client.docs.ComponentXML Component XML}
     * file or server-side DataSource descriptor (.ds.xml file), use the value "bearerToken".
     */
    BEARERTOKEN("bearerToken"),
    /**
     * Use a manually-constructed HTTP Authorization header. This auth type requires an  {@link
     * com.smartgwt.client.docs.serverds.RESTAuthentication#dataSource authentication dataSource} that returns a record 
     * containing a well-formed Authorization header value in a field called  "authorizationHeader" (this can be overridden,
     * see the authentication dataSource docs  mentioned above)
     * <P>
     * If this enumerated value is used in a {@link com.smartgwt.client.docs.ComponentXML Component XML}
     * file or server-side DataSource descriptor (.ds.xml file), use the value "authHeader".
     */
    AUTHHEADER("authHeader");
    private String value;

    RESTAuthenticationType(String value) {
        this.value = value;
    }

    public String getValue() {
        return this.value;
    }
}
