package com.smartgwt.client.types;


/*
 * Smart GWT (GWT for SmartClient)
 * Copyright 2008 and beyond, Isomorphic Software, Inc.
 *
 * Smart GWT is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License version 3
 * as published by the Free Software Foundation.  Smart GWT is also
 * available under typical commercial license terms - see
 * http://smartclient.com/license
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 */
/* sgwtgen */
 
/**
 */
public enum DataQuestionStepType implements ValueEnum {
    /**
     * Prepares a summarization of the {@link com.smartgwt.client.ai.UserAIRequest} containing the end user's data question, if
     * necessary.
     * <P>
     * If this enumerated value is used in a {@link com.smartgwt.client.docs.ComponentXML Component XML}
     * file or server-side DataSource descriptor (.ds.xml file), use the value "summarizeUserAIRequest".
     */
    SUMMARIZEUSERAIREQUEST("summarizeUserAIRequest"),
    /**
     * Asks AI to determine a next step. Only a subset of step types are offered as choices to AI.
     * <P>
     * If this enumerated value is used in a {@link com.smartgwt.client.docs.ComponentXML Component XML}
     * file or server-side DataSource descriptor (.ds.xml file), use the value "determineNextStep".
     */
    DETERMINENEXTSTEP("determineNextStep"),
    /**
     * Asks AI to construct a {@link com.smartgwt.client.data.DSRequest} query.
     * <P>
     * If this enumerated value is used in a {@link com.smartgwt.client.docs.ComponentXML Component XML}
     * file or server-side DataSource descriptor (.ds.xml file), use the value "makeQuery".
     */
    MAKEQUERY("makeQuery"),
    /**
     * Validates an AI-generated <code>DSRequest</code> against schema, identifying potential errors.
     * <P>
     * If this enumerated value is used in a {@link com.smartgwt.client.docs.ComponentXML Component XML}
     * file or server-side DataSource descriptor (.ds.xml file), use the value "validateQuery".
     */
    VALIDATEQUERY("validateQuery"),
    /**
     * Asks AI to fix a query, given the list of validation errors.
     * <P>
     * If this enumerated value is used in a {@link com.smartgwt.client.docs.ComponentXML Component XML}
     * file or server-side DataSource descriptor (.ds.xml file), use the value "fixQuery".
     */
    FIXQUERY("fixQuery"),
    /**
     * Executes a validated {@link com.smartgwt.client.data.DSRequest} query.
     * <P>
     * If this enumerated value is used in a {@link com.smartgwt.client.docs.ComponentXML Component XML}
     * file or server-side DataSource descriptor (.ds.xml file), use the value "executeQuery".
     */
    EXECUTEQUERY("executeQuery"),
    /**
     * Asks AI to summarize the results of previous steps in the context of the end user's data question and AI's described
     * purpose for each query made.
     * <P>
     * If this enumerated value is used in a {@link com.smartgwt.client.docs.ComponentXML Component XML}
     * file or server-side DataSource descriptor (.ds.xml file), use the value "summarizePrevStepResults".
     */
    SUMMARIZEPREVSTEPRESULTS("summarizePrevStepResults"),
    /**
     * Asks AI to describe the components of a dashboard to visualize the answer to a data question.
     * <P>
     * If this enumerated value is used in a {@link com.smartgwt.client.docs.ComponentXML Component XML}
     * file or server-side DataSource descriptor (.ds.xml file), use the value "createDashboard".
     */
    CREATEDASHBOARD("createDashboard"),
    /**
     * Asks AI to create a dashboard component.
     * <P>
     * If this enumerated value is used in a {@link com.smartgwt.client.docs.ComponentXML Component XML}
     * file or server-side DataSource descriptor (.ds.xml file), use the value "createDashboardComponent".
     */
    CREATEDASHBOARDCOMPONENT("createDashboardComponent"),
    /**
     * Validates an AI-generated component against schema, identifying potential errors.
     * <P>
     * If this enumerated value is used in a {@link com.smartgwt.client.docs.ComponentXML Component XML}
     * file or server-side DataSource descriptor (.ds.xml file), use the value "validateDashboardComponent".
     */
    VALIDATEDASHBOARDCOMPONENT("validateDashboardComponent"),
    /**
     * Asks AI to fix a dashboard component, given the list of validation errors.
     * <P>
     * If this enumerated value is used in a {@link com.smartgwt.client.docs.ComponentXML Component XML}
     * file or server-side DataSource descriptor (.ds.xml file), use the value "fixDashboardComponent".
     */
    FIXDASHBOARDCOMPONENT("fixDashboardComponent");
    private String value;

    DataQuestionStepType(String value) {
        this.value = value;
    }

    public String getValue() {
        return this.value;
    }
}
