
package com.smartgwt.client.docs;

/**
 * <h3>String Template Functions</h3>
 * Template functions provide a flexible way to generate dynamic text, such as AI prompts,
 *  email bodies, or custom messages shown in the UI. Templates are plain JavaScript functions
 *  that take a <code>state</code> object plus a shared support object <code>sc</code>, and
 *  optionally <code>j</code>, which is the default JSON formatter function. <code>sc</code> and
 *  <code>j</code> are described below.
 *  <p>
 *  Templates are registered on a class using  Class.registerTemplates() and later
 *  rendered with  Class.render().
 * 
 *  <h3>Defining and using a template</h3>
 *  Define templates on a class:
 *  <pre>
 *     OrderViewer.registerTemplates({
 *         orderSummaryHTML: function (s, sc, j) {
 *             return `&lt;b&gt;Order #&#36;{s.orderId}&lt;/b&gt;&lt;br&gt;
 *  Customer: &#36;{sc.escapeHTML(sc.trim(s.customerName))}&lt;br&gt;
 *  Status: &#36;{s.status}&lt;br&gt;
 *  Total: &#36;{sc.toUSCurrencyString(s.totalAmount, 2)}&lt;br&gt;
 *  `;
 *         },
 * 
 *         lineItemsHTML: function (s, sc, j) {
 *             return sc.if(s.items &amp;&amp; s.items.length &gt; 0,
 *                 "Line Items:&lt;br&gt;" + sc.for(s.items, function (item) {
 *                     return `&amp;nbsp;- &#36;{item.quantity} x &#36;{sc.escapeHTML(item.description)} (&#36;{sc.NumberUtil.toUSCurrencyString(item.price, 2)})&lt;br&gt;`;
 *                 }),
 *                 "No items on this order."
 *             );
 *         }
 *     });
 *  </pre>
 *  <p>
 *  Render a template from an instance:
 *  <pre>
 *     const orderSummaryHTML = orderViewer.render("orderSummaryHTML", {
 *         orderId: 10234,
 *         customerName: "  Smith, John  ",
 *         status: "Pending",
 *         totalAmount: 259.99
 *     });
 * 
 *     const orderLineItemsHTML = orderViewer.render("lineItemsHTML", {
 *         items: [
 *             { quantity: 2, description: "Widget A", price: 49.95 },
 *             { quantity: 1, description: "Service Plan", price: 160.09 }
 *         ]
 *     });
 *  </pre>
 * 
 *  <h3>Template Function Support Object (<code>sc</code>)</h3>
 *  Each template receives an <code>sc</code> parameter providing shared utilities:
 *  <ul>
 * <li><b>sc.json(value, [pretty])</b>: Encode to JSON using Smart GWT's {@link
 * com.smartgwt.client.util.JSONEncoder}. If
 *      <code>pretty</code> is <code>true</code>, the output is formatted with indentation.</li>
 *  <li><b>sc.if(condition, thenVal, elseVal)</b>: Inline conditional expression returning
 *      <code>thenVal</code> if <code>true</code>, otherwise <code>elseVal</code>.</li>
 *  <li><b>sc.for(array, fn)</b>: Map an array with the given function and join the results
 *      into a single string.</li>
 * <li><b>sc.trim(value)</b>: Trim leading and trailing whitespace from the given value converted
 * to a string.
 *  If the value is <code>null</code>, returns an empty string.</li>
 *  <li><b>sc.escapeHTML(value)</b>: Escape HTML in an arbitrary value converted to a string.
 *  If the value is <code>null</code>, returns an empty string.</li>
 *  </ul>
 *  <p>
 * The <code>sc</code> object also inherits from the global {@link com.smartgwt.client.util.isc}
 * object (through prototypal
 *  inheritance), so all Smart GWT APIs are available (for example, <code>sc.NumberUtil</code>
 *  references the {@link com.smartgwt.client.util.NumberUtil} class).
 */
public interface StringTemplateFunctions {
}
