/*
 * Smart GWT (GWT for SmartClient)
 * Copyright 2008 and beyond, Isomorphic Software, Inc.
 *
 * Smart GWT is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License version 3
 * as published by the Free Software Foundation.  Smart GWT is also
 * available under typical commercial license terms - see
 * http://smartclient.com/license
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 */
/* sgwtgen */
 
package com.smartgwt.client.ai;


import com.smartgwt.client.event.*;
import com.smartgwt.client.core.*;
import com.smartgwt.client.types.*;
import com.smartgwt.client.data.*;
import com.smartgwt.client.data.Record;
import com.smartgwt.client.data.events.*;
import com.smartgwt.client.browser.window.*;
import com.smartgwt.client.rpc.*;
import com.smartgwt.client.ai.*;
import com.smartgwt.client.callbacks.*;
import com.smartgwt.client.tools.*;
import com.smartgwt.client.bean.*;
import com.smartgwt.client.widgets.*;
import com.smartgwt.client.widgets.ai.*;
import com.smartgwt.client.widgets.events.*;
import com.smartgwt.client.widgets.form.*;
import com.smartgwt.client.widgets.form.validator.*;
import com.smartgwt.client.widgets.form.fields.*;
import com.smartgwt.client.widgets.tile.*;
import com.smartgwt.client.widgets.tile.events.*;
import com.smartgwt.client.widgets.grid.*;
import com.smartgwt.client.widgets.grid.events.*;
import com.smartgwt.client.widgets.chart.*;
import com.smartgwt.client.widgets.layout.*;
import com.smartgwt.client.widgets.layout.events.*;
import com.smartgwt.client.widgets.menu.*;
import com.smartgwt.client.widgets.tour.*;
import com.smartgwt.client.widgets.notify.*;
import com.smartgwt.client.widgets.rte.*;
import com.smartgwt.client.widgets.rte.events.*;
import com.smartgwt.client.widgets.ace.*;
import com.smartgwt.client.widgets.ace.events.*;
import com.smartgwt.client.widgets.tab.*;
import com.smartgwt.client.widgets.toolbar.*;
import com.smartgwt.client.widgets.tree.*;
import com.smartgwt.client.widgets.tree.events.*;
import com.smartgwt.client.widgets.tableview.*;
import com.smartgwt.client.widgets.viewer.*;
import com.smartgwt.client.widgets.calendar.*;
import com.smartgwt.client.widgets.calendar.events.*;
import com.smartgwt.client.widgets.cube.*;
import com.smartgwt.client.widgets.notify.*;
import com.smartgwt.client.widgets.drawing.*;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

import com.google.gwt.event.shared.*;
import com.google.gwt.dom.client.Element;
import com.google.gwt.user.client.ui.Widget;
import com.google.gwt.core.client.JavaScriptObject;

import com.smartgwt.client.util.*;
import com.smartgwt.client.util.events.*;
import com.smartgwt.client.util.workflow.*;
import com.smartgwt.client.util.workflow.Process; // required to override java.lang.Process
import com.smartgwt.client.util.tour.*;


/**
 * 
 */
@BeanFactory.FrameworkClass
public class ExecuteQueryDataQuestionStepResult extends DataClass {

    public static ExecuteQueryDataQuestionStepResult getOrCreateRef(JavaScriptObject jsObj) {
        if(jsObj == null) return null;
        return new ExecuteQueryDataQuestionStepResult(jsObj);
    }
        


    public ExecuteQueryDataQuestionStepResult(){
        
    }

    public ExecuteQueryDataQuestionStepResult(JavaScriptObject jsObj){
        
        setJavaScriptObject(jsObj);
    }



    // ********************* Properties / Attributes ***********************

    /**
     * If available, an estimate of the total number of rows that would be returned by the query if it were not limited by
     * {@link com.smartgwt.client.data.DSRequest#getStartRow DSRequest.startRow} and/or {@link
     * com.smartgwt.client.data.DSRequest#getEndRow DSRequest.endRow}. <p> The string is in the same format as {@link
     * com.smartgwt.client.data.DSResponse#getEstimatedTotalRows DSResponse.estimatedTotalRows}.
     *
     * @param estimatedTotalRows New estimatedTotalRows value. Default value is *initialized by the implementation*
     * @return {@link com.smartgwt.client.ai.ExecuteQueryDataQuestionStepResult ExecuteQueryDataQuestionStepResult} instance, for chaining setter calls
     */
    public ExecuteQueryDataQuestionStepResult setEstimatedTotalRows(String estimatedTotalRows) {
        return (ExecuteQueryDataQuestionStepResult)setAttribute("estimatedTotalRows", estimatedTotalRows);
    }

    /**
     * If available, an estimate of the total number of rows that would be returned by the query if it were not limited by
     * {@link com.smartgwt.client.data.DSRequest#getStartRow DSRequest.startRow} and/or {@link
     * com.smartgwt.client.data.DSRequest#getEndRow DSRequest.endRow}. <p> The string is in the same format as {@link
     * com.smartgwt.client.data.DSResponse#getEstimatedTotalRows DSResponse.estimatedTotalRows}.
     *
     * @return Current estimatedTotalRows value. Default value is *initialized by the implementation*
     */
    public String getEstimatedTotalRows()  {
        return getAttributeAsString("estimatedTotalRows");
    }
    

    /**
     * The records resulting from the query.
     *
     * @param records New records value. Default value is *initialized by the implementation*
     * @return {@link com.smartgwt.client.ai.ExecuteQueryDataQuestionStepResult ExecuteQueryDataQuestionStepResult} instance, for chaining setter calls
     */
    public ExecuteQueryDataQuestionStepResult setRecords(Record... records) {
        return (ExecuteQueryDataQuestionStepResult)setAttribute("records", records);
    }

    /**
     * The records resulting from the query.
     *
     * @return Current records value. Default value is *initialized by the implementation*
     */
    public Record[] getRecords()  {
        return com.smartgwt.client.util.ConvertTo.arrayOfRecord(getAttributeAsJavaScriptObject("records"));
    }
    

    /**
     * 
     *
     * @param step New step value. Default value is *initialized by the implementation*
     * @return {@link com.smartgwt.client.ai.ExecuteQueryDataQuestionStepResult ExecuteQueryDataQuestionStepResult} instance, for chaining setter calls
     */
    public ExecuteQueryDataQuestionStepResult setStep(ExecuteQueryDataQuestionStep step) {
        return (ExecuteQueryDataQuestionStepResult)setAttribute("step", step == null ? null : step.getJsObj());
    }

    /**
     * 
     *
     * @return Current step value. Default value is *initialized by the implementation*
     */
    public ExecuteQueryDataQuestionStep getStep()  {
        return new ExecuteQueryDataQuestionStep(getAttributeAsJavaScriptObject("step"));
    }
    

    /**
     * If available, the total number of rows that would be returned by the query if it were not limited by {@link
     * com.smartgwt.client.data.DSRequest#getStartRow DSRequest.startRow} and/or {@link
     * com.smartgwt.client.data.DSRequest#getEndRow DSRequest.endRow}. <p> This may be <code>null</code> if the exact total
     * number of rows is unknown.
     *
     * @param totalRows New totalRows value. Default value is *initialized by the implementation*
     * @return {@link com.smartgwt.client.ai.ExecuteQueryDataQuestionStepResult ExecuteQueryDataQuestionStepResult} instance, for chaining setter calls
     */
    public ExecuteQueryDataQuestionStepResult setTotalRows(Integer totalRows) {
        return (ExecuteQueryDataQuestionStepResult)setAttribute("totalRows", totalRows);
    }

    /**
     * If available, the total number of rows that would be returned by the query if it were not limited by {@link
     * com.smartgwt.client.data.DSRequest#getStartRow DSRequest.startRow} and/or {@link
     * com.smartgwt.client.data.DSRequest#getEndRow DSRequest.endRow}. <p> This may be <code>null</code> if the exact total
     * number of rows is unknown.
     *
     * @return Current totalRows value. Default value is *initialized by the implementation*
     */
    public Integer getTotalRows()  {
        return getAttributeAsInt("totalRows");
    }
    

    // ********************* Methods ***********************

    // ********************* Static Methods ***********************

    // ***********************************************************

}
