/*

  SmartClient Ajax RIA system
  Version v14.1p_2025-11-05/LGPL Deployment (2025-11-05)

  Copyright 2000 and beyond Isomorphic Software, Inc. All rights reserved.
  "SmartClient" is a trademark of Isomorphic Software, Inc.

  LICENSE NOTICE
     INSTALLATION OR USE OF THIS SOFTWARE INDICATES YOUR ACCEPTANCE OF
     ISOMORPHIC SOFTWARE LICENSE TERMS. If you have received this file
     without an accompanying Isomorphic Software license file, please
     contact licensing@isomorphic.com for details. Unauthorized copying and
     use of this software is a violation of international copyright law.

  DEVELOPMENT ONLY - DO NOT DEPLOY
     This software is provided for evaluation, training, and development
     purposes only. It may include supplementary components that are not
     licensed for deployment. The separate DEPLOY package for this release
     contains SmartClient components that are licensed for deployment.

  PROPRIETARY & PROTECTED MATERIAL
     This software contains proprietary materials that are protected by
     contract and intellectual property law. You are expressly prohibited
     from attempting to reverse engineer this software or modify this
     software for human readability.

  CONTACT ISOMORPHIC
     For more information regarding license rights and restrictions, or to
     report possible license violations, please contact Isomorphic Software
     by email (licensing@isomorphic.com) or web (www.isomorphic.com).

*/
// Default DBC validators

isc.SchemaValidator.create({
    typeName: "DataBoundComponent",
    schemaFieldName: "dataSource",

    defaultErrorMessage: "Unknown data source",
    errorMessageWithDsName: "Unknown data source '${dsName}'",

    checkValue : function (schemaField, valueOrNode, defaults, additionalContext) {
        // If something is specified as the 'dataSource', but it isn't actually a valid
        // data source, then error.
        if (valueOrNode) {
            var dataSource = this._getDataSourceProperty(schemaField, defaults, additionalContext);
            if (!dataSource) {
                var dsName = isc.isA.String(valueOrNode) ? valueOrNode : valueOrNode.ID;
                if (dsName) this.errorMessage = this.errorMessageWithDsName.evalDynamicString(this, {dsName: dsName});
                else this.errorMessage = this.defaultErrorMessage;
                return false;
            }
        }

        return true;
    }
});


isc.defineClass("DataBoundComponentSchema", "ComponentSchema");
isc.DataBoundComponentSchema.addProperties({
    init : function () {
        

        const dbcSchema = isc.DS.get("DataBoundComponent"),
            dbcSchemaFields = dbcSchema.getAllFields(),
            superDS = this.superDS(),
            // The schema for Canvas defines a 'dataSource' field, but to mark it hidden.
            // We only want to "inherit" a DBC schema field from the super DS if it is schema for
            // a DBC type.
            superDBCDS = (superDS && superDS.Constructor && isc[superDS.Constructor] &&
                          isc.isA.Function(isc[superDS.Constructor].isA) &&
                          isc[superDS.Constructor].isA("DataBoundComponent"))
                         ? superDS
                         : null;

        let schemaFields = this.fields;
        if (!schemaFields) schemaFields = this.fields = [];
        

        for (let f = 0; f < dbcSchemaFields.length; ++f) {
            const dbcSchemaField = dbcSchemaFields[f],
                fieldName = dbcSchemaField.name,
                inheritedDBCSchemaField = superDBCDS && superDBCDS.getFieldByName(fieldName);

            const redefinedSchemaField = schemaFields.find("name", fieldName);
            if (redefinedSchemaField) {
                // It is common for a DBC type to redefine the 'fields' field, to change the
                // type of Field. Also, the field may be redefined to apply inapplicable:true.
                // Otherwise, log a debug message if the component schema redefines a field,
                // as this indicates redundancy.
                
                if (fieldName != "fields" ||
                    redefinedSchemaField.inapplicable == true)
                {
                    this.logDebug("DBC component schema already has a '" + fieldName + "' field. It may be unnecessary to redefine it.", "componentSchema");
                }

                let schemaValidators = redefinedSchemaField.validators;
                if (!schemaValidators) schemaValidators = redefinedSchemaField.validators = [];

                const inheritedSchemaValidators = inheritedDBCSchemaField && inheritedDBCSchemaField.validators;
                if (isc.isA.nonemptyArray(inheritedSchemaValidators)) {
                    for (let v = 0; v < inheritedSchemaValidators.length; ++v) {
                        const validator = inheritedSchemaValidators[v];
                        if (!schemaValidators.find("type", validator.type)) {
                            schemaValidators.push(validator);
                        }
                    }
                }

                // Copy over the schema validators from the 'DataBoundComponent' schema field
                // to the redefined schema field.
                const dbcSchemaValidators = dbcSchemaField.validators;
                if (isc.isA.nonemptyArray(dbcSchemaValidators)) {
                    for (let v = 0; v < dbcSchemaValidators.length; ++v) {
                        const validator = dbcSchemaValidators[v];
                        if (!schemaValidators.find("type", validator.type)) {
                            schemaValidators.push(validator);
                        }
                    }
                }

                continue;

            } else if (inheritedDBCSchemaField) {
                schemaFields.push(superDBCDS.cloneField(inheritedDBCSchemaField));
                continue;
            }

            schemaFields.push(dbcSchema.cloneField(dbcSchemaField));
        }

        const result = this.Super("init", arguments);

        const alwaysValidateSchemaFieldNames = this.alwaysValidateSchemaFieldNames,
            dbcAlwaysValidateSchemaFieldNames = dbcSchema.alwaysValidateSchemaFieldNames;
        for (let n = 0; n < dbcAlwaysValidateSchemaFieldNames.length; ++n) {
            var dbcAlwaysValidateSchemaFieldName = dbcAlwaysValidateSchemaFieldNames[n];
            if (!alwaysValidateSchemaFieldNames.contains(dbcAlwaysValidateSchemaFieldName)) {
                alwaysValidateSchemaFieldNames.push(dbcAlwaysValidateSchemaFieldName);
            }
        }

        return result;
    }
});
