package com.smartgwt.client.types;


/*
 * Smart GWT (GWT for SmartClient)
 * Copyright 2008 and beyond, Isomorphic Software, Inc.
 *
 * Smart GWT is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License version 3
 * as published by the Free Software Foundation.  Smart GWT is also
 * available under typical commercial license terms - see
 * http://smartclient.com/license
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 */
/* sgwtgen */
 
/**
 * The strategy used when auto-deriving the fields that make up a UnionDataSource, if no {@link
 * com.smartgwt.client.data.DataSource#getUnionFields unionFields} setting is provided.
 */
public enum UnionFieldsStrategy implements ValueEnum {
    /**
     * Only create a unioned field where all of the member dataSources have a field with the same name and data type
     * <P>
     * If this enumerated value is used in a {@link com.smartgwt.client.docs.ComponentXML Component XML}
     * file or server-side DataSource descriptor (.ds.xml file), use the value "intersect".
     */
    INTERSECT("intersect"),
    /**
     * Create a unioned field where at least two of the member dataSources have a field with the same name and data type. Any
     * member dataSources that  do not have the field will contribute a null value for that field in  the unioned dataset
     * <P>
     * If this enumerated value is used in a {@link com.smartgwt.client.docs.ComponentXML Component XML}
     * file or server-side DataSource descriptor (.ds.xml file), use the value "matching".
     */
    MATCHING("matching"),
    /**
     * Create a unioned field for every field contributed by every member dataSource. Where there are matching fields on other
     * dataSource(s), we  will union the fields as described for "matching". Where a field only  exists on one dataSource, all
     * other dataSources will contribute null for that field in the unioned dataset
     * <P>
     * If this enumerated value is used in a {@link com.smartgwt.client.docs.ComponentXML Component XML}
     * file or server-side DataSource descriptor (.ds.xml file), use the value "all".
     */
    ALL("all");
    private String value;

    UnionFieldsStrategy(String value) {
        this.value = value;
    }

    public String getValue() {
        return this.value;
    }
}
