package com.smartgwt.sample.showcase.client.dataintegration.java.form;

import com.smartgwt.client.data.AdvancedCriteria;
import com.smartgwt.client.data.Criterion;
import com.smartgwt.client.data.DataSource;
import com.smartgwt.client.data.Record;
import com.smartgwt.client.types.OperatorId;
import com.smartgwt.client.types.TopOperatorAppearance;
import com.smartgwt.client.widgets.Canvas;
import com.smartgwt.client.widgets.IButton;
import com.smartgwt.client.widgets.events.ClickEvent;
import com.smartgwt.client.widgets.events.ClickHandler;
import com.smartgwt.client.widgets.form.DynamicForm;
import com.smartgwt.client.widgets.form.FilterBuilder;
import com.smartgwt.client.widgets.grid.ListGrid;
import com.smartgwt.client.widgets.grid.ListGridField;
import com.smartgwt.client.widgets.layout.VStack;
import com.smartgwt.sample.showcase.client.PanelFactory;
import com.smartgwt.sample.showcase.client.ShowcasePanel;

public class RequiredCriteriaSample extends ShowcasePanel {

    private static final String DESCRIPTION = 
        "This SmartGWT FilterBuilder is configured to fetch data from an operation binding that requires criteria be provided for `area` & `population` fields. Change or remove either from the default criteria and click the Filter button to verify that the server enforces this rule.";

    public static class Factory implements PanelFactory {
        private String id;

        public String getID() {
            return id;
        }

        public String getDescription() {
            return DESCRIPTION;
        }
        
        public ShowcasePanel create() {
         	RequiredCriteriaSample panel = new RequiredCriteriaSample();
            id = panel.getID();
            return panel;
        }
    }

    public String getIntro() {
        return DESCRIPTION;
    }
    
    public Canvas getViewPanel() {

        DataSource worldDS = DataSource.get("worldDS");
        
        final FilterBuilder countryFilter = new FilterBuilder();
        countryFilter.setTopOperatorAppearance(TopOperatorAppearance.RADIO);
        DynamicForm radioOperatorFormProperties = new DynamicForm();
        radioOperatorFormProperties.setWidth(600);
        countryFilter.setAutoChildProperties("radioOperatorForm", radioOperatorFormProperties);
        countryFilter.setDataSource(worldDS);
        countryFilter.setCriteria(new AdvancedCriteria(OperatorId.AND, new Criterion[] {
                new Criterion("area", OperatorId.GREATER_THAN, 50),
                new Criterion("population", OperatorId.GREATER_THAN, 100000)
        }));

        final ListGrid countryList = new ListGrid();
        countryList.setHeight(224);
        countryList.setDataSource(worldDS);
        countryList.setFetchOperation("fetchByRequiredCriterion");
        countryList.setFields(
                new ListGridField("countryName"),
                new ListGridField("continent"),
                new ListGridField("population"),
                new ListGridField("area"),
                new ListGridField("gdp"),
                new ListGridField("independence", 100)
        );
        
        IButton filterButton = new IButton("Filter");
        filterButton.addClickHandler(new ClickHandler() {
            @Override
            public void onClick(ClickEvent event) {
                countryList.setData(new Record[0]);
                countryList.filterData(countryFilter.getCriteria());
            }
        });
        
        VStack layout = new VStack(10);
        layout.setWidth(600);
        layout.addMembers(countryFilter, filterButton, countryList);

        return layout;
    }
}