/*
 * Isomorphic SmartGWT web presentation layer
 * Copyright 2000 and beyond Isomorphic Software, Inc.
 *
 * OWNERSHIP NOTICE
 * Isomorphic Software owns and reserves all rights not expressly granted in this source code,
 * including all intellectual property rights to the structure, sequence, and format of this code
 * and to all designs, interfaces, algorithms, schema, protocols, and inventions expressed herein.
 *
 *  If you have any questions, please email <sourcecode@isomorphic.com>.
 *
 *  This entire comment must accompany any portion of Isomorphic Software source code that is
 *  copied or moved from this file.
 */
package com.smartgwt.sample.showcase.client.chart;

import com.smartgwt.client.data.Record;

public class MultiSeriesChartData extends Record {

    public MultiSeriesChartData(String time, float value, String region) {
        setAttribute("time", time);
        setAttribute("value", value);
        setAttribute("region", region);
    }

    public static MultiSeriesChartData[] getData() {
        return new MultiSeriesChartData[] {
            new MultiSeriesChartData("1/1/2018", 108.88f, "North"),
            new MultiSeriesChartData("1/1/2018", 891.93f, "South"),
            new MultiSeriesChartData("1/1/2018", 715.13f, "East"),
            new MultiSeriesChartData("1/1/2018", 559.34f, "West"),
            new MultiSeriesChartData("2/1/2018", 626.63f, "North"),
            new MultiSeriesChartData("2/1/2018", 637.73f, "South"),
            new MultiSeriesChartData("2/1/2018", 976.97f, "East"),
            new MultiSeriesChartData("2/1/2018", 216.27f, "West"),
            new MultiSeriesChartData("3/1/2018",  799.18f, "North"),
            new MultiSeriesChartData("3/1/2018",  916.38f, "South"),
            new MultiSeriesChartData("3/1/2018",  853.82f, "East"),
            new MultiSeriesChartData("3/1/2018",  344.79f, "West"),
            new MultiSeriesChartData("4/1/2018",  707.1f, "North"),
            new MultiSeriesChartData("4/1/2018",  796.73f, "South"),
            new MultiSeriesChartData("4/1/2018",  590.05f, "East"),
            new MultiSeriesChartData("4/1/2018",  209.03f, "West"),
            new MultiSeriesChartData("5/1/2018",  321.58f, "North"),
            new MultiSeriesChartData("5/1/2018",  363.25f, "South"),
            new MultiSeriesChartData("5/1/2018",  446.66f, "East"),
            new MultiSeriesChartData("5/1/2018",  338.79f, "West"),
            new MultiSeriesChartData("6/1/2018",  423.43f, "North"),
            new MultiSeriesChartData("6/1/2018",  216.04f, "South"),
            new MultiSeriesChartData("6/1/2018",  511.3f, "East"),
            new MultiSeriesChartData("6/1/2018",  292.49f, "West"),
            new MultiSeriesChartData("7/1/2018",  837.1f, "North"),
            new MultiSeriesChartData("7/1/2018",  970.83f, "South"),
            new MultiSeriesChartData("7/1/2018",  888.2f, "East"),
            new MultiSeriesChartData("7/1/2018",  842.14f, "West"),
            new MultiSeriesChartData("8/1/2018",  975.65f, "North"),
            new MultiSeriesChartData("8/1/2018",  758.96f, "South"),
            new MultiSeriesChartData("8/1/2018",  853.26f, "East"),
            new MultiSeriesChartData("8/1/2018",  103.42f, "West"),
            new MultiSeriesChartData("9/1/2018",  440.78f, "North"),
            new MultiSeriesChartData("9/1/2018",  727.4f, "South"),
            new MultiSeriesChartData("9/1/2018",  822.97f, "East"),
            new MultiSeriesChartData("9/1/2018",  405.61f, "West"),
            new MultiSeriesChartData("10/1/2018",  327.79f, "North"),
            new MultiSeriesChartData("10/1/2018",  538.75f, "South"),
            new MultiSeriesChartData("10/1/2018",  854.46f, "East"),
            new MultiSeriesChartData("10/1/2018",  106.61f, "West"),
            new MultiSeriesChartData("11/1/2018",  451.64f, "North"),
            new MultiSeriesChartData("11/1/2018",  871.23f, "South"),
            new MultiSeriesChartData("11/1/2018",  145.49f, "East"),
            new MultiSeriesChartData("11/1/2018",  829.97f, "West"),
            new MultiSeriesChartData("12/1/2018",  178.88f, "North"),
            new MultiSeriesChartData("12/1/2018",  918.7f, "South"),
            new MultiSeriesChartData("12/1/2018",  534.44f, "East"),
            new MultiSeriesChartData("12/1/2018",  964.85f, "West"),
            new MultiSeriesChartData("1/1/2019",  122.72f, "North"),
            new MultiSeriesChartData("1/1/2019",  890.61f, "South"),
            new MultiSeriesChartData("1/1/2019",  234.3f, "East"),
            new MultiSeriesChartData("1/1/2019",  166.02f, "West"),
            new MultiSeriesChartData("2/1/2019",  252.96f, "North"),
            new MultiSeriesChartData("2/1/2019",  512.08f, "South"),
            new MultiSeriesChartData("2/1/2019",  162.72f, "East"),
            new MultiSeriesChartData("2/1/2019",  853.91f, "West"),
            new MultiSeriesChartData("3/1/2019",  786.04f, "North"),
            new MultiSeriesChartData("3/1/2019",  523.83f, "South"),
            new MultiSeriesChartData("3/1/2019",  781.93f, "East"),
            new MultiSeriesChartData("3/1/2019",  714.54f, "West"),
            new MultiSeriesChartData("4/1/2019",  490.04f, "North"),
            new MultiSeriesChartData("4/1/2019",  182.19f, "South"),
            new MultiSeriesChartData("4/1/2019",  258.83f, "East"),
            new MultiSeriesChartData("4/1/2019",  199.57f, "West"),
            new MultiSeriesChartData("5/1/2019",  232.65f, "North"),
            new MultiSeriesChartData("5/1/2019",  759.15f, "South"),
            new MultiSeriesChartData("5/1/2019",  134.91f, "East"),
            new MultiSeriesChartData("5/1/2019",  269.29f, "West"),
            new MultiSeriesChartData("6/1/2019",  436.18f, "North"),
            new MultiSeriesChartData("6/1/2019",  423.31f, "South"),
            new MultiSeriesChartData("6/1/2019",  592.31f, "East"),
            new MultiSeriesChartData("6/1/2019",  677.62f, "West"),
            new MultiSeriesChartData("7/1/2019",  667.57f, "North"),
            new MultiSeriesChartData("7/1/2019",  834.87f, "South"),
            new MultiSeriesChartData("7/1/2019",  953.77f, "East"),
            new MultiSeriesChartData("7/1/2019",  902.08f, "West"),
            new MultiSeriesChartData("8/1/2019",  485.39f, "North"),
            new MultiSeriesChartData("8/1/2019",  455.7f, "South"),
            new MultiSeriesChartData("8/1/2019",  182.68f, "East"),
            new MultiSeriesChartData("8/1/2019",  213.83f, "West"),
            new MultiSeriesChartData("9/1/2019",  799.83f, "North"),
            new MultiSeriesChartData("9/1/2019",  239.27f, "South"),
            new MultiSeriesChartData("9/1/2019",  383.04f, "East"),
            new MultiSeriesChartData("9/1/2019",  392.67f, "West"),
            new MultiSeriesChartData("10/1/2019",  533.71f, "North"),
            new MultiSeriesChartData("10/1/2019",  352.66f, "South"),
            new MultiSeriesChartData("10/1/2019",  299.48f, "East"),
            new MultiSeriesChartData("10/1/2019",  983.99f, "West"),
            new MultiSeriesChartData("11/1/2019",  752.46f, "North"),
            new MultiSeriesChartData("11/1/2019",  710.61f, "South"),
            new MultiSeriesChartData("11/1/2019",  817.26f, "East"),
            new MultiSeriesChartData("11/1/2019",  798.84f, "West"),
            new MultiSeriesChartData("12/1/2019",  349.16f, "North"),
            new MultiSeriesChartData("12/1/2019",  645.47f, "South"),
            new MultiSeriesChartData("12/1/2019",  462.25f, "East"),
            new MultiSeriesChartData("12/1/2019",  413.88f, "West"),
            new MultiSeriesChartData("1/1/2020",  107.5f, "North"),
            new MultiSeriesChartData("1/1/2020",  237.2f, "South"),
            new MultiSeriesChartData("1/1/2020",  900.95f, "East"),
            new MultiSeriesChartData("1/1/2020",  671.39f, "West"),
            new MultiSeriesChartData("2/1/2020",  201.79f, "North"),
            new MultiSeriesChartData("2/1/2020",  398.4f, "South"),
            new MultiSeriesChartData("2/1/2020",  440.5f, "East"),
            new MultiSeriesChartData("2/1/2020",  179.28f, "West"),
            new MultiSeriesChartData("3/1/2020",  696.97f, "North"),
            new MultiSeriesChartData("3/1/2020",  572.3f, "South"),
            new MultiSeriesChartData("3/1/2020",  528.65f, "East"),
            new MultiSeriesChartData("3/1/2020",  811.09f, "West"),
            new MultiSeriesChartData("4/1/2020",  482.62f, "North"),
            new MultiSeriesChartData("4/1/2020",  657.75f, "South"),
            new MultiSeriesChartData("4/1/2020",  253.78f, "East"),
            new MultiSeriesChartData("4/1/2020",  205.98f, "West"),
            new MultiSeriesChartData("5/1/2020",  602.92f, "North"),
            new MultiSeriesChartData("5/1/2020",  659.21f, "South"),
            new MultiSeriesChartData("5/1/2020",  844.88f, "East"),
            new MultiSeriesChartData("5/1/2020",  268.72f, "West"),
            new MultiSeriesChartData("6/1/2020",  961.68f, "North"),
            new MultiSeriesChartData("6/1/2020",  367.78f, "South"),
            new MultiSeriesChartData("6/1/2020",  171.6f, "East"),
            new MultiSeriesChartData("6/1/2020",  669.74f, "West"),
            new MultiSeriesChartData("7/1/2020",  157.36f, "North"),
            new MultiSeriesChartData("7/1/2020",  781.19f, "South"),
            new MultiSeriesChartData("7/1/2020",  244.19f, "East"),
            new MultiSeriesChartData("7/1/2020",  345.07f, "West"),
            new MultiSeriesChartData("8/1/2020",  803.01f, "North"),
            new MultiSeriesChartData("8/1/2020",  398.78f, "South"),
            new MultiSeriesChartData("8/1/2020",  713.52f, "East"),
            new MultiSeriesChartData("8/1/2020",  996.36f, "West"),
            new MultiSeriesChartData("9/1/2020",  942.33f, "North"),
            new MultiSeriesChartData("9/1/2020",  411.54f, "South"),
            new MultiSeriesChartData("9/1/2020",  371.09f, "East"),
            new MultiSeriesChartData("9/1/2020",  590.91f, "West"),
            new MultiSeriesChartData("10/1/2020",  874.63f, "North"),
            new MultiSeriesChartData("10/1/2020",  857.04f, "South"),
            new MultiSeriesChartData("10/1/2020",  649.05f, "East"),
            new MultiSeriesChartData("10/1/2020",  861.61f, "West"),
            new MultiSeriesChartData("11/1/2020",  789.86f, "North"),
            new MultiSeriesChartData("11/1/2020",  788.52f, "South"),
            new MultiSeriesChartData("11/1/2020",  120.13f, "East"),
            new MultiSeriesChartData("11/1/2020",  807.02f, "West"),
            new MultiSeriesChartData("12/1/2020",  268.58f, "North"),
            new MultiSeriesChartData("12/1/2020",  774.83f, "South"),
            new MultiSeriesChartData("12/1/2020",  997.72f, "East"),
            new MultiSeriesChartData("12/1/2020",  191.29f, "West")
        };
    }

}
