package com.smartgwt.sample.client;

import com.smartgwt.client.types.*;
import com.smartgwt.client.util.PageKeyHandler;
import com.smartgwt.client.util.Page;
import com.smartgwt.client.util.SC;
import com.smartgwt.client.data.*;
import com.smartgwt.client.widgets.*;
import com.smartgwt.client.widgets.tab.*;
import com.smartgwt.client.widgets.grid.*;
import com.smartgwt.client.widgets.form.*;
import com.smartgwt.client.widgets.form.fields.*;
import com.smartgwt.client.widgets.form.fields.events.*;
import com.smartgwt.client.widgets.form.validator.*;
import com.smartgwt.client.widgets.layout.*;
import com.smartgwt.client.browser.window.*;
import com.smartgwt.client.browser.window.events.*;


public class WindowsPane extends VLayout implements OtherWindowsChangedHandler {

    CreateNewWindowForm createWindowForm;
    WindowActionForm windowActionForm;
    WindowEventForm windowEventForm;

    public WindowsPane() {
        setMinWidth(650);

        MultiWindow.getLocalWindow().addOtherWindowsChangedHandler(this);

        createWindowForm = new CreateNewWindowForm();
        windowActionForm = new WindowActionForm();
        windowEventForm = new WindowEventForm();

        setMembers(createWindowForm, windowActionForm, windowEventForm);
        setMembersMargin(10);
    }

    public void onOtherWindowsChanged(OtherWindowsChangedEvent event) {
        createWindowForm.updateChildWindowName();
        windowActionForm.updateOtherWindowsRecords(event.getOtherWindows());
    }

}
