
package com.smartgwt.client.docs;

/**
 * <h3>DataSourceField formula functions</h3>
 * {@link com.smartgwt.client.data.DataSourceField#getFormula DataSourceField formulas} may make
 * use of functions to derive values from other fields in the record being accessed. <P> For an
 * SQL-backed dataSource, the specified <code>dataSourceField.formula</code> will be  included in
 * the SQL statements generated by the Smart GWT server. These can make use of the scalar
 * functions supported by the database engine. See the documentation for your database for a full
 * list of available functions. <P> The following functions are available to provide equivalent
 * functionality for  {@link com.smartgwt.client.data.DataSource#getClientOnly clientOnly}
 * dataSources. Nte that the database support  information is for reference only - we recommend
 * consulting your database's official documentation for definitive details of the functions
 * available to you. <P> <table border=1 cellpadding=4> <tr>  <th rowspan="2"><b>Function</b></th>
 * <th rowspan="2"><b>Description</b></th>  <th colspan="4"><b>Database support</b></th> </tr>
 * <tr>  <th><b>MySQL / MariaDB</b></th>  <th><b>PostgreSQL</b></th>  <th><b>SQL Server</b></th> 
 * <th><b>SQLite</b></th> </tr> <tr>  <th colspan="6">Math / Numeric functions</th> </tr> <tr> 
 * <td><code>round(val1, val2)</code></td>  <td>Round a numeric value up or down to the specified
 * precision</td>  <td>Y</td>  <td>Y</td>  <td>N</td>  <td>N</td> </tr> <tr> 
 * <td><code>ceil(val1)</code></td>  <td>Round a numeric value up to a whole number</td> 
 * <td>Y</td>  <td>Y</td>  <td>N <i>[available as <code>ceiling()</code>]</i></td>  <td>Y</td>
 * </tr> <tr>  <td><code>ceiling(val1)</code></td>  <td>Round a numeric value up to a whole
 * number</td>  <td>Y</td>  <td>Y</td>  <td>Y</td>  <td>N <i>[available as
 * <code>ceil()</code>]</i></td> </tr> <tr>  <td><code>floor(val1)</code></td>  <td>Round a
 * numeric value down to a whole number</td>  <td>Y</td>  <td>Y</td>  <td>Y</td>  <td>Y</td> </tr>
 * <tr>  <td><code>mod(val1,val2)</code></td>  <td>Modulus operator, also available
 * as<br><i><code>val1 % val2</code></i></td>  <td>Y</td>  <td>Y</td>  <td>N <i>[use <code>val1 %
 * val2</code> instead]</i></td>  <td>N <i>[use <code>val1 % val2</code> instead]</i></td> </tr>
 * <tr>  <td><code>greatest(val1,val2,...)</code></td>  <td>Maximum of a series of numeric
 * values</td>  <td>Y</td>  <td>Y</td>  <td>N</td>  <td>N</td> </tr> <tr> 
 * <td><code>least(val1,val2,...)</code></td>  <td>Minimum of a series of numeric values</td> 
 * <td>Y</td>  <td>Y</td>  <td>N</td>  <td>N</td> </tr> <tr>  <td><code>sin(val1)</code></td> 
 * <td>Returns the sine of the number</td>  <td>Y</td>  <td>Y</td>  <td>Y</td>  <td>Y</td> </tr>
 * <tr>  <td><code>cos(val1)</code></td>  <td>Returns the cosine of the number</td>  <td>Y</td> 
 * <td>Y</td>  <td>Y</td>  <td>Y</td> </tr> <tr>  <td><code>tan(val1)</code></td>  <td>Returns the
 * tangent of the number</td>  <td>Y</td>  <td>Y</td>  <td>Y</td>  <td>Y</td> </tr> <tr> 
 * <td><code>log(value)</code> or <code>log(base, value)</code></td>  <td>Returns the log of the
 * numeric value.   If one argument is passed, this will be the natural log. If two arguments are
 * passed   returns the log in the specified base.<br>  <td>Y</td>  <td>Differs: In PostgreSQL if
 * log() is passed a single value it will return the base 10 log rather than natural log.<br>     
 * If passed 2 values, behavior matches the client.</td>  <td>Differs: In SQL Server if log() is
 * passed two arguments, the first argument is the value and the second is the base<br>      If
 * passed 1 value, behavior matches the client.</td>  <td>Differs: In SQLite if log() is passed a
 * single value it will return the base 10 log rather than the natural log.<br>      If passed 2
 * values, behavior matches the client.</td> </tr> <tr>  <td><code>ln(val1)</code></td> 
 * <td>Returns the natural log of the numeric value</td>  <td>Y</td>  <td>Y</td>  <td>Y</td> 
 * <td>Y</td> </tr> <tr>  <td><code>log10(val1)</code></td>  <td>Returns the base-10 log of the
 * numeric value</td>  <td>Y</td>  <td>Y</td>  <td>Y</td>  <td>Y</td> </tr> <tr> 
 * <td><code>exp(val1)</code></td>  <td>Returns exponent of the numeric value</td>  <td>Y</td> 
 * <td>Y</td>  <td>Y</td>  <td>Y</td> </tr> <tr>  <td><code>abs(val1)</code></td>  <td>Returns the
 * absolute value of the numeric value</td>  <td>Y</td>  <td>Y</td>  <td>Y</td>  <td>Y</td> </tr>
 * <tr>  <td><code>power(val1,val2)</code></td>  <td>Returns val1 raised to the power of val2</td>
 * <td>Y</td>  <td>Y</td>  <td>Y</td>  <td>Y</td> </tr> <tr>  <td><code>asin(val1)</code></td> 
 * <td>Returns arcsin or inverse sine of the number</td>  <td>Y</td>  <td>Y</td>  <td>Y</td> 
 * <td>Y</td> </tr> <tr>  <td><code>acos(val1)</code></td>  <td>Returns arccos or inverse cosine
 * of the number</td>  <td>Y</td>  <td>Y</td>  <td>Y</td>  <td>Y</td> </tr> <tr> 
 * <td><code>atan(val1)</code></td>  <td>Returns arctan or inverse tangent of the number</td> 
 * <td>Y</td>  <td>Y</td>  <td>Y</td>  <td>Y</td> </tr> <tr> 
 * <td><code>atan2(val1,val2)</code></td>  <td>Returns two argument arctan</td>  <td>Y</td> 
 * <td>Y</td>  <td>Y</td>  <td>Y</td> </tr> <tr>  <td><code>random()</code></td>  <td>Returns a
 * random float value from 0 through 1, exclusive</td>  <td>N <i>[available as
 * <code>rand()</code>]</i></td>  <td>Y</td>  <td>N <i>[available as <code>rand()</code>]</i></td>
 * <td>N <i>[Note: Instead of a float between 0 and 1, SQLite's random function returns
 * pseudo-random integer between -9223372036854775808 and +9223372036854775807]</i></td> </tr>
 * <tr>  <td><code>rand()</code></td>  <td>Returns a random float value from 0 through 1,
 * exclusive</td>  <td>Y</td>  <td>N [available as <code>random()</code>]</td>  <td>Y</td> 
 * <td>N</td> </tr> <tr>  <th colspan="6">String functions</th> </tr> <tr> 
 * <td><code>concat(val1,val2,...)</code></td>  <td>Join multiple values together as a string</td>
 * <td>Y</td>  <td>Y</td>  <td>Y</td>  <td>Y</td> </tr> <tr> 
 * <td><code>substring(val,start,length)</code></td>  <td>Returns a substring from a value</td> 
 * <td>Y</td>  <td>N <i>[available as <code>substr()</code>]</i></td>  <td>Y</td>  <td>Y</td>
 * </tr> <tr>  <td><code>substr(val,start,length)</code></td>  <td>Returns a substring from a
 * value</td>  <td>Y</td>  <td>Y</td>  <td>N <i>[available as <code>substring()</code>]</i></td> 
 * <td>Y</td> </tr> <tr>  <td><code>trim(value)</code></td>  <td>Removes leading and trailing
 * space characters from a string</td>  <td>Y</td>  <td>Y</td>  <td>Y</td>  <td>Y</td> </tr> <tr> 
 * <td><code>length(value)</code></td>  <td>Returns the length of a string value</td>  <td>Y</td> 
 * <td>Y</td>  <td>N <i>[available as <code>len()</code>]</i></td>  <td>Y</td> </tr> <tr> 
 * <td><code>len(value)</code></td>  <td>Returns the length of a string value</td>  <td>N
 * <i>[available as <code>length()</code>]</i></td>  <td>N <i>[available as
 * <code>length()</code>]</i></td>  <td>Y</td>  <td>N <i>[available as
 * <code>length()</code>]</i></td> </tr> <tr> 
 * <td><code>replace(value,fromText,toText)</code></td>  <td>Replaces all occurences of
 * <code>fromText</code> with <code>toText</code></td>  <td>Y</td>  <td>Y</td>  <td>Y</td> 
 * <td>Y</td> </tr> </table>
 */
public interface FormulaFunction {
}
