/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.sql.results.graph.instantiation.internal;

import java.beans.BeanInfo;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import org.hibernate.internal.util.beans.BeanInfoHelper;
import org.hibernate.query.sqm.sql.internal.InstantiationException;
import org.hibernate.sql.results.graph.DomainResultAssembler;
import org.hibernate.sql.results.graph.instantiation.internal.ArgumentReader;
import org.hibernate.sql.results.graph.instantiation.internal.BeanInjection;
import org.hibernate.sql.results.graph.instantiation.internal.BeanInjectorField;
import org.hibernate.sql.results.graph.instantiation.internal.BeanInjectorSetter;
import org.hibernate.sql.results.graph.instantiation.internal.InstantiationHelper;
import org.hibernate.sql.results.jdbc.spi.JdbcValuesSourceProcessingOptions;
import org.hibernate.sql.results.jdbc.spi.RowProcessingState;
import org.hibernate.type.descriptor.java.JavaType;

public class DynamicInstantiationAssemblerInjectionImpl<T>
implements DomainResultAssembler<T> {
    private final JavaType<T> target;
    private final List<BeanInjection> beanInjections = new ArrayList<BeanInjection>();

    public DynamicInstantiationAssemblerInjectionImpl(JavaType<T> target, List<ArgumentReader<?>> argumentReaders) {
        this.target = target;
        Class<T> targetJavaType = target.getJavaTypeClass();
        BeanInfoHelper.visitBeanInfo(targetJavaType, beanInfo -> {
            for (ArgumentReader argumentReader : argumentReaders) {
                this.beanInjections.add(DynamicInstantiationAssemblerInjectionImpl.injection(beanInfo, argumentReader, targetJavaType));
            }
        });
        if (argumentReaders.size() != this.beanInjections.size()) {
            throw new IllegalStateException("The number of readers did not match the number of injections");
        }
    }

    private static BeanInjection injection(BeanInfo beanInfo, ArgumentReader<?> argument, Class<?> targetJavaType) {
        Class<?> argType = argument.getAssembledJavaType().getJavaTypeClass();
        String alias = argument.getAlias();
        for (PropertyDescriptor propertyDescriptor : beanInfo.getPropertyDescriptors()) {
            if (!InstantiationHelper.propertyMatches(alias, argType, propertyDescriptor)) continue;
            Method setter = propertyDescriptor.getWriteMethod();
            setter.setAccessible(true);
            return new BeanInjection(new BeanInjectorSetter(setter), argument);
        }
        Field field = InstantiationHelper.findField(targetJavaType, alias, argType);
        if (field != null) {
            return new BeanInjection(new BeanInjectorField(field), argument);
        }
        throw new InstantiationException("Cannot set field '" + alias + "' to instantiate '" + targetJavaType.getName() + "'");
    }

    @Override
    public JavaType<T> getAssembledJavaType() {
        return this.target;
    }

    @Override
    public T assemble(RowProcessingState rowProcessingState, JdbcValuesSourceProcessingOptions options) {
        T result;
        try {
            Constructor<T> constructor = this.target.getJavaTypeClass().getDeclaredConstructor(new Class[0]);
            constructor.setAccessible(true);
            result = constructor.newInstance(new Object[0]);
        }
        catch (IllegalAccessException | java.lang.InstantiationException | NoSuchMethodException | InvocationTargetException | InstantiationException e) {
            throw new InstantiationException("Error instantiating class '" + this.target.getTypeName() + "' using default constructor: " + ((Throwable)e).getMessage(), (Throwable)e);
        }
        for (BeanInjection beanInjection : this.beanInjections) {
            Object assembled = beanInjection.getValueAssembler().assemble(rowProcessingState, options);
            beanInjection.getBeanInjector().inject(result, assembled);
        }
        return result;
    }
}

