/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.internal;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiConsumer;
import org.hibernate.Incubating;
import org.hibernate.QueryParameterException;
import org.hibernate.cache.MutableCacheKeyBuilder;
import org.hibernate.cache.spi.QueryKey;
import org.hibernate.engine.internal.CacheHelper;
import org.hibernate.engine.spi.FilterDefinition;
import org.hibernate.engine.spi.LoadQueryInfluencers;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.internal.FilterImpl;
import org.hibernate.metamodel.mapping.JdbcMapping;
import org.hibernate.metamodel.mapping.MappingModelExpressible;
import org.hibernate.query.BindableType;
import org.hibernate.query.QueryParameter;
import org.hibernate.query.internal.QueryParameterBindingImpl;
import org.hibernate.query.spi.ParameterMetadataImplementor;
import org.hibernate.query.spi.QueryParameterBinding;
import org.hibernate.query.spi.QueryParameterBindings;
import org.hibernate.query.spi.QueryParameterImplementor;
import org.hibernate.type.descriptor.java.JavaType;
import org.hibernate.type.descriptor.java.JavaTypedExpressible;
import org.hibernate.type.spi.TypeConfiguration;

@Incubating
public class QueryParameterBindingsImpl
implements QueryParameterBindings {
    private final SessionFactoryImplementor sessionFactory;
    private final ParameterMetadataImplementor parameterMetadata;
    private Map<QueryParameter<?>, QueryParameterBinding<?>> parameterBindingMap;

    public static QueryParameterBindingsImpl from(ParameterMetadataImplementor parameterMetadata, SessionFactoryImplementor sessionFactory) {
        if (parameterMetadata == null) {
            throw new QueryParameterException("Query parameter metadata cannot be null");
        }
        return new QueryParameterBindingsImpl(sessionFactory, parameterMetadata);
    }

    private QueryParameterBindingsImpl(SessionFactoryImplementor sessionFactory, ParameterMetadataImplementor parameterMetadata) {
        this.sessionFactory = sessionFactory;
        this.parameterMetadata = parameterMetadata;
        this.parameterBindingMap = new ConcurrentHashMap(parameterMetadata.getParameterCount());
    }

    protected <T> QueryParameterBinding<T> makeBinding(QueryParameterImplementor<T> queryParameter) {
        if (this.parameterBindingMap == null) {
            this.parameterBindingMap = new IdentityHashMap();
        } else assert (!this.parameterBindingMap.containsKey(queryParameter));
        if (!this.parameterMetadata.containsReference(queryParameter)) {
            throw new IllegalArgumentException("Cannot create binding for parameter reference [" + queryParameter + "] - reference is not a parameter of this query");
        }
        QueryParameterBindingImpl<T> binding = new QueryParameterBindingImpl<T>(queryParameter, this.sessionFactory, this.parameterMetadata.getInferredParameterType(queryParameter));
        this.parameterBindingMap.put(queryParameter, binding);
        return binding;
    }

    @Override
    public boolean isBound(QueryParameterImplementor<?> parameter) {
        return this.getBinding(parameter).isBound();
    }

    @Override
    public <P> QueryParameterBinding<P> getBinding(QueryParameterImplementor<P> parameter) {
        if (this.parameterBindingMap == null) {
            return this.makeBinding(parameter);
        }
        QueryParameterBinding<Object> binding = this.parameterBindingMap.get(parameter);
        if (binding == null) {
            binding = this.makeBinding(parameter);
        }
        return binding;
    }

    @Override
    public <P> QueryParameterBinding<P> getBinding(int position) {
        return this.getBinding((QueryParameterImplementor<P>)this.parameterMetadata.getQueryParameter(position));
    }

    @Override
    public <P> QueryParameterBinding<P> getBinding(String name) {
        return this.getBinding((QueryParameterImplementor<P>)this.parameterMetadata.getQueryParameter(name));
    }

    @Override
    public void validate() {
        this.parameterMetadata.visitRegistrations(queryParameter -> {
            if (!this.parameterBindingMap.containsKey(queryParameter)) {
                if (queryParameter.getName() != null) {
                    throw new QueryParameterException("No argument for named parameter ':" + queryParameter.getName() + "'");
                }
                throw new QueryParameterException("No argument for ordinal parameter '?" + queryParameter.getPosition() + "'");
            }
        });
    }

    @Override
    public boolean hasAnyMultiValuedBindings() {
        for (QueryParameterBinding<?> binding : this.parameterBindingMap.values()) {
            if (!binding.isMultiValued()) continue;
            return true;
        }
        return false;
    }

    public void visitBindings(BiConsumer action) {
        this.parameterMetadata.visitRegistrations(queryParameterImplementor -> action.accept(queryParameterImplementor, this.parameterBindingMap.get(queryParameterImplementor)));
    }

    @Override
    public QueryKey.ParameterBindingsMemento generateQueryKeyMemento(SharedSessionContractImplementor session) {
        MutableCacheKeyImpl mutableCacheKey = new MutableCacheKeyImpl(this.parameterBindingMap.size());
        JavaType<Object> tenantIdentifierJavaType = session.getFactory().getTenantIdentifierJavaType();
        Object tenantId = session.getTenantIdentifierValue();
        mutableCacheKey.addValue(tenantIdentifierJavaType.getMutabilityPlan().disassemble(tenantId, session));
        mutableCacheKey.addHashCode(tenantId == null ? 0 : tenantIdentifierJavaType.extractHashCode(tenantId));
        this.parameterMetadata.visitParameters(queryParameter -> {
            QueryParameterBinding<?> binding = this.parameterBindingMap.get(queryParameter);
            assert (binding != null) : "Found unbound query parameter while generating cache key";
            MappingModelExpressible<?> mappingType = this.determineMappingType(binding, (QueryParameter<?>)queryParameter, session);
            if (binding.isMultiValued()) {
                for (Object bindValue : binding.getBindValues()) {
                    assert (bindValue != null);
                    mappingType.addToCacheKey(mutableCacheKey, bindValue, session);
                }
            } else {
                Object bindValue = binding.getBindValue();
                mappingType.addToCacheKey(mutableCacheKey, bindValue, session);
            }
        });
        LoadQueryInfluencers loadQueryInfluencers = session.getLoadQueryInfluencers();
        loadQueryInfluencers.getEnabledFilterNames().stream().sorted().forEach(filterName -> {
            FilterImpl filter = (FilterImpl)loadQueryInfluencers.getEnabledFilter((String)filterName);
            FilterDefinition filterDefinition = filter.getFilterDefinition();
            filterDefinition.getParameterNames().stream().sorted().forEach(paramName -> {
                Object paramValue = filter.getParameter((String)paramName);
                JdbcMapping jdbcMapping = filterDefinition.getParameterJdbcMapping((String)paramName);
                CacheHelper.addBasicValueToCacheKey(mutableCacheKey, paramValue, jdbcMapping, session);
            });
        });
        return mutableCacheKey.build();
    }

    private MappingModelExpressible<?> determineMappingType(QueryParameterBinding<?> binding, QueryParameter<?> queryParameter, SharedSessionContractImplementor session) {
        JavaTypedExpressible javaTypedExpressible;
        JavaType jtd;
        BindableType<?> bindType = binding.getBindType();
        if (bindType != null && bindType instanceof MappingModelExpressible) {
            return (MappingModelExpressible)((Object)bindType);
        }
        MappingModelExpressible<?> type = binding.getType();
        if (type != null) {
            return type;
        }
        TypeConfiguration typeConfiguration = session.getFactory().getTypeConfiguration();
        if (bindType instanceof JavaTypedExpressible && (jtd = (javaTypedExpressible = (JavaTypedExpressible)((Object)bindType)).getExpressibleJavaType()).getJavaTypeClass() != null) {
            return typeConfiguration.getBasicTypeForJavaType(jtd.getJavaTypeClass());
        }
        if (binding.isMultiValued()) {
            Iterator<?> iterator = binding.getBindValues().iterator();
            Object firstNonNullBindValue = null;
            if (iterator.hasNext()) {
                firstNonNullBindValue = iterator.next();
            }
            if (firstNonNullBindValue != null) {
                return typeConfiguration.getBasicTypeForJavaType(firstNonNullBindValue.getClass());
            }
        } else if (binding.getBindValue() != null) {
            return typeConfiguration.getBasicTypeForJavaType(binding.getBindValue().getClass());
        }
        if (bindType == null) {
            if (queryParameter.getName() != null) {
                throw new QueryParameterException("Could not determine mapping type for named parameter ':" + queryParameter.getName() + "'");
            }
            throw new QueryParameterException("Could not determine mapping type for ordinal parameter '?" + queryParameter.getPosition() + "'");
        }
        return typeConfiguration.getBasicTypeForJavaType(bindType.getBindableJavaType());
    }

    private static class ParameterBindingsMementoImpl
    implements QueryKey.ParameterBindingsMemento {
        final Object[] values;
        final int hashCode;

        private ParameterBindingsMementoImpl(Object[] values, int hashCode) {
            this.values = values;
            this.hashCode = hashCode;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ParameterBindingsMementoImpl queryKey = (ParameterBindingsMementoImpl)o;
            if (this.hashCode != queryKey.hashCode) {
                return false;
            }
            return Arrays.deepEquals(this.values, queryKey.values);
        }

        public int hashCode() {
            return this.hashCode;
        }
    }

    private static class MutableCacheKeyImpl
    implements MutableCacheKeyBuilder {
        final List<Object> values;
        int hashCode;

        public MutableCacheKeyImpl(int parameterBindingMapSize) {
            this.values = new ArrayList<Object>(parameterBindingMapSize);
        }

        @Override
        public void addValue(Object value) {
            this.values.add(value);
        }

        @Override
        public void addHashCode(int hashCode) {
            this.hashCode = 37 * this.hashCode + hashCode;
        }

        @Override
        public QueryKey.ParameterBindingsMemento build() {
            return new ParameterBindingsMementoImpl(this.values.toArray(new Object[0]), this.hashCode);
        }
    }
}

