/*
 * Decompiled with CFR 0.152.
 */
package com.isomorphic.servlet;

import com.isomorphic.io.IByteCounter;
import com.isomorphic.log.Logger;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpSession;
import java.util.List;

public class SessionByteCounter
implements IByteCounter {
    private Logger log = new Logger(SessionByteCounter.class.getName());
    HttpServletRequest request;
    HttpSession session;
    String formID;
    long bytesSoFar = 0L;
    long totalBytes = 0L;
    long lastUpdateMod = 0L;
    long updateSessionFrequency = 1024L;

    public SessionByteCounter(HttpServletRequest request, long totalBytes, String formID, List errors) {
        this.request = request;
        this.session = request.getSession(true);
        this.totalBytes = totalBytes;
        this.formID = formID;
        this.clearSession();
        this.session.setAttribute("totalBytes", (Object)totalBytes);
        if (errors != null) {
            this.setErrors(errors);
        }
    }

    @Override
    public long getTotalBytes() {
        return this.totalBytes;
    }

    public long getBytesSoFar() {
        return this.bytesSoFar;
    }

    @Override
    public void incrementBy(long numBytes) {
        this.bytesSoFar += numBytes;
        long mod = this.bytesSoFar / this.updateSessionFrequency;
        if (mod > this.lastUpdateMod) {
            this.lastUpdateMod = mod;
            this.session.setAttribute("bytesSoFar", (Object)this.bytesSoFar);
        }
    }

    @Override
    public void setErrors(List errors) {
        this.session.setAttribute("errors", (Object)errors);
    }

    @Override
    public List getErrors() {
        return (List)this.session.getAttribute("errors");
    }

    public void clearSession() {
        this.session.removeAttribute("errors");
        this.session.removeAttribute("totalBytes");
        this.session.removeAttribute("bytesSoFar");
    }
}

