/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.user.client.ui;

import com.google.gwt.event.shared.UmbrellaException;
import com.google.gwt.user.client.ui.IsWidget;
import com.google.gwt.user.client.ui.Widget;
import java.util.HashSet;
import java.util.Set;

public class AttachDetachException
extends UmbrellaException {
    static final Command attachCommand = new Command(){

        @Override
        public void execute(Widget w) {
            w.onAttach();
        }
    };
    static final Command detachCommand = new Command(){

        @Override
        public void execute(Widget w) {
            w.onDetach();
        }
    };

    public static void tryCommand(Iterable<Widget> hasWidgets, Command c) {
        HashSet<Throwable> caught = null;
        for (Widget w : hasWidgets) {
            try {
                c.execute(w);
            }
            catch (Throwable e) {
                if (caught == null) {
                    caught = new HashSet<Throwable>();
                }
                caught.add(e);
            }
        }
        if (caught != null) {
            throw new AttachDetachException(caught);
        }
    }

    public static void tryCommand(Command c, IsWidget ... widgets) {
        HashSet<Throwable> caught = null;
        for (IsWidget w : widgets) {
            try {
                if (w == null) continue;
                c.execute(w.asWidget());
            }
            catch (Throwable e) {
                if (caught == null) {
                    caught = new HashSet<Throwable>();
                }
                caught.add(e);
            }
        }
        if (caught != null) {
            throw new AttachDetachException(caught);
        }
    }

    public AttachDetachException(Set<Throwable> causes) {
        super(causes);
    }

    public static interface Command {
        public void execute(Widget var1);
    }
}

