/*
 * Decompiled with CFR 0.152.
 */
package com.isomorphic.sql;

import com.isomorphic.base.Base;
import com.isomorphic.datasource.DSField;
import com.isomorphic.datasource.DSRequest;
import com.isomorphic.datasource.DataSource;
import com.isomorphic.log.Logger;
import com.isomorphic.sql.CacheDriver;
import com.isomorphic.sql.DB2Driver;
import com.isomorphic.sql.MysqlDriver;
import com.isomorphic.sql.SQLDataSource;
import com.isomorphic.sql.SQLDriver;
import com.isomorphic.sql.SQLServerDriver;
import com.isomorphic.util.DataTools;
import com.isomorphic.velocity.Velocity;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class SQLValuesClause
extends Base {
    private static Logger log = new Logger(SQLValuesClause.class.getName());
    private DSRequest dsRequest;
    private SQLDataSource dataSource;
    private Map values;
    private List<Map> valueSets;
    Map field2ColumnMap = null;
    private List customValueFields = null;

    public SQLValuesClause(DSRequest request, SQLDataSource dataSource) throws Exception {
        this(request, request.getValues(), dataSource, (List)request.constraints());
    }

    public SQLValuesClause(DSRequest dsRequest, Map values, SQLDataSource dataSource, List constraints) throws Exception {
        this.dsRequest = dsRequest;
        this.dataSource = dataSource;
        this.field2ColumnMap = dataSource.getCorrectDs2NativeFieldMap();
        if (constraints != null) {
            values = DataTools.subsetMap((Map)values, (List)constraints);
        }
        if (Boolean.TRUE.equals(dsRequest.getAttribute("isBatchAdding"))) {
            this.valueSets = dsRequest.getValueSets();
            this.valueSets = this.validateValueSets(this.valueSets);
            dsRequest.setValues(this.valueSets);
        } else {
            this.values = this.filterValid(values);
        }
    }

    public static Object create(DSRequest request, SQLDataSource dataSource) throws Exception {
        Object rawValues = request.getRawValues();
        if (rawValues == null || rawValues instanceof Map) {
            return new SQLValuesClause(request, dataSource);
        }
        if (rawValues instanceof List) {
            ArrayList<SQLValuesClause> valuesClauses = new ArrayList<SQLValuesClause>();
            List constraints = (List)request.constraints();
            for (Map values : (List)rawValues) {
                if (values.isEmpty()) continue;
                valuesClauses.add(new SQLValuesClause(request, values, dataSource, constraints));
            }
            return valuesClauses;
        }
        throw new Exception("Data type: '" + rawValues.getClass().getName() + "' is not supported");
    }

    public List getCustomValueFields() {
        return this.customValueFields;
    }

    public void setCustomValueFields(List fields) {
        this.customValueFields = fields;
    }

    public boolean isEmpty() {
        return this.values == null && this.valueSets == null;
    }

    public int size() {
        if (this.isEmpty()) {
            return 0;
        }
        if (this.valueSets != null) {
            return this.valueSets.size();
        }
        return 1;
    }

    private Map filterValid(Map data) throws Exception {
        if (data == null) {
            return null;
        }
        HashMap validData = new HashMap();
        List validColumns = this.dataSource._getFieldNames();
        ArrayList<String> invalidColumns = new ArrayList<String>();
        for (String columnName : data.keySet()) {
            if (!validColumns.contains(columnName)) {
                invalidColumns.add(columnName);
                continue;
            }
            DSField field = this.dataSource.getField(columnName);
            if (field != null && (field.get((Object)"includeFrom") != null || field.isInapplicable())) {
                invalidColumns.add(columnName);
                continue;
            }
            Object value = data.get(columnName);
            try {
                if (value != null && value.getClass().getName().startsWith("org.joda.")) {
                    value = DataTools.convertType(Date.class, value);
                }
            }
            catch (Exception ex) {
                log.warn((Object)"Failed to convert Joda date/time value", (Throwable)ex);
            }
            validData.put(columnName, value);
        }
        if (!invalidColumns.isEmpty() && log.isInfoEnabled()) {
            log.info((Object)("Ignored data for non-existent or included columns: " + String.valueOf(invalidColumns)));
        }
        return validData;
    }

    private List<Map> validateValueSets(List<Map> data) throws Exception {
        if (data == null) {
            return null;
        }
        ArrayList<Map> filtered = new ArrayList<Map>();
        for (int i = 0; i < data.size(); ++i) {
            filtered.add(this.filterValid(data.get(i)));
        }
        String nonMatchingStrategy = this.dsRequest != null ? this.dsRequest.getMultiInsertNonMatchingStrategy() : "padWithNulls";
        Iterator records = filtered.iterator();
        Map firstRecord = (Map)records.next();
        int count = 1;
        HashSet additionalFields = new HashSet();
        while (records.hasNext()) {
            boolean remove;
            Map thisRecord = (Map)records.next();
            boolean bl = nonMatchingStrategy.equals("dropRecords") ? firstRecord.entrySet().size() != thisRecord.entrySet().size() : (remove = false);
            if (!remove) {
                for (Object key : firstRecord.keySet()) {
                    if (thisRecord.containsKey(key)) continue;
                    if (nonMatchingStrategy.equals("dropRecords")) {
                        remove = true;
                        break;
                    }
                    if (!nonMatchingStrategy.equals("padWithNulls")) continue;
                    additionalFields.add(key);
                }
                HashSet keysToRemove = new HashSet();
                for (Object key : thisRecord.keySet()) {
                    if (firstRecord.containsKey(key)) continue;
                    if (nonMatchingStrategy.equals("dropRecords")) {
                        remove = true;
                        break;
                    }
                    if (nonMatchingStrategy.equals("dropFields")) {
                        keysToRemove.add(key);
                        continue;
                    }
                    if (!nonMatchingStrategy.equals("padWithNulls")) continue;
                    additionalFields.add(key);
                }
                if (nonMatchingStrategy.equals("dropFields")) {
                    for (Object keyToRemove : keysToRemove) {
                        log.debug((Object)("Removed field " + String.valueOf(keyToRemove) + " from record " + count + "during a a multi-insert add request becausethat field is not present in the first record in the set, and multi-insert non-matching strategy 'dropFields' is in force.  Scan the client documentation for 'multiInsertNonMatchingStrategy' for more information"));
                        thisRecord.remove(keyToRemove);
                    }
                }
            }
            if (remove) {
                log.debug((Object)("Removed record " + count + " from a multi-insert add request because it did not contain exactly the same fields as the first record in the set, and multi-insert non-matching strategy 'dropRecords; is in force.  Scan the client documentation for 'multiInsertNonMatchingStrategy' for more information"));
                log.debug((Object)("First record keys: " + String.valueOf(firstRecord.keySet()) + ".  Record " + count + " keys: " + String.valueOf(thisRecord.keySet())));
                records.remove();
            }
            ++count;
        }
        if (nonMatchingStrategy.equals("padWithNulls") && additionalFields.size() > 0) {
            Iterator f = additionalFields.iterator();
            while (f.hasNext()) {
                String fieldName = f.next().toString();
                for (int i = 0; i < filtered.size(); ++i) {
                    Map record = (Map)filtered.get(i);
                    if (record.containsKey(fieldName)) continue;
                    record.put(fieldName, null);
                }
            }
        }
        return filtered;
    }

    public String getSQLStringForInsert() throws Exception {
        boolean isMultiInserting;
        if (this.size() == 0) {
            log.debug((Object)"no data; returning empty string");
            return "";
        }
        StringBuffer columnList = new StringBuffer();
        StringBuffer valueList = new StringBuffer();
        StringBuffer multiInsertSelectList = new StringBuffer();
        Map sequences = this.dataSource.getSequences();
        SQLDriver driver = this.dataSource.getDriver();
        ArrayList<String> sequenceFieldNames = new ArrayList<String>();
        Iterator i = sequences.keySet().iterator();
        while (i.hasNext()) {
            sequenceFieldNames.add(this.dataSource.getFieldNameFromColumnName((String)i.next()));
        }
        HashMap values = this.values;
        if (values == null) {
            values = new HashMap(this.valueSets.get(0));
        }
        List pks = this.dataSource.getPrimaryKeys();
        for (int i2 = 0; i2 < pks.size(); ++i2) {
            DSField field;
            if (values.containsKey(pks.get(i2)) || sequenceFieldNames.contains(pks.get(i2)) || (field = this.dataSource.getField((String)pks.get(i2))) != null && field.isAutoGenerated() && !field.containsKey((Object)"customInsertExpression")) continue;
            values.put(pks.get(i2), null);
        }
        Boolean explicitSequenceValuesConfig = Boolean.parseBoolean(config.getString((Object)"sql.allowExplicitSequenceValues"));
        Boolean explicitSequenceValuesParam = Boolean.parseBoolean(String.valueOf(this.dsRequest.getAttribute("allowExplicitSequenceValues")));
        Boolean allowExplicitSequenceValues = this.dataSource.getDriver().toleratesExplicitSequenceValues() && (explicitSequenceValuesConfig != false || explicitSequenceValuesParam != false);
        if (!allowExplicitSequenceValues.booleanValue()) {
            values = DataTools.divideMap(values, sequenceFieldNames);
        }
        if (values == null) {
            values = new HashMap();
        }
        values = DataTools.getSortedMap(values);
        boolean bl = isMultiInserting = this.valueSets != null;
        if (isMultiInserting) {
            this.transformMultiEntriesToMatch(values);
        }
        HashSet<String> fieldsNotExcluded = new HashSet<String>();
        for (String fieldName : values.keySet()) {
            String nativeFieldName;
            DSField field = this.dataSource.getField(fieldName);
            boolean skipCustomSQLCheck = false;
            if (this.customValueFields != null) {
                Iterator i3 = this.customValueFields.iterator();
                while (i3.hasNext()) {
                    if (!i3.next().equals(fieldName)) continue;
                    skipCustomSQLCheck = true;
                    break;
                }
            }
            if (field != null && (!skipCustomSQLCheck && field.getBoolean("customSQL") || field.get((Object)"tableName") != null || "relatedCount".equals(field.getType()) || (field.get((Object)"customSelectExpression") != null || field.get((Object)"customSQLExpression") != null) && field.get((Object)"customInsertExpression") == null && field.get((Object)"customUpdateExpression") == null) || (nativeFieldName = (String)this.field2ColumnMap.get(fieldName)) == null) continue;
            if (nativeFieldName.contains(".")) {
                nativeFieldName = nativeFieldName.substring(nativeFieldName.lastIndexOf(".") + 1);
            }
            if (columnList.length() != 0) {
                columnList.append(", ");
            }
            if (valueList.length() != 0) {
                valueList.append(", ");
            }
            fieldsNotExcluded.add(fieldName);
            columnList.append(this.dataSource.escapeColumnName(nativeFieldName));
            if (!(sequenceFieldNames.contains(fieldName) && isMultiInserting && driver.multiInsertRequiresAdditionalSelect())) {
                valueList.append(this.getSQLValue(field, fieldName, values, driver, isMultiInserting));
                if (!isMultiInserting || !driver.multiInsertRequiresAdditionalSelect()) continue;
                if (multiInsertSelectList.length() > 0) {
                    multiInsertSelectList.append(", ");
                }
                multiInsertSelectList.append(this.dataSource.escapeColumnName(nativeFieldName));
                valueList.append(" " + nativeFieldName);
                continue;
            }
            multiInsertSelectList.append(this.getSQLValue(field, fieldName, values, driver, true));
        }
        this.processSequences(values, valueList, driver, allowExplicitSequenceValues, columnList, multiInsertSelectList);
        if (columnList.toString() == null || "".equals(columnList.toString())) {
            return null;
        }
        if (!isMultiInserting) {
            return "(" + columnList.toString() + ") VALUES (" + valueList.toString() + ")";
        }
        valueList.insert(0, driver.getMultiInsertPrelude(multiInsertSelectList.toString()) + driver.getMultiInsertValueSetPrelude());
        valueList.append(driver.getMultiInsertValueSetCoda(this.valueSets.size() == 1));
        for (int i4 = 1; i4 < this.valueSets.size(); ++i4) {
            Map record = this.valueSets.get(i4);
            int column = 0;
            valueList.append(driver.getMultiInsertValueSetPrelude());
            for (String fieldName : record.keySet()) {
                DSField field = this.dataSource.getField(fieldName);
                String nativeFieldName = (String)this.field2ColumnMap.get(fieldName);
                if (nativeFieldName == null) continue;
                if (nativeFieldName.contains(".")) {
                    nativeFieldName = nativeFieldName.substring(nativeFieldName.lastIndexOf(".") + 1);
                }
                if (!fieldsNotExcluded.contains(fieldName) || sequenceFieldNames.contains(fieldName) && driver.multiInsertRequiresAdditionalSelect()) continue;
                if (column++ > 0) {
                    valueList.append(", ");
                }
                valueList.append(this.getSQLValue(field, fieldName, record, driver, true));
                if (!driver.multiInsertRequiresAdditionalSelect()) continue;
                valueList.append(" " + nativeFieldName);
            }
            this.processSequences(record, valueList, driver, allowExplicitSequenceValues, null, multiInsertSelectList);
            valueList.append(driver.getMultiInsertValueSetCoda(i4 == this.valueSets.size() - 1));
        }
        valueList.append(driver.getMultiInsertCoda());
        return "(" + columnList.toString() + ") " + valueList.toString();
    }

    private String getSQLValue(DSField field, String fieldName, Map values, SQLDriver driver, boolean isMultiInserting) throws Exception {
        boolean skipCustomExpression;
        boolean bl = skipCustomExpression = !driver.fieldAssignableInline(field) && values.get(fieldName) == null && values.containsKey(fieldName) && config.getBoolean((Object)"sql.prioritizeClientNullValueOverServerCustomExpression", false);
        if (field.get((Object)"customInsertExpression") != null && !skipCustomExpression) {
            return this.getCustomInsertExpression(field);
        }
        if (field.get((Object)"customUpdateExpression") != null && !skipCustomExpression) {
            return this.getCustomUpdateExpression(field);
        }
        if (!driver.fieldAssignableInline(field)) {
            if (values.get(fieldName) == null) {
                if (driver.shouldParameterizeNullValues(isMultiInserting)) {
                    return driver.prepareSQLParam(this.dsRequest, (DataSource)this.dataSource, field, null, "?");
                }
                return "NULL";
            }
            return driver.prepareSQLParam(this.dsRequest, (DataSource)this.dataSource, field, values.get(fieldName), "?");
        }
        return this.dataSource.sqlValueForFieldValue(fieldName, values.get(fieldName), this.dsRequest);
    }

    private void processSequences(Map values, StringBuffer valueList, SQLDriver driver, boolean allowExplicitSequenceValues, StringBuffer columnList, StringBuffer multiInsertSelectList) throws Exception {
        boolean omitValue;
        Map sequences = this.dataSource.getSequences();
        log.debug((Object)("Sequences: " + String.valueOf(sequences)));
        boolean bl = omitValue = driver instanceof DB2Driver || driver instanceof MysqlDriver || driver instanceof SQLServerDriver && !SQLServerDriver.useSequences((DataSource)this.dataSource);
        if (this.valueSets != null && driver.multiInsertRequiresAdditionalSelect() && columnList == null) {
            return;
        }
        if (!(driver instanceof SQLServerDriver && !SQLServerDriver.useSequences((DataSource)this.dataSource) || driver instanceof CacheDriver)) {
            for (String columnName : sequences.keySet()) {
                DSField field;
                String fieldName = this.dataSource.getFieldNameFromColumnName(columnName);
                if (allowExplicitSequenceValues && values.containsKey(fieldName) || (field = this.dataSource.getField(fieldName)).getBoolean("implicitSequence", false)) continue;
                if (driver instanceof MysqlDriver) {
                    if (columnList != null && columnList.length() > 0) {
                        columnList.append(", ");
                    }
                    if (valueList.length() > 0) {
                        valueList.append(", ");
                    }
                    if (columnList != null) {
                        columnList.append(this.dataSource.escapeColumnName(columnName));
                    }
                    valueList.append("NULL");
                    continue;
                }
                if (omitValue) continue;
                if (columnList != null && columnList.length() > 0) {
                    columnList.append(", ");
                }
                if (!(this.valueSets != null && driver.multiInsertRequiresAdditionalSelect() || valueList.length() <= 0)) {
                    valueList.append(", ");
                }
                if (columnList != null) {
                    columnList.append(this.dataSource.escapeColumnName(columnName));
                }
                if (driver.shouldPrefetchNextSequenceValue(this.dataSource)) {
                    String sql = "SELECT " + this.dataSource.getNextSequenceValue(columnName);
                    Object obj = SQLDriver.getScalarResult(sql, driver.getConnection(), driver.getDBName(), driver, this.dsRequest);
                    if (obj == null) {
                        log.warn((Object)("Attempt to obtain next sequence value using '" + sql + "' returned null"));
                        continue;
                    }
                    log.debug((Object)("Obtained next sequence value from '" + sql + "': " + String.valueOf(obj)));
                    Long sequenceValue = Long.valueOf(obj.toString());
                    valueList.append(sequenceValue);
                    HashMap seqValues = new HashMap();
                    seqValues.put(this.dataSource.native2DSFieldMap().get(columnName), sequenceValue);
                    this.dsRequest.setLastPrimaryKeysData(seqValues);
                    continue;
                }
                if (this.valueSets == null || !driver.multiInsertRequiresAdditionalSelect()) {
                    valueList.append(this.dataSource.getNextSequenceValue(columnName));
                    continue;
                }
                if (multiInsertSelectList.length() > 0) {
                    multiInsertSelectList.append(", ");
                }
                multiInsertSelectList.append(this.dataSource.getNextSequenceValue(columnName));
            }
        }
    }

    private void transformMultiEntriesToMatch(Map values) {
        for (int i = 1; i < this.valueSets.size(); ++i) {
            Map originalMap = this.valueSets.get(i);
            LinkedHashMap reorderedMap = new LinkedHashMap();
            Iterator keys = values.keySet().iterator();
            while (keys.hasNext()) {
                String key = keys.next().toString();
                reorderedMap.put(key, originalMap.get(key));
            }
            this.valueSets.set(i, reorderedMap);
        }
    }

    public String getSQLStringForUpdate() throws Exception {
        Map newValues;
        List primaryKeys;
        if (this.size() == 0) {
            log.debug((Object)"no data; returning empty string");
            return "";
        }
        Map sequences = this.dataSource.getTable().getSequences();
        SQLDriver driver = this.dataSource.getDriver();
        if (driver instanceof SQLServerDriver) {
            this.values = DataTools.divideMap((Map)this.values, new ArrayList(sequences.keySet()));
        }
        if ((primaryKeys = this.dataSource.getPrimaryKeys()) != null && (newValues = DataTools.divideMap((Map)this.values, (List)primaryKeys)) != null) {
            this.values = newValues;
        }
        if (this.values == null) {
            return null;
        }
        this.values = DataTools.getSortedMap((Map)this.values);
        StringBuffer expr = new StringBuffer();
        for (String fieldName : this.values.keySet()) {
            boolean skipCustomExpression;
            String columnName;
            DSField field = this.dataSource.getField(fieldName);
            boolean skipCustomSQLCheck = false;
            if (this.customValueFields != null) {
                Iterator i = this.customValueFields.iterator();
                while (i.hasNext()) {
                    if (!i.next().equals(fieldName)) continue;
                    skipCustomSQLCheck = true;
                    break;
                }
            }
            if (field != null) {
                if (!skipCustomSQLCheck && field.getBoolean("customSQL") || field.get((Object)"tableName") != null || "relatedCount".equals(field.getType())) continue;
                if ((field.get((Object)"customSelectExpression") != null || field.get((Object)"customSQLExpression") != null) && field.get((Object)"customUpdateExpression") == null) {
                    log.info((Object)("Ignoring value for " + fieldName + " since it has a customSelectExpression or customSQLExpression but no customUpdateExpression"));
                    continue;
                }
            }
            if ((columnName = (String)this.field2ColumnMap.get(fieldName)) == null) continue;
            if (columnName != null && columnName.contains(".")) {
                columnName = columnName.substring(columnName.lastIndexOf(".") + 1);
            }
            if (expr.length() != 0) {
                expr.append(", ");
            }
            expr.append(this.dataSource.escapeColumnName(columnName) + "=");
            Object columnValue = this.values.get(fieldName);
            boolean bl = skipCustomExpression = !driver.fieldAssignableInline(field) && columnValue == null && this.values.containsKey(fieldName) && config.getBoolean((Object)"sql.prioritizeClientNullValueOverServerCustomExpression", false);
            if (field.get((Object)"customUpdateExpression") != null && !skipCustomExpression) {
                expr.append(this.getCustomUpdateExpression(field));
                continue;
            }
            if (!driver.fieldAssignableInline(field)) {
                if (columnValue == null) {
                    if (driver.shouldParameterizeNullValues(false)) {
                        expr.append(driver.prepareSQLParam(this.dsRequest, (DataSource)this.dataSource, field, null, "?"));
                        continue;
                    }
                    expr.append("NULL");
                    continue;
                }
                expr.append(driver.prepareSQLParam(this.dsRequest, (DataSource)this.dataSource, field, columnValue, "?"));
                continue;
            }
            expr.append(this.dataSource.sqlValueForFieldValue(fieldName, columnValue, this.dsRequest));
        }
        if (expr.toString() == null || "".equals(expr.toString())) {
            return null;
        }
        return expr.toString();
    }

    private String getCustomUpdateExpression(DSField field) throws Exception {
        String clause = (String)field.get((Object)"customUpdateExpression");
        Map context = Velocity.getStandardContextMap((DSRequest)this.dsRequest);
        return Velocity.evaluateWithSnippets((String)clause, (Map)context, (String)"customUpdateExpression", (DSRequest)this.dsRequest, (boolean)field.getBoolean("autoQuoteCustomExpressions", true), (boolean)false);
    }

    private String getCustomInsertExpression(DSField field) throws Exception {
        String clause = (String)field.get((Object)"customInsertExpression");
        Map context = Velocity.getStandardContextMap((DSRequest)this.dsRequest);
        return Velocity.evaluateWithSnippets((String)clause, (Map)context, (String)"customInsertExpression", (DSRequest)this.dsRequest, (boolean)field.getBoolean("autoQuoteCustomExpressions", true), (boolean)false);
    }
}

