/*
 * Decompiled with CFR 0.152.
 */
package com.isomorphic.taglib;

import com.isomorphic.auth.Authentication;
import com.isomorphic.base.Config;
import com.isomorphic.io.ISCFile;
import com.isomorphic.io.file.ISCContainerFile;
import com.isomorphic.js.JSTranslater;
import com.isomorphic.servlet.RequestContext;
import com.isomorphic.taglib.LoadTag;
import com.isomorphic.util.DataTools;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.jsp.JspException;
import jakarta.servlet.jsp.JspWriter;
import jakarta.servlet.jsp.PageContext;
import java.io.File;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;

public class LoadModulesTag
extends LoadTag {
    public String modules = null;
    public String includeModules = null;
    public String locale = null;
    private static HashMap moduleCache = new HashMap();

    public int doStartTag() throws JspException {
        this.init();
        try {
            this.outputModules(this.pageContext, false);
        }
        catch (Throwable e) {
            this.log.error((Object)"Exception while attempting to process a loadModules tag.", e);
            throw new JspException(DataTools.getStackTrace(e));
        }
        return 0;
    }

    public void setModules(String modules) {
        this.modules = modules;
    }

    public String getModules() {
        return this.modules;
    }

    public void setIncludeModules(String includeModules) {
        this.includeModules = includeModules;
    }

    public String getIncludeModules() {
        return this.includeModules;
    }

    public void setLocale(String locale) {
        this.locale = locale;
    }

    public String getLocale() {
        return this.locale;
    }

    public void outputLocale(PageContext pageContext) throws Exception {
        Object suffix;
        String locale = this.getLocale();
        if (locale == null || "".equals(locale)) {
            return;
        }
        JspWriter out = pageContext.getOut();
        boolean defer = "true".equals(this.getDefer());
        boolean cacheOnly = "true".equals(this.getCacheOnly());
        Object object = suffix = "en".equals(locale) ? "" : "_" + locale;
        if (defer || cacheOnly) {
            out.write("<script type='text/javascript'>");
            out.write("isc.FileLoader." + (cacheOnly ? "cacheLocale" : "loadLocale") + "('" + locale + "');");
            out.write("</script>");
        } else {
            if (!new File(this.isomorphicURI + "locales/frameworkMessages" + (String)suffix + ".properties").exists()) {
                this.log.warn("Attempt to load unsupported locale '" + locale + "'.");
            }
            out.write("<script type='text/javascript' src='" + this.addVersion(this.isomorphicURI + "locales/frameworkMessages" + (String)suffix + ".properties") + "'></script>");
        }
    }

    public void outputModules(PageContext pageContext, boolean isLoadISC) throws Exception {
        String modulesDir;
        JspWriter out = pageContext.getOut();
        HttpServletRequest request = (HttpServletRequest)pageContext.getRequest();
        String isomorphicURI = this.getIsomorphicURI();
        String isomorphicDevURI = this.getIsomorphicDevURI();
        if (isomorphicDevURI != null) {
            isomorphicURI = isomorphicDevURI;
        }
        String suffix = this.getSuffix();
        String string = modulesDir = this.useDebugModules != null && this.useDebugModules != false ? this.getDebugModulesDir() : this.getModulesDir();
        suffix = suffix != null ? (suffix.startsWith("_") ? suffix : "_" + suffix) : "";
        List moduleList = this.getModuleList(this.modules, this.includeModules, pageContext);
        boolean defer = "true".equals(this.getDefer());
        boolean cacheOnly = "true".equals(this.getCacheOnly());
        Object user = null;
        if (config.getBoolean((Object)"isomorphic.internal", false)) {
            RequestContext context = RequestContext.instance(pageContext);
            user = Authentication.getUser(context);
            if (request.getAttribute("isc_user_deployment_context_emitted") == null) {
                request.setAttribute("isc_user_deployment_context_emitted", (Object)true);
                String deploymentMode = config.getString("deployment.mode");
                JSTranslater.instance().toJSVariableInScript(deploymentMode, "isc_deploymentMode", (Writer)out);
                if (user != null) {
                    JSTranslater.instance().toJSVariableInScript(user, "isc_user", (Writer)out);
                }
            }
        }
        if (defer || cacheOnly) {
            String onload = this.getOnload();
            Iterator i = moduleList.iterator();
            while (i.hasNext()) {
                String module = (String)i.next();
                if (defer && module.equals("History")) {
                    i.remove();
                    out.write("<script type='text/javascript' src='" + this.addVersion(isomorphicURI + modulesDir + "ISC_History" + suffix + ".js") + "'></script>");
                    continue;
                }
                if (!module.equals("FileLoader")) continue;
                i.remove();
            }
            if (moduleList.size() > 0) {
                out.write("<script type='text/javascript'>");
                out.write("isc.FileLoader.modulesDir = '" + modulesDir + "';");
                out.write("isc.FileLoader.addVersionToLoadTags =" + config.getBoolean((Object)"isc.addVersionToLoadTags", Boolean.TRUE).toString() + ";");
                out.write("isc.FileLoader." + (cacheOnly ? "cacheModules" : "loadModules") + "(" + JSTranslater.instance().toJS(moduleList));
                String lastModule = (String)moduleList.get(moduleList.size() - 1);
                if (onload != null && !isLoadISC && cacheOnly) {
                    out.write(", \"" + onload + "\"");
                }
                out.write(");isc._lastModule='" + lastModule + "';");
                out.write("</script>");
            }
        } else {
            for (String module : moduleList) {
                ISCContainerFile file;
                boolean checkedLoad = false;
                if (module.startsWith("?")) {
                    module = module.substring(1);
                    checkedLoad = true;
                }
                String modulePath = modulesDir + "ISC_" + module + suffix + ".js";
                if (checkedLoad && ((file = new ISCContainerFile(this.getRootRelativeIsomorphicPath() + modulePath)) == null || !((ISCFile)file).exists())) continue;
                out.write("<script type='text/javascript' src='" + this.addVersion(isomorphicURI + modulePath));
                out.write("'></script><script type='text/javascript'>isc._lastModule='" + module + "';</script>\n");
                if (!module.equals("FileLoader") || !config.getBoolean((Object)"FileLoader.disableCaching", false) || pageContext.getRequest().getAttribute("enableFileLoaderCaching") != null) continue;
                out.write("<script type='text/javascript'>isc.FileLoader.disableCaching=true;</script>\n");
            }
            if (config.getBoolean((Object)"isomorphic.internal", false) && user != null && moduleList.contains("DataBinding") && moduleList.contains("Containers") && moduleList.contains("Forms")) {
                out.write("<script type='text/javascript' src='" + this.addVersion(isomorphicURI + "login/reloginFlow.js"));
                out.write("'></script>\n");
            }
        }
        if (!cacheOnly) {
            ArrayList loadedModules = (ArrayList)pageContext.getRequest().getAttribute("_isc_loadedModules");
            if (loadedModules == null) {
                loadedModules = new ArrayList();
                pageContext.getRequest().setAttribute("_isc_loadedModules", loadedModules);
            }
            loadedModules.addAll(moduleList);
        }
    }

    private String getRootRelativeIsomorphicPath() {
        Object uri = config.getPath("isomorphicPathRootRelative");
        if (!((String)(uri = ISCFile.canonicalizePath((String)uri))).endsWith("/")) {
            uri = (String)uri + "/";
        }
        return uri;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List getModuleList(String modules, String includeModules, PageContext pageContext) throws Exception {
        StringTokenizer st;
        List<String> moduleList = (ArrayList)moduleCache.get(modules + includeModules);
        if (moduleList != null) {
            return moduleList;
        }
        moduleList = new ArrayList();
        if (modules == null) {
            modules = config.getString("isc.defaultModules", null);
        }
        if (modules != null) {
            st = new StringTokenizer(modules.toString().trim(), " \t,");
            while (st.hasMoreTokens()) {
                moduleList.add(this.getCanonicalModuleName(st.nextToken().toString().trim()));
            }
        }
        if (includeModules != null) {
            st = new StringTokenizer(includeModules.toString().trim(), " \t,");
            while (st.hasMoreTokens()) {
                moduleList.add(this.getCanonicalModuleName(st.nextToken().toString().trim()));
            }
        }
        Config dependencyMap = config.getSubtree("isc.module.dependencies");
        moduleList = DataTools.resolveDependencyTree(moduleList, (Map)((Object)dependencyMap));
        ArrayList loadedModules = (ArrayList)pageContext.getRequest().getAttribute("_isc_loadedModules");
        if (loadedModules == null) {
            loadedModules = new ArrayList();
        }
        moduleList = DataTools.setDisjunction(moduleList, loadedModules);
        List moduleOrder = config.getList("isc.moduleLoadOrder", new ArrayList());
        List orderedModulesList = DataTools.sortByExplicitOrder(moduleList, moduleOrder);
        List modulesNotPresent = DataTools.setIntersection(moduleList, DataTools.setDisjunction(moduleList, moduleOrder));
        if (modulesNotPresent.size() > 0) {
            this.log.warn("isc.moduleLoadOrder does not include user-selected modules: " + modulesNotPresent.toString() + " - placing these modules last in the load order.");
        }
        HashMap hashMap = moduleCache;
        synchronized (hashMap) {
            moduleCache.put(modules + includeModules, orderedModulesList);
        }
        return orderedModulesList;
    }

    private String getCanonicalModuleName(String module) {
        if (module.startsWith("ISC_")) {
            module = module.substring(4);
        }
        if (module.endsWith(".js")) {
            module = module.substring(0, module.length() - 3);
        }
        return module;
    }
}

