/*
 * Decompiled with CFR 0.152.
 */
package com.isomorphic.js;

import com.isomorphic.base.Base;
import com.isomorphic.base.Config;
import com.isomorphic.base.Reflection;
import com.isomorphic.base.VersionSafeChecker;
import com.isomorphic.collections.DataTypeMap;
import com.isomorphic.datasource.DSField;
import com.isomorphic.datasource.DSRequest;
import com.isomorphic.datasource.DataSource;
import com.isomorphic.datasource.DataSourceManager;
import com.isomorphic.datasource.ISCBinaryValue;
import com.isomorphic.datasource.ValidationContext;
import com.isomorphic.interfaces.IJSParser;
import com.isomorphic.interfaces.InterfaceProvider;
import com.isomorphic.io.SequenceReader;
import com.isomorphic.js.IBeanFilter;
import com.isomorphic.js.IContextBeanFilter;
import com.isomorphic.js.IContextBeanFilterWithNullControl;
import com.isomorphic.js.IDoNotSerialize;
import com.isomorphic.js.IToJSON;
import com.isomorphic.js.IToJavaScript;
import com.isomorphic.js.JSONFilter;
import com.isomorphic.js.JSTranslaterDSConfig;
import com.isomorphic.js.UnconvertableException;
import com.isomorphic.log.Logger;
import com.isomorphic.util.DataTools;
import com.isomorphic.util.IOUtil;
import com.isomorphic.util.ISCDate;
import com.isomorphic.util.ISCTime;
import com.isomorphic.util.LocaleMessage;
import java.beans.PropertyDescriptor;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Clob;
import java.sql.SQLException;
import java.sql.Time;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import javax.xml.datatype.XMLGregorianCalendar;
import org.apache.commons.collections4.map.ListOrderedMap;
import org.apache.commons.lang.ArrayUtils;
import org.joda.time.DateMidnight;
import org.joda.time.DateTime;
import org.joda.time.LocalDate;
import org.joda.time.LocalDateTime;
import org.joda.time.LocalTime;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class JSTranslater
extends Base {
    public static final boolean TRACE_JSTRANSLATER_TIMINGS = false;
    private static Logger log = new Logger(JSTranslater.class.getName());
    public static boolean globalPrettyPrinting = config.getBoolean((Object)"jsTranslater.prettyPrint", false);
    public static boolean globalCollapseSmallContainers = config.getBoolean((Object)"jsTranslater.prettyPrint.collapseSmallContainers", false);
    public static boolean globalOmitNullMapValues = config.getBoolean((Object)"jsTranslater.omitNullMapValues", false);
    public static boolean writeNativeDate = config.getBoolean((Object)"jsTranslater.writeNativeDate", false);
    public static String datetimeOutputFormat = config.getString("jsTranslater.datetimeOutputFormat", null);
    public boolean writePrefixedDate = false;
    public Map obfuscateMapKeys = config.getSubtree("map.obfuscateKeys");
    private boolean obfuscation = true;
    private boolean writeXMLSchemaDate = false;
    private boolean trimMilliseconds = false;
    public static final String DEFAULT_ENUM_TRANSLATE_STRATEGY = "string";
    public static final String DEFAULT_ENUM_CONSTANT_PROPERTY = "_constant";
    public static final String DEFAULT_ENUM_ORDINAL_PROPERTY = "_ordinal";
    private String enumTranslateStrategy = "string";
    private String constantProperty = "_constant";
    private String ordinalProperty = "_ordinal";
    public static final String DATE_FORMAT = "yyyy-MM-dd";
    public static final String DATETIME_FORMAT = "yyyy-MM-dd kk:mm:ss";
    public static final String DATETIME_MILLIS_FORMAT = "yyyy-MM-dd kk:mm:ss.SSS";
    public static final String XMLSCHEMA_DATETIME_FORMAT = "yyyy-MM-dd'T'HH:mm:ss";
    public static final String XMLSCHEMA_DATETIME_MILLIS_FORMAT = "yyyy-MM-dd'T'HH:mm:ss.SSS";
    public static final String XMLSCHEMA_TIME_FORMAT = "HH:mm:ss";
    public static final String XMLSCHEMA_TIME_MILLIS_FORMAT = "HH:mm:ss.SSS";
    private final DateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
    private DateFormat xmlSchemaTimeFormat = new SimpleDateFormat("HH:mm:ss");
    private DateFormat datetimeFormat;
    private static final DateFormat sharedDateFormat = new SimpleDateFormat("yyyy-MM-dd");
    private static final DateFormat sharedDateTimeFormat = new SimpleDateFormat("yyyy-MM-dd kk:mm:ss");
    private static final DateFormat sharedDateTimeMillisFormat = new SimpleDateFormat("yyyy-MM-dd kk:mm:ss.SSS");
    private static final DateFormat sharedXmlSchemaDateTimeFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
    private static final DateFormat sharedXmlSchemaTimeFormat = new SimpleDateFormat("HH:mm:ss");
    private static final DateFormat sharedXmlSchemaDateTimeMillisFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS");
    private static final DateFormat sharedXmlSchemaTimeMillisFormat = new SimpleDateFormat("HH:mm:ss.SSS");
    public static final Object[] EMPTY_ARRAY;
    public static final HashMap types;
    static final HashSet safeToString;
    static final HashSet sendAsJSString;
    static final HashSet reservedWords;
    boolean prettyPrinting = globalPrettyPrinting;
    boolean collapseSmallContainers = globalCollapseSmallContainers;
    boolean omitNullMapValues = globalOmitNullMapValues;
    private final Calendar cacheCalendar;
    int currentIndentDepth = 0;
    boolean alwaysToString = false;
    int propNameIndent = 0;
    String path = "";
    boolean quoteForXML = false;
    boolean quoteForTextArea = false;
    ValidationContext validationContext = null;
    boolean useSchema = true;
    boolean preserveLiteralNulls = false;
    ValidationContext typeLookupVC = null;
    boolean strictJSONMode = false;
    Locale locale;
    Locale defaultLocale;
    boolean defaultLocaleWarningLogged = false;
    DataTypeMap beanIntrospectorOptions;
    private DSRequest dsRequest;
    List recursedList;
    int recursionCount = 0;
    public static long convertLapse;
    public static long convertContextLapse;
    public static long convertFilterLapse;
    public static long convertPropsLapse;
    public static long convertSimpleLapse;
    public static long stringInBrowserLapse;
    public static long convertSimpleCalls;
    private static Boolean disableStringInBrowser;
    public static Map<String, Long> convertSimpleLapseMap;

    public void setObfuscation(boolean enabled) {
        this.obfuscation = enabled;
    }

    public boolean shouldWriteXMLSchemaDate() {
        return this.writeXMLSchemaDate;
    }

    public void setWriteXMLSchemaDate(boolean value) {
        this.writeXMLSchemaDate = value;
    }

    public boolean shouldUseUTCInXMLSchemaDates() {
        return this.datetimeFormat.getTimeZone().getOffset(0L) == 0;
    }

    public void setUseUTCInXMLSchemaDates(boolean value) {
        this.datetimeFormat.setTimeZone(value ? TimeZone.getTimeZone("UTC") : TimeZone.getDefault());
    }

    public boolean shouldTrimMilliseconds() {
        return this.trimMilliseconds;
    }

    public void setTrimMilliseconds(boolean value) {
        this.trimMilliseconds = value;
        DateFormat old = this.datetimeFormat;
        if (!value) {
            this.xmlSchemaTimeFormat = new SimpleDateFormat(XMLSCHEMA_TIME_FORMAT);
            this.datetimeFormat = "original".equalsIgnoreCase(datetimeOutputFormat) ? new SimpleDateFormat(DATETIME_MILLIS_FORMAT) : new SimpleDateFormat(XMLSCHEMA_DATETIME_MILLIS_FORMAT);
        } else {
            this.xmlSchemaTimeFormat = new SimpleDateFormat(XMLSCHEMA_TIME_FORMAT);
            this.datetimeFormat = "original".equalsIgnoreCase(datetimeOutputFormat) ? new SimpleDateFormat(DATETIME_FORMAT) : new SimpleDateFormat(XMLSCHEMA_DATETIME_FORMAT);
        }
        if (old != null) {
            this.datetimeFormat.setTimeZone(old.getTimeZone());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Date parseDate(String format, String text) throws ParseException {
        DateFormat df = null;
        if (DATE_FORMAT == format) {
            df = sharedDateFormat;
        } else if (DATETIME_FORMAT == format) {
            df = sharedDateTimeFormat;
        } else if (XMLSCHEMA_DATETIME_FORMAT == format) {
            df = sharedXmlSchemaDateTimeFormat;
        } else if (XMLSCHEMA_TIME_FORMAT == format) {
            df = sharedXmlSchemaTimeFormat;
        } else if (DATETIME_MILLIS_FORMAT == format) {
            df = sharedDateTimeMillisFormat;
        } else if (XMLSCHEMA_DATETIME_MILLIS_FORMAT == format) {
            df = sharedXmlSchemaDateTimeMillisFormat;
        } else if (XMLSCHEMA_TIME_MILLIS_FORMAT == format) {
            df = sharedXmlSchemaTimeMillisFormat;
        }
        if (df != null) {
            DateFormat dateFormat = df;
            synchronized (dateFormat) {
                return df.parse(text);
            }
        }
        df = new SimpleDateFormat(format);
        return df.parse(text);
    }

    public ValidationContext getTypeLookupVC() {
        return this.typeLookupVC;
    }

    public void setTypeLookupVC(ValidationContext typeLookupVC) {
        this.typeLookupVC = typeLookupVC;
    }

    public static JSTranslater instance() {
        return new JSTranslater();
    }

    public JSTranslater() {
        this.datetimeFormat = "original".equalsIgnoreCase(datetimeOutputFormat) ? new SimpleDateFormat(DATETIME_FORMAT) : ("xmlSchema".equalsIgnoreCase(datetimeOutputFormat) ? new SimpleDateFormat(XMLSCHEMA_DATETIME_FORMAT) : ("originalMillis".equalsIgnoreCase(datetimeOutputFormat) ? new SimpleDateFormat(DATETIME_MILLIS_FORMAT) : new SimpleDateFormat(XMLSCHEMA_DATETIME_MILLIS_FORMAT)));
        this.setUseUTCInXMLSchemaDates(true);
        this.cacheCalendar = Calendar.getInstance();
    }

    public static JSTranslater get() {
        JSTranslater jsTrans = new JSTranslater();
        return jsTrans;
    }

    public static JSTranslater strict() {
        JSTranslater jsTrans = JSTranslater.get();
        jsTrans.setStrictJSONMode(true);
        jsTrans.preserveLiteralNulls(true);
        return jsTrans;
    }

    public JSTranslater withBeanIntrospectorOptions(DataTypeMap beanIntrospectorOptions) {
        this.beanIntrospectorOptions = beanIntrospectorOptions;
        return this;
    }

    public JSTranslater enablePrettyPrinting() {
        this.prettyPrinting = true;
        return this;
    }

    public JSTranslater enablePrettyPrinting(boolean value) {
        this.prettyPrinting = value;
        return this;
    }

    public JSTranslater omitNullMapValues(boolean value) {
        this.omitNullMapValues = value;
        return this;
    }

    public JSTranslater collapseSmallContainers(boolean value) {
        this.collapseSmallContainers = value;
        return this;
    }

    public void quoteForTextArea() {
        this.quoteForTextArea = true;
        this.quoteForXML = false;
    }

    public void quoteForXML() {
        this.quoteForXML = true;
        this.quoteForTextArea = false;
    }

    public JSTranslater strictJSONMode() {
        this.strictJSONMode = true;
        return this;
    }

    public void setStrictJSONMode(boolean value) {
        this.strictJSONMode = value;
    }

    public boolean getStrictJSONMode() {
        return this.strictJSONMode;
    }

    public JSTranslater setCurrentIndentDepth(int depth) {
        this.currentIndentDepth = depth;
        return this;
    }

    public Locale getLocale() {
        if (this.locale != null) {
            return this.locale;
        }
        return this.getDefaultLocale();
    }

    public void setLocale(Locale locale) {
        this.locale = locale;
    }

    public Locale getDefaultLocale() {
        if (this.defaultLocale != null) {
            return this.defaultLocale;
        }
        String localeName = config.getString("defaultLocale");
        if (localeName == null) {
            if (!this.defaultLocaleWarningLogged) {
                log.warn("defaultLocale could not be read from server.properties");
            }
            this.defaultLocaleWarningLogged = true;
            this.defaultLocale = null;
            return null;
        }
        String[] localeElements = localeName.split("_");
        if (localeElements.length == 1) {
            this.defaultLocale = new Locale(localeElements[0]);
            return this.defaultLocale;
        }
        if (localeElements.length == 2) {
            this.defaultLocale = new Locale(localeElements[0], localeElements[1]);
            return this.defaultLocale;
        }
        if (localeElements.length == 3) {
            this.defaultLocale = new Locale(localeElements[0], localeElements[1], localeElements[2]);
            return this.defaultLocale;
        }
        if (!this.defaultLocaleWarningLogged) {
            log.warn("The defaultLocale read from server.properties is '" + localeName + "', which is not a valid value");
        }
        this.defaultLocaleWarningLogged = true;
        this.defaultLocale = null;
        return null;
    }

    public void alwaysToString() {
        this.alwaysToString = true;
    }

    public void alwaysToString(boolean toString) {
        this.alwaysToString = toString;
    }

    public void setUseSchema() {
        this.useSchema = true;
    }

    public void setUseSchema(boolean value) {
        this.useSchema = value;
    }

    public void indent(int numChars, Writer out) throws IOException {
        for (int ii = 0; ii < numChars; ++ii) {
            out.write(" ");
        }
    }

    public void indentToCurrentDepth(Writer out) throws IOException {
        for (int ii = 0; ii < this.currentIndentDepth; ++ii) {
            out.write("    ");
        }
    }

    public boolean safeToString(Object javaObj) {
        String className = javaObj.getClass().getName();
        return safeToString.contains(className);
    }

    public void preserveLiteralNulls(boolean b) {
        this.preserveLiteralNulls = b;
    }

    public String toJS(Object javaObj) throws UnconvertableException {
        try {
            StringWriter out = new StringWriter();
            this.toJS(javaObj, out);
            return out.toString();
        }
        catch (IOException e) {
            log.error("IOException from StringWriter on toJS (should be impossible)");
            throw new UnconvertableException("IOException from StringWriter");
        }
    }

    public synchronized void toJS(Object javaObj, Writer out) throws UnconvertableException, IOException {
        long start = System.currentTimeMillis();
        if (this.recursedList == null) {
            this.recursionCount = 0;
        }
        if (this.recursionCount == 0) {
            this.recursedList = new ArrayList();
        }
        ++this.recursionCount;
        try {
            this.convert(javaObj, out);
        }
        catch (IOException ioe) {
            this.recursionCount = 1;
            throw ioe;
        }
        catch (UnconvertableException ue) {
            this.recursionCount = 1;
            throw ue;
        }
        finally {
            --this.recursionCount;
            if (this.recursionCount == 0) {
                this.recursedList = null;
            }
        }
        if (javaObj != null && !this.isLeaf(javaObj)) {
            long end = System.currentTimeMillis();
            Logger.timing.debug("Time to convert " + javaObj.getClass().getName() + " to JS Object: " + (end - start) + "ms");
        }
    }

    private String convert(Object javaObj) throws UnconvertableException, IOException {
        StringWriter out = new StringWriter();
        this.convert(javaObj, out);
        return out.toString();
    }

    private void convert(Object javaObj, Writer out) throws UnconvertableException, IOException {
        this.convert(javaObj, out, null);
    }

    private void convert(Object javaObj, Writer out, IBeanFilter beanFilter) throws UnconvertableException, IOException {
        Object obj;
        int i;
        boolean validationContextWasNull = false;
        if (this.validationContext == null) {
            this.validationContext = new ValidationContext();
            this.validationContext.setUseSchema(this.useSchema);
            validationContextWasNull = true;
        }
        String savedEnumTranslateStrategy = this.getEnumTranslateStrategy();
        String savedEnumOrdinalProperty = this.getEnumOrdinalProperty();
        String savedEnumConstantProperty = this.getEnumConstantProperty();
        JSTranslaterDSConfig currentCfg = null;
        JSTranslaterDSConfig cfg = null;
        if (javaObj instanceof JSTranslaterDSConfig) {
            long nanos = System.nanoTime();
            cfg = currentCfg = (JSTranslaterDSConfig)javaObj;
            javaObj = currentCfg.getObject();
            DataSource ds = currentCfg.getDataSource();
            if (ds != null) {
                String fieldName = currentCfg.getFieldName();
                if (fieldName != null) {
                    DSField field = ds.getField(fieldName);
                    if (field != null && ds.getSimpleBaseType(field.getType()) == null) {
                        DataSource typeDS = null;
                        try {
                            typeDS = DataSourceManager.get(field.getType(), this.dsRequest);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        if (typeDS != null) {
                            cfg = new JSTranslaterDSConfig(javaObj, typeDS, null, currentCfg.getOmitNullMapValues(), currentCfg.getBypassDataFilter());
                        }
                    }
                } else if (!(javaObj instanceof JSONFilter) && beanFilter == null && !cfg.getBypassDataFilter().booleanValue()) {
                    boolean dropExtraFields = config.getBoolean((Object)"DSResponse.dropExtraFields", false);
                    if (ds.dropExtraFieldsDefined()) {
                        dropExtraFields = ds.dropExtraFields();
                    }
                    javaObj = new JSONFilter(javaObj, ds, dropExtraFields);
                }
                this.setEnumTranslateStrategy(ds.getEnumTranslateStrategy());
                this.setEnumOrdinalProperty(ds.getEnumOrdinalProperty());
                this.setEnumConstantProperty(ds.getEnumConstantProperty());
            }
        }
        if (javaObj instanceof JSONFilter) {
            JSONFilter filter = (JSONFilter)javaObj;
            javaObj = filter.getObj();
            beanFilter = filter.getBeanFilter();
        }
        if (this.convertSimple(javaObj, out, cfg)) {
            if (validationContextWasNull) {
                this.validationContext.freeResources();
                this.validationContext = null;
            }
            if (cfg != null && currentCfg != cfg) {
                DataSourceManager.free(cfg.getDataSource());
            }
            this.setEnumTranslateStrategy(savedEnumTranslateStrategy);
            this.setEnumOrdinalProperty(savedEnumOrdinalProperty);
            this.setEnumConstantProperty(savedEnumConstantProperty);
            return;
        }
        ArrayList<Object> recursedList = this.recursedList;
        if (recursedList == null) {
            log.warn("can't find current recursion set - recursion check disabled for this call.");
            log.debug((Object)"Stack trace for recursedList not found", new Exception());
            recursedList = new ArrayList<Object>();
        }
        if (javaObj != null) {
            for (i = recursedList.size() - 1; i >= 0; --i) {
                obj = recursedList.get(i);
                if (javaObj != obj) continue;
                log.warn(javaObj.getClass().getName() + " contains a (potentially indirect) looping reference to itself.  Returning null for recursed value.");
                out.write("null /* loop to object of type: " + javaObj.getClass().getName() + " */");
                if (validationContextWasNull) {
                    this.validationContext.freeResources();
                    this.validationContext = null;
                }
                if (cfg != null && currentCfg != cfg) {
                    DataSourceManager.free(cfg.getDataSource());
                }
                this.setEnumTranslateStrategy(savedEnumTranslateStrategy);
                this.setEnumOrdinalProperty(savedEnumOrdinalProperty);
                this.setEnumConstantProperty(savedEnumConstantProperty);
                return;
            }
        }
        recursedList.add(javaObj);
        if (javaObj instanceof IToJSON) {
            ((IToJSON)javaObj).toJSON(out, this);
        } else if (javaObj instanceof IToJavaScript) {
            ((IToJavaScript)javaObj).toJavaScript(out);
        } else if (javaObj instanceof Map) {
            this.convertMap((Map)javaObj, out, beanFilter, cfg);
        } else if (javaObj instanceof Collection) {
            this.convertCollection((Collection)javaObj, out, beanFilter, cfg);
        } else if (javaObj instanceof Object[]) {
            this.convertArray((Object[])javaObj, out, beanFilter, cfg);
        } else if (javaObj != null && javaObj.getClass().isArray()) {
            this.convertPrimitiveArray(javaObj, out, beanFilter, cfg);
        } else if (javaObj instanceof Iterator) {
            this.convertIterator((Iterator)javaObj, out, beanFilter, cfg);
        } else if (javaObj instanceof Enumeration) {
            this.convertEnumeration((Enumeration)javaObj, out, beanFilter, cfg);
        } else {
            if (javaObj instanceof Element) {
                try {
                    Element element = (Element)javaObj;
                    if (log.isDebugEnabled()) {
                        log.debug("XML Element '" + element.getTagName() + "' being transformed as part of JS translation");
                    }
                    Object records = DataSource.recordsFromXML(element, this.validationContext);
                    if (cfg != null) {
                        records = new JSTranslaterDSConfig(records, cfg);
                    }
                    this.convert(records, out, beanFilter);
                }
                catch (Exception e) {
                    if (validationContextWasNull) {
                        this.validationContext.freeResources();
                        this.validationContext = null;
                    }
                    if (cfg != null && currentCfg != cfg) {
                        DataSourceManager.free(cfg.getDataSource());
                    }
                    this.setEnumTranslateStrategy(savedEnumTranslateStrategy);
                    this.setEnumOrdinalProperty(savedEnumOrdinalProperty);
                    this.setEnumConstantProperty(savedEnumConstantProperty);
                    throw new UnconvertableException(DataTools.getStackTrace(e));
                }
            }
            if (javaObj instanceof Document) {
                Object document = ((Document)javaObj).getDocumentElement();
                if (cfg != null) {
                    document = new JSTranslaterDSConfig(document, cfg);
                }
                this.convert(document, out, beanFilter);
            } else if (javaObj.getClass().getName().startsWith("org.joda.time")) {
                out.write("\"" + javaObj.toString() + "\"");
            } else if ("org.codehaus.groovy.runtime.GStringImpl".equals(javaObj.getClass().getName())) {
                this.convert(javaObj.toString(), out, beanFilter);
            } else {
                long nanos = System.nanoTime();
                try {
                    Map propertyMap = null;
                    if (beanFilter instanceof IContextBeanFilterWithNullControl) {
                        contextNanos = System.nanoTime();
                        propertyMap = ((IContextBeanFilterWithNullControl)beanFilter).filter(javaObj, this.typeLookupVC, this.omitNullMapValues || cfg == null || cfg.getOmitNullMapValues());
                    } else if (beanFilter instanceof IContextBeanFilter) {
                        contextNanos = System.nanoTime();
                        propertyMap = ((IContextBeanFilter)beanFilter).filter(javaObj, this.typeLookupVC);
                    } else if (beanFilter != null) {
                        long filterNanos = System.nanoTime();
                        propertyMap = beanFilter.filter(javaObj);
                    } else {
                        long propsNanos = System.nanoTime();
                        propertyMap = DataTools.getProperties(javaObj, this.beanIntrospectorOptions);
                    }
                    if (propertyMap.containsKey("class")) {
                        propertyMap.remove("class");
                    }
                    this.convertMap(propertyMap, out, null, cfg);
                }
                catch (Exception e) {
                    if (validationContextWasNull) {
                        this.validationContext.freeResources();
                        this.validationContext = null;
                    }
                    if (cfg != null && currentCfg != cfg) {
                        DataSourceManager.free(cfg.getDataSource());
                    }
                    this.setEnumTranslateStrategy(savedEnumTranslateStrategy);
                    this.setEnumOrdinalProperty(savedEnumOrdinalProperty);
                    this.setEnumConstantProperty(savedEnumConstantProperty);
                    throw new UnconvertableException(DataTools.getStackTrace(e));
                }
            }
        }
        for (i = recursedList.size() - 1; i >= 0; --i) {
            obj = recursedList.get(i);
            if (obj != javaObj) continue;
            recursedList.remove(i);
            break;
        }
        if (validationContextWasNull) {
            this.validationContext.freeResources();
            this.validationContext = null;
        }
        if (cfg != null && currentCfg != cfg) {
            DataSourceManager.free(cfg.getDataSource());
        }
        this.setEnumTranslateStrategy(savedEnumTranslateStrategy);
        this.setEnumOrdinalProperty(savedEnumOrdinalProperty);
        this.setEnumConstantProperty(savedEnumConstantProperty);
    }

    private String convertSimple(Object javaObj, JSTranslaterDSConfig cfg) throws UnconvertableException, IOException {
        StringWriter out = new StringWriter();
        if (this.convertSimple(javaObj, out, cfg)) {
            return out.toString();
        }
        return null;
    }

    private boolean convertSimple(Object javaObj, Writer out, JSTranslaterDSConfig cfg) throws UnconvertableException, IOException {
        ++convertSimpleCalls;
        long nanos = System.nanoTime();
        if (javaObj instanceof IDoNotSerialize) {
            this.convertString("Serialization suppressed for instance of IDoNotSerialize", out, cfg);
            JSTranslater.convertSimpleDetailLapse("IDoNoSerialize", nanos);
        } else if (javaObj instanceof String) {
            this.convertString((String)javaObj, out, cfg);
            JSTranslater.convertSimpleDetailLapse("String", nanos);
        } else if (javaObj instanceof Character) {
            this.convertString(String.valueOf((Character)javaObj), out, cfg);
            JSTranslater.convertSimpleDetailLapse("Character", nanos);
        } else if (javaObj instanceof LocaleMessage) {
            this.convertString(((LocaleMessage)javaObj).getMessage(this.getLocale()), out, cfg);
            JSTranslater.convertSimpleDetailLapse("LocaleMessage", nanos);
        } else if (javaObj instanceof Clob) {
            this.convertSqlClob((Clob)javaObj, out, cfg);
            JSTranslater.convertSimpleDetailLapse("SqlClob", nanos);
        } else if (javaObj instanceof Date) {
            this.convertDate((Date)javaObj, out, cfg);
            JSTranslater.convertSimpleDetailLapse("Date", nanos);
        } else if (javaObj instanceof Calendar) {
            this.convertDate(((Calendar)javaObj).getTime(), out, cfg);
            JSTranslater.convertSimpleDetailLapse("Calendar", nanos);
        } else if (javaObj instanceof DateTime) {
            this.convertDate(((DateTime)javaObj).toDate(), out, cfg);
            JSTranslater.convertSimpleDetailLapse("jodaDateTime", nanos);
        } else if (javaObj instanceof DateMidnight) {
            this.convertDate(((DateMidnight)javaObj).toDate(), out, cfg);
            JSTranslater.convertSimpleDetailLapse("jodaDateMidnight", nanos);
        } else if (javaObj instanceof LocalDateTime) {
            this.convertDate(((LocalDateTime)javaObj).toDate(), out, cfg);
            JSTranslater.convertSimpleDetailLapse("jodaLocalDateTime", nanos);
        } else if (javaObj instanceof LocalDate) {
            this.convertDate(new ISCDate(((LocalDate)javaObj).toDate().getTime()), out, cfg);
            JSTranslater.convertSimpleDetailLapse("jodaLocalDate", nanos);
        } else if (javaObj instanceof LocalTime) {
            this.convertDate(new ISCTime(((LocalTime)javaObj).toDateTimeToday().toDate().getTime()), out, cfg);
            JSTranslater.convertSimpleDetailLapse("jodaLocalTime", nanos);
        } else if (javaObj instanceof XMLGregorianCalendar) {
            this.convertDate(new Date(((XMLGregorianCalendar)javaObj).toGregorianCalendar().getTimeInMillis()), out, cfg);
            JSTranslater.convertSimpleDetailLapse("XMLGregorianCalendar", nanos);
        } else if (javaObj instanceof Number) {
            if (disableStringInBrowser == null) {
                disableStringInBrowser = Config.getGlobal().getBoolean((Object)"datasource.disableStringInBrowser", false);
                log.debug("disableStringInBrowser = " + disableStringInBrowser);
            }
            if (disableStringInBrowser.booleanValue()) {
                out.write(javaObj.toString());
                JSTranslater.convertSimpleDetailLapse("Number", nanos);
            } else {
                DataSource ds;
                DSField field;
                Object stringInBrowser;
                long nanos2 = System.nanoTime();
                if (cfg != null && cfg.getFieldName() != null && (stringInBrowser = (field = (ds = cfg.getDataSource()).getField(cfg.getFieldName())).get("stringInBrowser")) != null) {
                    if (DataTools.asBoolean(stringInBrowser)) {
                        out.write("\"");
                        out.write(javaObj.toString());
                        out.write("\"");
                    } else {
                        out.write(javaObj.toString());
                    }
                    return true;
                }
                if (config.getBoolean((Object)"datasource.defaultStringInBrowser", true)) {
                    if (javaObj instanceof Long) {
                        long l = (Long)javaObj;
                        if (l < -9007199254740992L || l > 0x20000000000000L) {
                            out.write("\"");
                            out.write(javaObj.toString());
                            out.write("\"");
                        } else {
                            out.write(javaObj.toString());
                        }
                    } else if (javaObj instanceof BigInteger) {
                        BigInteger l = (BigInteger)javaObj;
                        if (l.compareTo(new BigInteger("-9007199254740992")) < 0 || l.compareTo(new BigInteger("9007199254740992")) > 0) {
                            out.write("\"");
                            out.write(javaObj.toString());
                            out.write("\"");
                        } else {
                            out.write(javaObj.toString());
                        }
                    } else if (javaObj instanceof BigDecimal) {
                        BigDecimal bd = (BigDecimal)javaObj;
                        double d = bd.doubleValue();
                        if (Double.isInfinite(d) || Double.isNaN(d) || bd.compareTo(new BigDecimal("-9007199254740992")) < 0 || bd.compareTo(new BigDecimal("9007199254740992")) > 0 || bd.precision() > 16) {
                            out.write("\"");
                            out.write(javaObj.toString());
                            out.write("\"");
                        } else {
                            out.write(javaObj.toString());
                        }
                    } else {
                        out.write(javaObj.toString());
                    }
                } else {
                    out.write(javaObj.toString());
                }
            }
        } else if (javaObj instanceof Boolean) {
            out.write((Boolean)javaObj != false ? "true" : "false");
            JSTranslater.convertSimpleDetailLapse("Boolean", nanos);
        } else if (javaObj instanceof Class) {
            this.convertString(((Class)javaObj).getName(), out, cfg);
            JSTranslater.convertSimpleDetailLapse("Class", nanos);
        } else if (javaObj == null) {
            out.write("null");
            JSTranslater.convertSimpleDetailLapse("null", nanos);
        } else if (javaObj instanceof byte[]) {
            this.convertByteBuffer((byte[])javaObj, out, cfg);
            JSTranslater.convertSimpleDetailLapse("byteArray", nanos);
        } else if (javaObj instanceof Reader) {
            this.convertReader((Reader)javaObj, out, cfg);
            JSTranslater.convertSimpleDetailLapse("Reader", nanos);
        } else if (VersionSafeChecker.isEnum(javaObj)) {
            this.convertEnum((Enum)javaObj, out, cfg);
            JSTranslater.convertSimpleDetailLapse("Enum", nanos);
        } else {
            String className = javaObj.getClass().getName();
            if ("java.time.LocalDateTime".equals(className)) {
                try {
                    Long _epochDay = (Long)Reflection.invokeMethod(javaObj, "getLong", Reflection.invokeStaticMethod("java.time.temporal.ChronoField", "valueOf", "EPOCH_DAY"));
                    Long _milliOfDay = (Long)Reflection.invokeMethod(javaObj, "getLong", Reflection.invokeStaticMethod("java.time.temporal.ChronoField", "valueOf", "MILLI_OF_DAY"));
                    boolean bl = this.convertSimple(new Date(_epochDay * 24L * 60L * 60L * 1000L + _milliOfDay), out, cfg);
                    return bl;
                }
                catch (Exception e) {
                    throw new UnconvertableException("Failed to translate java.time.LocalDateTime object", e);
                }
                finally {
                    JSTranslater.convertSimpleDetailLapse("LocalDateTime", nanos);
                }
            }
            if ("java.time.LocalDate".equals(className)) {
                try {
                    Long _epochDay = (Long)Reflection.invokeMethod(javaObj, "getLong", Reflection.invokeStaticMethod("java.time.temporal.ChronoField", "valueOf", "EPOCH_DAY"));
                    boolean bl = this.convertSimple(new Date(_epochDay * 24L * 60L * 60L * 1000L), out, cfg);
                    return bl;
                }
                catch (Exception e) {
                    throw new UnconvertableException("Failed to translate java.time.LocalDate object", e);
                }
                finally {
                    JSTranslater.convertSimpleDetailLapse("LocalDate", nanos);
                }
            }
            if ("java.time.LocalTime".equals(className)) {
                try {
                    Long _milliOfDay = (Long)Reflection.invokeMethod(javaObj, "getLong", Reflection.invokeStaticMethod("java.time.temporal.ChronoField", "valueOf", "MILLI_OF_DAY"));
                    boolean bl = this.convertSimple(new Date(_milliOfDay), out, cfg);
                    return bl;
                }
                catch (Exception e) {
                    throw new UnconvertableException("Failed to translate java.time.LocalTime object", e);
                }
                finally {
                    JSTranslater.convertSimpleDetailLapse("LocalTime", nanos);
                }
            }
            if ("java.time.Instant".equals(className)) {
                try {
                    boolean e = this.convertSimple(Reflection.invokeStaticMethod("java.util.Date", "from", javaObj), out, cfg);
                    return e;
                }
                catch (Exception e) {
                    throw new UnconvertableException("Failed to translate java.time.Instant object", e);
                }
                finally {
                    JSTranslater.convertSimpleDetailLapse("Instant", nanos);
                }
            }
            if ("java.time.ZonedDateTime".equals(className)) {
                try {
                    boolean e = this.convertSimple(Reflection.invokeStaticMethod("java.util.Date", "from", Reflection.invokeMethod(javaObj, "toInstant")), out, cfg);
                    return e;
                }
                catch (Exception e) {
                    throw new UnconvertableException("Failed to translate java.time.ZonedDateTime object", e);
                }
                finally {
                    JSTranslater.convertSimpleDetailLapse("ZonedDateTime", nanos);
                }
            }
            if ("oracle.sql.TIMESTAMP".equals(className)) {
                try {
                    boolean e = this.convertSimple(Reflection.invokeMethod(javaObj, "timestampValue"), out, cfg);
                    return e;
                }
                catch (Exception e) {
                    throw new UnconvertableException(e.getMessage());
                }
                finally {
                    JSTranslater.convertSimpleDetailLapse("OracleTimestamp", nanos);
                }
            }
            if (sendAsJSString.contains(className)) {
                this.convertString(javaObj.toString(), out, cfg);
                return true;
            }
            if (this.alwaysToString || safeToString.contains(className)) {
                out.write(javaObj.toString());
                return true;
            }
            return false;
        }
        return true;
    }

    private static void convertSimpleDetailLapse(String category, long start) {
    }

    public static String getConvertSimpleDetail() {
        return "TRACE_JSTRANSLATER_TIMINGS is switched off!";
    }

    public static void clearConvertSimpleDetail() {
        convertSimpleLapseMap.clear();
    }

    private String convertMapKey(Object javaObj, JSTranslaterDSConfig cfg) throws UnconvertableException, IOException {
        String convertedKey;
        if (javaObj instanceof Date) {
            return null;
        }
        String string = convertedKey = javaObj instanceof String ? (String)javaObj : this.convertSimple(javaObj, cfg);
        if (convertedKey == null) {
            return null;
        }
        if (!(convertedKey.length() > 1 && convertedKey.startsWith("\"") && convertedKey.endsWith("\"") || convertedKey.length() > 1 && convertedKey.startsWith("'") && convertedKey.endsWith("'") || !this.strictJSONMode && !reservedWords.contains(convertedKey) && JSTranslater.isValidJSIdentifier(convertedKey))) {
            convertedKey = this.convertSimple(convertedKey, cfg);
        }
        return convertedKey;
    }

    boolean isAList(Object obj) {
        return obj instanceof Object[] || obj instanceof Collection || obj instanceof Iterator || obj instanceof Enumeration;
    }

    private void convertByteBuffer(byte[] buf, Writer out, JSTranslaterDSConfig cfg) throws UnconvertableException, IOException {
        String theString = new String(buf);
        out.write("\"");
        if (theString != null) {
            out.write(theString);
        }
        out.write("\"");
    }

    private void convertReader(Reader reader, Writer out, JSTranslaterDSConfig cfg) throws UnconvertableException, IOException {
        StringWriter sw = new StringWriter();
        IOUtil.copyCharacterStreams(reader, sw);
        this.convertString(sw.toString(), out, cfg);
    }

    private void convertEnum(Enum e, Writer out, JSTranslaterDSConfig cfg) throws UnconvertableException, IOException {
        if (this.enumTranslateStrategy == null) {
            out.write("\"" + e.toString() + "\"");
        } else if (this.enumTranslateStrategy.toLowerCase().equals("name")) {
            out.write("\"" + e.name() + "\"");
        } else if (this.enumTranslateStrategy.toLowerCase().equals("ordinal")) {
            out.write(String.valueOf(e.ordinal()));
        } else if (this.enumTranslateStrategy.toLowerCase().equals("bean")) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put(this.ordinalProperty, e.ordinal());
            map.put(this.constantProperty, e.toString());
            Map<String, PropertyDescriptor> propMap = null;
            try {
                propMap = DataTools.getPropertyDescriptors(e);
            }
            catch (Exception ex) {
                log.warn("getPropertyDescriptors() threw an execption when translating an enum '" + String.valueOf(e) + "'. " + ex.getMessage());
            }
            if (propMap != null) {
                for (String propName : propMap.keySet()) {
                    Method readMethod;
                    PropertyDescriptor prop;
                    if ("class".equals(propName) || "declaringClass".equals(propName) || (prop = propMap.get(propName)) == null || (readMethod = prop.getReadMethod()) == null) continue;
                    try {
                        Object value = readMethod.invoke((Object)e, null);
                        map.put(propName, value);
                    }
                    catch (Exception ex) {
                        log.warn(e);
                    }
                }
            }
            this.convertMap(map, out, null, null);
        } else {
            out.write("\"" + e.toString() + "\"");
        }
    }

    boolean isLeaf(Object value) {
        if (value == null || value instanceof String) {
            return true;
        }
        if (value instanceof Collection || value instanceof Map || value instanceof Object[]) {
            return false;
        }
        return value instanceof Boolean || value instanceof Date || value instanceof Number || value instanceof Time || this.safeToString(value);
    }

    boolean containsOnlyLeaves(Collection list) {
        Iterator i = list.iterator();
        while (i.hasNext()) {
            if (this.isLeaf(i.next())) continue;
            return false;
        }
        return true;
    }

    boolean containsOnlyLeaves(Map map) {
        for (Object key : map.keySet()) {
            Object value = map.get(key);
            if (this.isLeaf(key) && this.isLeaf(value)) continue;
            return false;
        }
        return true;
    }

    private void convertMap(Map inputMap, Writer out, IBeanFilter beanFilter, JSTranslaterDSConfig cfg) throws UnconvertableException, IOException {
        Object constructorObj;
        Object map = inputMap.getClass().getName().equals("org.hibernate.util.IdentityMap") || inputMap.getClass().getName().equals("org.hibernate.internal.util.collections.IdentityMap") ? ListOrderedMap.listOrderedMap((Map)inputMap) : inputMap;
        boolean collapse = false;
        if (this.prettyPrinting && this.collapseSmallContainers) {
            if (this.containsOnlyLeaves((Map)map)) {
                collapse = true;
            } else {
                this.propNameIndent = 0;
            }
        }
        String constructor = null;
        if (map.containsKey("__autoConstruct") && (constructorObj = map.get("__autoConstruct")) != null) {
            constructor = constructorObj.toString();
            if (constructor.contains(".")) {
                out.write("isc.ClassFactory.newInstance(\"" + constructor + "\", ");
            } else {
                out.write("isc." + constructor + ".create(");
            }
        }
        out.write("{");
        if (this.prettyPrinting && !collapse) {
            ++this.currentIndentDepth;
        }
        int linePos = this.currentIndentDepth * 4;
        int elemLength = 0;
        boolean dropLine = true;
        boolean startingLine = true;
        if (beanFilter != null) {
            try {
                map = beanFilter instanceof IContextBeanFilterWithNullControl ? ((IContextBeanFilterWithNullControl)beanFilter).filter(map, this.typeLookupVC, this.omitNullMapValues || cfg == null || cfg.getOmitNullMapValues()) : (beanFilter instanceof IContextBeanFilter ? ((IContextBeanFilter)beanFilter).filter(map, this.typeLookupVC) : beanFilter.filter(map));
            }
            catch (Exception e) {
                log.warn((Object)"Error in convertMap trying to filter bean", e);
                throw new UnconvertableException("Error in convertMap trying to filter bean: " + e.getMessage());
            }
        }
        Set mapKeys = map.keySet();
        if (constructor != null) {
            mapKeys = new LinkedHashSet(mapKeys);
            mapKeys.remove("__autoConstruct");
        }
        Object obfuscatedValueInAdvancedCriteria = null;
        if (this.obfuscation && this.obfuscateMapKeys != null && mapKeys.contains("fieldName") && mapKeys.contains("operator") && mapKeys.contains("value")) {
            obfuscatedValueInAdvancedCriteria = this.obfuscateMapKeys.get(map.get("fieldName"));
        }
        boolean hadOneKey = false;
        for (Object key : mapKeys) {
            DSField field;
            String convertedKey;
            Object obfuscatedValue;
            Object value = map.get(key);
            if (this.omitNullMapValues && value == null) continue;
            if (ISCBinaryValue.isBinary(value)) {
                DataSource ds;
                String fileContentsField = null;
                DSField binaryField = null;
                if (cfg != null && (ds = cfg.getDataSource()) != null) {
                    fileContentsField = (String)ds.getConfig().get("fileContentsField");
                    binaryField = ds.getField(key.toString());
                }
                if (fileContentsField != null && fileContentsField.equals(key) || fileContentsField == null && ("fileContents".equals(key) || "contents".equals(key))) {
                    String fileEncoding = (String)map.get("fileEncoding");
                    ByteArrayOutputStream os = new ByteArrayOutputStream();
                    ISCBinaryValue.copyToOutputStream(value, os);
                    value = fileEncoding == null ? os.toString() : os.toString(fileEncoding);
                } else {
                    if (binaryField == null || !(value instanceof byte[]) || !"text".equals(binaryField.getType())) continue;
                    value = new String((byte[])value);
                }
            }
            if (this.obfuscation && this.obfuscateMapKeys != null && value != null && (value instanceof String || DataTools.isNumberType(value.getClass())) && (obfuscatedValue = this.obfuscateMapKeys.get(key)) != null) {
                value = obfuscatedValue;
            }
            if ("value".equals(key) && value instanceof String && obfuscatedValueInAdvancedCriteria != null) {
                value = obfuscatedValueInAdvancedCriteria;
            }
            if ((convertedKey = this.convertMapKey(key, cfg)) == null) {
                log.info("Ignoring unconvertible Map key of type: " + key.getClass().getName());
                continue;
            }
            if (cfg != null && (field = cfg.getDataSource().getField(key.toString())) != null) {
                value = new JSTranslaterDSConfig(value, cfg.getDataSource(), field.getName());
                ((JSTranslaterDSConfig)value).setBypassDataFilter(cfg.getBypassDataFilter());
            }
            String convertedValue = this.convert(value);
            if (collapse) {
                elemLength = convertedKey.length() + convertedValue.length() + 2;
                boolean bl = dropLine = !startingLine && elemLength + linePos > 100;
            }
            if (hadOneKey) {
                out.write(",");
                if (!dropLine) {
                    out.write(" ");
                }
            } else {
                hadOneKey = true;
            }
            if (this.prettyPrinting) {
                if (dropLine) {
                    out.write("\n");
                    this.indentToCurrentDepth(out);
                    startingLine = true;
                    if (collapse) {
                        this.indent(this.propNameIndent + 1, out);
                        linePos = this.currentIndentDepth * 4 + this.propNameIndent + 1;
                    }
                } else {
                    startingLine = false;
                }
                linePos += elemLength;
            }
            out.write(convertedKey);
            if (this.prettyPrinting && !collapse) {
                this.propNameIndent = convertedKey.length() + 1;
            }
            out.write(":");
            out.write(convertedValue);
            if (!this.prettyPrinting || collapse) continue;
            this.propNameIndent = 0;
        }
        if (this.prettyPrinting) {
            if (!collapse) {
                out.write("\n");
                --this.currentIndentDepth;
                this.indentToCurrentDepth(out);
            }
            out.write("}");
        } else {
            out.write("}");
        }
        if (constructor != null) {
            out.write(")\n");
        }
    }

    private void convertArray(Object[] array2, Writer out, IBeanFilter beanFilter, JSTranslaterDSConfig cfg) throws UnconvertableException, IOException {
        this.convertCollection(Arrays.asList(array2), out, beanFilter, cfg);
    }

    private void convertPrimitiveArray(Object array2, Writer out, IBeanFilter beanFilter, JSTranslaterDSConfig cfg) throws UnconvertableException, IOException {
        if (array2 instanceof boolean[]) {
            this.convertArray(ArrayUtils.toObject((boolean[])((boolean[])array2)), out, beanFilter, cfg);
        } else if (array2 instanceof char[]) {
            this.convertArray(ArrayUtils.toObject((char[])((char[])array2)), out, beanFilter, cfg);
        } else if (array2 instanceof byte[]) {
            this.convertArray(ArrayUtils.toObject((byte[])((byte[])array2)), out, beanFilter, cfg);
        } else if (array2 instanceof double[]) {
            this.convertArray(ArrayUtils.toObject((double[])((double[])array2)), out, beanFilter, cfg);
        } else if (array2 instanceof float[]) {
            this.convertArray(ArrayUtils.toObject((float[])((float[])array2)), out, beanFilter, cfg);
        } else if (array2 instanceof int[]) {
            this.convertArray(ArrayUtils.toObject((int[])((int[])array2)), out, beanFilter, cfg);
        } else if (array2 instanceof short[]) {
            this.convertArray(ArrayUtils.toObject((short[])((short[])array2)), out, beanFilter, cfg);
        } else if (array2 instanceof long[]) {
            this.convertArray(ArrayUtils.toObject((long[])((long[])array2)), out, beanFilter, cfg);
        } else {
            String error = "Unknown array of primitive type." + (array2 == null ? "null" : array2.getClass().getName());
            log.error(error);
            throw new UnconvertableException(error);
        }
    }

    private void convertCollection(Collection collection, Writer out, IBeanFilter beanFilter, JSTranslaterDSConfig cfg) throws UnconvertableException, IOException {
        boolean collapse = false;
        if (this.prettyPrinting && this.collapseSmallContainers) {
            if (this.containsOnlyLeaves(collection)) {
                collapse = true;
            } else {
                this.propNameIndent = 0;
            }
        }
        this.convertIterator(collection.iterator(), out, beanFilter, collapse, cfg);
    }

    private void convertIterator(Iterator list, Writer out, IBeanFilter beanFilter, JSTranslaterDSConfig cfg) throws UnconvertableException, IOException {
        this.convertIterator(list, out, beanFilter, false, cfg);
    }

    private void convertIterator(Iterator iterator, Writer out, IBeanFilter beanFilter, boolean collapse, JSTranslaterDSConfig cfg) throws UnconvertableException, IOException {
        out.write("[");
        if (this.prettyPrinting && !collapse) {
            ++this.currentIndentDepth;
        }
        int linePos = this.currentIndentDepth * 4;
        int itemLength = 0;
        boolean dropLine = true;
        boolean typeLookupVCWasNull = false;
        if (this.typeLookupVC == null) {
            this.typeLookupVC = new ValidationContext();
            typeLookupVCWasNull = true;
        }
        while (iterator.hasNext()) {
            Object item = iterator.next();
            if (collapse) {
                itemLength = this.convert(item).length() + 2;
                boolean bl = dropLine = itemLength + linePos > 100;
            }
            if (this.prettyPrinting && dropLine) {
                out.write("\n");
                this.indentToCurrentDepth(out);
                if (collapse) {
                    this.indent(this.propNameIndent + 1, out);
                }
                linePos = this.currentIndentDepth * 4 + this.propNameIndent;
            } else {
                linePos += itemLength;
            }
            if (cfg != null) {
                item = new JSTranslaterDSConfig(item, cfg);
            }
            this.convert(item, out, this.isAList(item) ? null : beanFilter);
            if (!iterator.hasNext()) continue;
            out.write(",");
            if (dropLine) continue;
            out.write(" ");
        }
        if (this.prettyPrinting) {
            if (!collapse) {
                out.write("\n");
                --this.currentIndentDepth;
                this.indentToCurrentDepth(out);
            }
            out.write("]");
        } else {
            out.write("]");
        }
        if (typeLookupVCWasNull) {
            this.typeLookupVC.freeResources();
            this.typeLookupVC = null;
        }
    }

    private void convertEnumeration(final Enumeration e, Writer out, IBeanFilter beanFilter, JSTranslaterDSConfig cfg) throws UnconvertableException, IOException {
        this.convertIterator(new Iterator(){

            @Override
            public boolean hasNext() {
                return e.hasMoreElements();
            }

            public Object next() {
                return e.nextElement();
            }

            @Override
            public void remove() {
            }
        }, out, beanFilter, cfg);
    }

    private void convertDate(Date date, Writer out, JSTranslaterDSConfig cfg) throws UnconvertableException, IOException {
        if (this.writeXMLSchemaDate) {
            if (date instanceof ISCDate) {
                out.write("\"" + this.dateFormat.format(date) + "\"");
            } else if (date instanceof ISCTime) {
                out.write("\"" + this.xmlSchemaTimeFormat.format(date) + "\"");
            } else {
                out.write("\"" + this.datetimeFormat.format(date) + "\"");
            }
        } else if (this.writePrefixedDate) {
            out.write("\"$$DATE$$:");
            out.write(DataTools.fastDateFormat(date, false, false, this.cacheCalendar, this.trimMilliseconds));
            out.write("\"");
        } else if (this.strictJSONMode) {
            if (date instanceof ISCDate) {
                Calendar calendar = Calendar.getInstance();
                calendar.setTime(date);
                out.write("\"$$DATE$$:" + calendar.get(1) + "-" + (calendar.get(2) + 1) + "-" + calendar.get(5) + "\"");
            } else if (date instanceof ISCTime) {
                Calendar calendar = Calendar.getInstance();
                calendar.setTime(date);
                String output = "\"$$TIME$$:" + calendar.get(11) + ":" + calendar.get(12) + ":" + calendar.get(13);
                if (!this.trimMilliseconds) {
                    output = output + "." + calendar.get(14);
                }
                output = output + "\"";
                out.write(output);
            } else {
                out.write("\"$$DATESTAMP$$:");
                long millis = date.getTime();
                if (this.trimMilliseconds) {
                    millis /= 1000L;
                    millis *= 1000L;
                }
                out.write(String.valueOf(millis));
                out.write("\"");
            }
        } else if (date instanceof ISCDate) {
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(date);
            String dateArgs = calendar.get(1) + "," + calendar.get(2) + "," + calendar.get(5);
            if (writeNativeDate) {
                out.write("new Date(" + dateArgs + ")");
            } else {
                out.write("isc.DateUtil.parseServerDate(" + dateArgs + ")");
            }
        } else if (date instanceof ISCTime) {
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(date);
            String timeArgs = calendar.get(11) + "," + calendar.get(12) + "," + calendar.get(13);
            if (!this.trimMilliseconds) {
                timeArgs = timeArgs + "," + calendar.get(14);
            }
            out.write("isc.DateUtil.parseServerTime(" + timeArgs + ")");
        } else {
            long millis = date.getTime();
            if (this.trimMilliseconds) {
                millis /= 1000L;
                millis *= 1000L;
            }
            out.write("new Date(" + millis + ")");
        }
    }

    private void convertSqlClob(Clob clob, Writer out, JSTranslaterDSConfig cfg) throws UnconvertableException, IOException {
        try {
            this.convertString(clob.getSubString(1L, (int)clob.length()), out, cfg);
        }
        catch (SQLException se) {
            log.error((Object)"Error converting Clob", se);
            throw new UnconvertableException(se.toString());
        }
    }

    private void convertString(String value, Writer out, JSTranslaterDSConfig cfg) throws UnconvertableException, IOException {
        out.write("\"");
        boolean substituting = false;
        int copiedFrom = 0;
        int length = value.length();
        block15: for (int i = 0; i < length; ++i) {
            char quote = value.charAt(i);
            switch (quote) {
                case '<': {
                    if (this.quoteForXML) {
                        substituting = true;
                        out.write(value.substring(copiedFrom, i));
                        out.write("&lt;");
                        copiedFrom = i + 1;
                        continue block15;
                    }
                    if (length <= i + 8 || value.charAt(i + 1) != '/') continue block15;
                    if (!this.quoteForTextArea && value.regionMatches(true, i + 2, "script>", 0, 7)) {
                        substituting = true;
                        out.write(value.substring(copiedFrom, i));
                        out.write("<\\");
                        out.write(value.substring(i + 1, i + 9));
                        copiedFrom = i + 9;
                        i += 8;
                        continue block15;
                    }
                    if (!this.quoteForTextArea || !value.regionMatches(true, i + 2, "textarea>", 0, 9)) continue block15;
                    substituting = true;
                    out.write(value.substring(copiedFrom, i));
                    out.write("<\\");
                    out.write(value.substring(i + 1, i + 11));
                    copiedFrom = i + 11;
                    i += 10;
                    continue block15;
                }
                case '>': {
                    if (!this.quoteForXML) continue block15;
                    substituting = true;
                    out.write(value.substring(copiedFrom, i));
                    out.write("&gt;");
                    copiedFrom = i + 1;
                    continue block15;
                }
                case '\t': 
                case '\n': 
                case '\r': 
                case '\"': 
                case '\\': 
                case '\u2028': 
                case '\u2029': {
                    substituting = true;
                    out.write(value.substring(copiedFrom, i));
                    switch (quote) {
                        case '\r': {
                            out.write("\\r");
                            break;
                        }
                        case '\n': {
                            out.write("\\n");
                            break;
                        }
                        case '\"': {
                            out.write("\\\"");
                            break;
                        }
                        case '\\': {
                            out.write("\\\\");
                            break;
                        }
                        case '\t': {
                            out.write("\\t");
                            break;
                        }
                        case '\u2028': {
                            out.write("\\u2028");
                            break;
                        }
                        case '\u2029': {
                            out.write("\\u2029");
                        }
                    }
                    copiedFrom = i + 1;
                    continue block15;
                }
                case '&': {
                    if (this.quoteForXML) {
                        substituting = true;
                        out.write(value.substring(copiedFrom, i));
                        out.write("&amp;");
                        copiedFrom = i + 1;
                        continue block15;
                    }
                    if (!this.quoteForTextArea || value.length() > i + 1 && " \n\r".indexOf(value.charAt(i + 1)) != -1) continue block15;
                    substituting = true;
                    out.write(value.substring(copiedFrom, i));
                    out.write("&amp;");
                    copiedFrom = i + 1;
                }
            }
        }
        if (substituting) {
            out.write(value.substring(copiedFrom));
        } else {
            out.write(value);
        }
        out.write("\"");
    }

    public void toJSVariableInScript(Object javaObj, String variableName, Writer out) throws UnconvertableException, IOException {
        if (variableName == null) {
            return;
        }
        out.write("<SCRIPT>\n");
        this.toJSVariable(javaObj, variableName, out);
        out.write("</SCRIPT>\n");
    }

    public void toJSVariable(Object javaObj, String variableName, Writer out) throws UnconvertableException, IOException {
        if (variableName == null) {
            return;
        }
        out.write("var " + variableName + " = ");
        this.toJS(javaObj, out);
        out.write(";\n");
    }

    public Map fromJS(Map params) {
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
        for (String key : params.keySet()) {
            String value = (String)params.get(key);
            if (value == null || value.length() == 0 || value.equals("null")) continue;
            try {
                result.put(key, this.fromJS(value));
            }
            catch (UnconvertableException ue) {
                log.error("Value " + value + " for key " + key + " is unconvertable, ignoring.");
            }
        }
        return result;
    }

    public Object fromJS(String jsData) throws UnconvertableException {
        if (jsData == null) {
            return null;
        }
        return this.fromJS(new StringReader(jsData));
    }

    public Object fromJS(InputStream jsData) throws UnconvertableException {
        return this.fromJS(new InputStreamReader(jsData));
    }

    public Object fromJS(Reader jsData) throws UnconvertableException {
        if (jsData == null) {
            return null;
        }
        try {
            IJSParser parser = (IJSParser)InterfaceProvider.load("IJSParser");
            parser.preserveLiteralNulls(this.preserveLiteralNulls);
            return parser.parseDataStruct(this.getEOFReader(jsData));
        }
        catch (Exception pe) {
            String error = "parse failure: \n" + pe.toString();
            log.error(error);
            throw new UnconvertableException(error, pe);
        }
    }

    public Object fromJSMap(String jsData) throws UnconvertableException {
        return this.fromJSMap(new StringReader(jsData));
    }

    public Object fromJSMap(InputStream jsData) throws UnconvertableException {
        return this.fromJSMap(new InputStreamReader(jsData));
    }

    public Object fromJSMap(Reader jsData) throws UnconvertableException {
        if (jsData == null) {
            return null;
        }
        try {
            IJSParser parser = (IJSParser)InterfaceProvider.load("IJSParser");
            return parser.parseDataMap(this.getEOFReader(jsData));
        }
        catch (Exception pe) {
            String error = "parse failure: \n" + pe.toString();
            log.error((Object)error, pe);
            throw new UnconvertableException(error);
        }
    }

    private Reader getEOFReader(Reader in) throws IOException {
        return new SequenceReader(in, "//>START PARSING\n");
    }

    public static boolean isValidJSIdentifier(String str) {
        if (str == null || str.length() == 0) {
            return false;
        }
        char c = str.charAt(0);
        int length = str.length();
        if (!JSTranslater.isJSIdentifierStart(c)) {
            return false;
        }
        for (int i = 1; i < length; ++i) {
            c = str.charAt(i);
            if (JSTranslater.isJSIdentifierPart(c)) continue;
            return false;
        }
        return true;
    }

    public static boolean isJSIdentifierPart(char c) {
        return JSTranslater.isJSIdentifierStart(c) || Character.isDigit(c);
    }

    public static boolean isJSIdentifierStart(char c) {
        return Character.isLetter(c) || c == '_' || c == '$';
    }

    public static boolean isJSReservedWord(String s) {
        return reservedWords.contains(s);
    }

    public String getEnumTranslateStrategy() {
        return this.enumTranslateStrategy;
    }

    public void setEnumTranslateStrategy(String newValue) {
        if (newValue != null) {
            this.enumTranslateStrategy = newValue;
        }
    }

    public String getEnumOrdinalProperty() {
        return this.ordinalProperty;
    }

    public String getEnumConstantProperty() {
        return this.enumTranslateStrategy;
    }

    public void setEnumOrdinalProperty(String newValue) {
        if (newValue != null) {
            this.ordinalProperty = newValue;
        }
    }

    public void setEnumConstantProperty(String newValue) {
        if (newValue != null) {
            this.constantProperty = newValue;
        }
    }

    public DSRequest getDSRequest(DSRequest dsReq) {
        return this.dsRequest;
    }

    public void setDSRequest(DSRequest dsReq) {
        this.dsRequest = dsReq;
    }

    static {
        TimeZone z = TimeZone.getTimeZone("UTC");
        sharedDateTimeFormat.setTimeZone(z);
        sharedXmlSchemaDateTimeFormat.setTimeZone(z);
        EMPTY_ARRAY = new Object[0];
        types = new HashMap();
        safeToString = new HashSet();
        sendAsJSString = new HashSet();
        sendAsJSString.addAll(Arrays.asList("java.net.URL", "java.net.URI"));
        reservedWords = new HashSet();
        reservedWords.addAll(Arrays.asList("abstract", "boolean", "break", "byte", "case", "catch", "char", "class", "const", "continue", "default", "delete", "do", "double", "else", "enum", "export", "extends", "false", "final", "finally", "float", "for", "function", "goto", "if", "implements", "import", "in", "instanceof", "int", "interface", "long", "native", "new", "null", "package", "private", "protected", "public", "return", "short", "static", "super", "switch", "synchronized", "this", "throw", "throws", "transient", "true", "try", "typeof", "var", "void", "while", "with", "debugger", "undefined"));
        convertLapse = 0L;
        convertContextLapse = 0L;
        convertFilterLapse = 0L;
        convertPropsLapse = 0L;
        convertSimpleLapse = 0L;
        stringInBrowserLapse = 0L;
        convertSimpleCalls = 0L;
        disableStringInBrowser = null;
        convertSimpleLapseMap = new HashMap<String, Long>();
    }
}

