/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.validation.client.impl.metadata;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import javax.validation.groups.Default;

public class ValidationGroupsMetadata {
    private final Map<Class<?>, Set<Class<?>>> inheritanceMapping;
    private final Map<Class<?>, List<Class<?>>> sequenceMapping;

    public static Builder builder() {
        return new Builder();
    }

    private ValidationGroupsMetadata(Map<Class<?>, Set<Class<?>>> inheritanceinheritanceMap, Map<Class<?>, List<Class<?>>> sequenceMap) {
        this.inheritanceMapping = Collections.unmodifiableMap(inheritanceinheritanceMap);
        this.sequenceMapping = Collections.unmodifiableMap(sequenceMap);
    }

    public boolean containsGroup(Class<?> group) {
        return this.inheritanceMapping.containsKey(group);
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof ValidationGroupsMetadata)) {
            return false;
        }
        ValidationGroupsMetadata otherObj = (ValidationGroupsMetadata)other;
        return this.inheritanceMapping.equals(otherObj.inheritanceMapping) && this.sequenceMapping.equals(otherObj.sequenceMapping);
    }

    public Set<Class<?>> findAllExtendedGroups(Collection<Class<?>> baseGroups) throws IllegalArgumentException {
        HashSet found = new HashSet();
        Stack remaining = new Stack();
        for (Class<?> group : baseGroups) {
            if (!this.inheritanceMapping.containsKey(group)) {
                throw new IllegalArgumentException("The collection of groups contains a group which was not added to the map. Be sure to call addGroup() for all groups first.");
            }
            remaining.push(group);
        }
        while (!remaining.isEmpty()) {
            Class current = (Class)remaining.pop();
            found.add(current);
            Set<Class<?>> superInterfaces = this.inheritanceMapping.get(current);
            for (Class<?> parent : superInterfaces) {
                if (found.contains(parent)) continue;
                remaining.push(parent);
            }
        }
        return found;
    }

    public Set<Class<?>> getAllGroupsAndSequences() {
        HashSet allGroups = new HashSet();
        for (Map.Entry<Class<?>, Set<Class<?>>> entry : this.inheritanceMapping.entrySet()) {
            allGroups.add(entry.getKey());
            allGroups.addAll((Collection)entry.getValue());
        }
        allGroups.addAll(this.sequenceMapping.keySet());
        return allGroups;
    }

    public Set<Class<?>> getGroupSequences() {
        return this.sequenceMapping.keySet();
    }

    public Set<Class<?>> getParentsOfGroup(Class<?> group) {
        return this.inheritanceMapping.get(group);
    }

    public Set<Class<?>> getRootGroups() {
        return this.inheritanceMapping.keySet();
    }

    public List<Class<?>> getSequenceList(Class<?> sequence) {
        return this.sequenceMapping.get(sequence);
    }

    public int hashCode() {
        int result = this.inheritanceMapping.hashCode();
        result = 31 * result + this.sequenceMapping.hashCode();
        return result;
    }

    public boolean hasParents(Class<?> group) {
        Set<Class<?>> possibleParents = this.getParentsOfGroup(group);
        return possibleParents != null && !possibleParents.isEmpty();
    }

    public boolean isInheritanceMapEmpty() {
        return this.inheritanceMapping.isEmpty();
    }

    public boolean isSeqeuence(Class<?> sequence) {
        return this.sequenceMapping.containsKey(sequence);
    }

    public boolean isSequenceMapEmpty() {
        return this.sequenceMapping.isEmpty();
    }

    public String toString() {
        return "ValidationGroupsMetaData{inheritanceMap=" + this.inheritanceMapping + ", sequenceMap=" + this.sequenceMapping + "}";
    }

    public static class Builder {
        private final Map<Class<?>, Set<Class<?>>> inheritanceinheritanceMap = new HashMap();
        private final Map<Class<?>, List<Class<?>>> sequenceMap = new HashMap();

        private Builder() {
            this.addGroup(Default.class, new Class[0]);
        }

        public Builder addGroup(Class<?> group, Class<?> ... parents) {
            this.inheritanceinheritanceMap.put(group, new HashSet(Arrays.asList(parents)));
            return this;
        }

        public Builder addSequence(Class<?> groupSequence, Class<?> ... sequenceGroups) {
            this.sequenceMap.put(groupSequence, Arrays.asList(sequenceGroups));
            return this;
        }

        public ValidationGroupsMetadata build() {
            return new ValidationGroupsMetadata(this.inheritanceinheritanceMap, this.sequenceMap);
        }
    }
}

