/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.core.client.impl;

import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public class WeakMapping {
    private static final Lock cleanupLock = new ReentrantLock();
    private static final ConcurrentHashMap<IdentityWeakReference, Map<String, Object>> map = new ConcurrentHashMap();
    private static ReferenceQueue<Object> queue = new ReferenceQueue();

    public static Object get(Object instance, String key) {
        WeakMapping.cleanup();
        IdentityWeakReference ref = new IdentityWeakReference(instance, queue);
        Map<String, Object> m = map.get(ref);
        if (m == null) {
            return null;
        }
        Object toReturn = m.get(key);
        if (toReturn instanceof ManagedWeakReference) {
            toReturn = ((ManagedWeakReference)toReturn).get();
        }
        return toReturn;
    }

    public static void set(Object instance, String key, Object value) {
        WeakMapping.cleanup();
        if (instance instanceof String) {
            throw new IllegalArgumentException("Cannot use Strings with WeakMapping");
        }
        IdentityWeakReference ref = new IdentityWeakReference(instance, queue);
        Map<String, Object> m = map.get(ref);
        if (m == null) {
            m = new ConcurrentHashMap<String, Object>();
            map.putIfAbsent(ref, m);
            m = map.get(ref);
        }
        if (value == null) {
            m.remove(key);
        } else {
            m.put(key, value);
        }
    }

    public static void setWeak(Object instance, String key, Object value) {
        WeakMapping.set(instance, key, new ManagedWeakReference<Object>(value));
    }

    private static void cleanup() {
        if (cleanupLock.tryLock()) {
            Reference<Object> ref;
            while ((ref = queue.poll()) != null) {
                map.remove(ref);
            }
            cleanupLock.unlock();
        }
    }

    static class IdentityWeakReference
    extends WeakReference<Object> {
        private final int hashCode;

        public IdentityWeakReference(Object referent, ReferenceQueue<Object> queue) {
            super(referent, queue);
            this.hashCode = System.identityHashCode(referent);
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof IdentityWeakReference)) {
                return false;
            }
            Object referent = this.get();
            if (referent == null) {
                return false;
            }
            return referent == ((IdentityWeakReference)other).get();
        }

        public int hashCode() {
            return this.hashCode;
        }
    }

    private static class ManagedWeakReference<T>
    extends WeakReference<T> {
        public ManagedWeakReference(T object) {
            super(object);
        }
    }
}

