/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.boot.spi;

import org.hibernate.AssertionFailure;

public enum AccessType {
    DEFAULT,
    PROPERTY,
    FIELD,
    RECORD;


    public String getType() {
        switch (this) {
            case DEFAULT: 
            case PROPERTY: {
                return "property";
            }
            case FIELD: {
                return "field";
            }
            case RECORD: {
                return "record";
            }
        }
        throw new AssertionFailure("Unknown AccessType");
    }

    public static AccessType getAccessStrategy(String externalName) {
        if (externalName == null) {
            return DEFAULT;
        }
        for (AccessType value : AccessType.values()) {
            if (!value.getType().equals(externalName)) continue;
            return value;
        }
        return DEFAULT;
    }

    public static AccessType getAccessStrategy(jakarta.persistence.AccessType type) {
        if (type == null) {
            return DEFAULT;
        }
        switch (type) {
            case FIELD: {
                return FIELD;
            }
            case PROPERTY: {
                return PROPERTY;
            }
        }
        throw new AssertionFailure("unrecognized AccessType");
    }
}

