/*
 * Decompiled with CFR 0.152.
 */
package com.isomorphic.ai;

import com.isomorphic.collections.DataTypeMap;
import com.isomorphic.datasource.BasicDataSource;
import com.isomorphic.datasource.DSRequest;
import com.isomorphic.datasource.DSResponse;
import com.isomorphic.datasource.DataSource;
import com.isomorphic.log.Logger;
import com.isomorphic.util.DataTools;
import jakarta.servlet.http.Cookie;
import jakarta.servlet.http.HttpServletRequest;
import java.util.Arrays;
import java.util.List;
import java.util.Map;

public class AIDataSource
extends BasicDataSource {
    private static Logger log = new Logger(AIDataSource.class.getName());

    static boolean isAIAuthorized(Logger log, DSRequest req) throws Exception {
        HttpServletRequest servletRequest = req.getHttpServletRequest();
        String sessionDSID = config.getString((Object)"secureSDK.sessionDataSourceID");
        String accountDSID = config.getString((Object)"secureSDK.accountDataSourceID");
        String sessionIdCookieName = config.getString((Object)"secureSDK.sessionIdCookieName");
        String adminNotesAIAuthKey = config.getString((Object)"secureSDK.adminNotesAIAuthKey");
        if (adminNotesAIAuthKey == null) {
            log.debug((Object)"No authorization required for access to AI");
            return true;
        }
        Boolean authorized = false;
        if (servletRequest != null && sessionIdCookieName != null) {
            for (Cookie cookie : servletRequest.getCookies()) {
                Map session;
                if (!sessionIdCookieName.equals(cookie.getName()) || (session = new DSRequest(sessionDSID, "fetch").setCriteria((Object)DataTools.buildMap((Object[])new Object[]{"sessionhash", cookie.getValue()})).execute().getRecord()) == null) continue;
                int userid = DataTools.getInt((Number)((Number)session.get("userid")));
                req.setParameter((Object)"_aiUserId", (Object)userid);
                req.setParameter((Object)"_aiSignedIn", (Object)true);
                if (userid == 1) {
                    authorized = true;
                    break;
                }
                Map account = new DSRequest(accountDSID, "fetch").setCriteria((Object)DataTools.buildMap((Object[])new Object[]{"forumsUserID", userid})).execute().getRecord();
                if (account == null) continue;
                String notes = account.getOrDefault("adminNotes", "");
                authorized = notes.contains(adminNotesAIAuthKey);
                break;
            }
        }
        if (!req.hasParameter((Object)"_aiUserId")) {
            req.setParameter((Object)"_aiSignedIn", (Object)false);
            req.setParameter((Object)"_aiUserId", (Object)AIDataSource.getUserIdFromRememberMe(servletRequest));
        }
        return authorized;
    }

    private static Integer getUserIdFromRememberMe(HttpServletRequest servletRequest) {
        String rememberMeCookieName = config.getString((Object)"secureSDK.rememberMeCookieName");
        if (servletRequest != null && rememberMeCookieName != null) {
            for (Cookie cookie : servletRequest.getCookies()) {
                if (!rememberMeCookieName.equals(cookie.getName())) continue;
                return Integer.parseInt(cookie.getValue());
            }
        }
        return null;
    }

    static DSResponse createAINotAuthorizedResponse(DSRequest req) throws Exception {
        String message = "AI authorization failed.  Please log into a SmartClient.com account that has access to AI samples.";
        DataTypeMap errorData = DataTools.buildMap((Object[])new Object[]{"message", message, "userid", req.getParameter((Object)"_aiUserId"), "signedIn", req.getParameter((Object)"_aiSignedIn")});
        return new DSResponse(req.getDataSource(), (Object)DataTools.buildMap((Object[])new Object[]{"error", errorData}), -1);
    }

    public Object authorizeChat(DSRequest req) throws Exception {
        return DataTools.buildMap((Object[])new Object[]{"authorized", AIDataSource.isAIAuthorized(log, req), "userid", req.getParameter((Object)"_aiUserId"), "signedIn", req.getParameter((Object)"_aiSignedIn")});
    }

    private DSResponse createChatCompletion(DSRequest req) throws Exception {
        if (!AIDataSource.isAIAuthorized(log, req)) {
            log.warn((Object)"SmartClient account authorization for serverAIDataSource failed");
            return AIDataSource.createAINotAuthorizedResponse(req);
        }
        log.info((Object)"SmartClient account authorization for serverAIDataSource succeeded");
        DataTypeMap record = new DataTypeMap(req.getValues());
        String aiPrompt = record.getString((Object)"text");
        DataTypeMap message = DataTools.buildMap((Object[])new Object[]{"role", "user", "content", aiPrompt});
        log.info((Object)("Raw prompt sent to AI: " + aiPrompt), (Object)"AI");
        DataTypeMap serverInputs = DataTools.buildMap((Object[])new Object[]{"model", record.get((Object)"model")});
        serverInputs.put("messages", Arrays.asList(message));
        Float temperature = record.getFloat((Object)"temperature");
        if (temperature != null) {
            serverInputs.put("temperature", temperature);
        }
        DSRequest restRequest = new DSRequest("openAIRestConnector", "fetch").setCriteria((Object)serverInputs);
        List restData = restRequest.execute().getDataList();
        DSResponse restResponse = new DSResponse((DataSource)this).setData((Object)restData);
        restResponse.setStatus(0);
        return restResponse;
    }

    public DSResponse executeFetch(DSRequest req) throws Exception {
        if ("createChatCompletion".equals(req.getOperationId())) {
            return this.createChatCompletion(req);
        }
        return super.executeFetch(req);
    }
}

