/*
 * Decompiled with CFR 0.152.
 */
package com.isomorphic.datasource;

import com.isomorphic.datasource.DSField;
import com.isomorphic.datasource.DataSource;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class SummaryFunctions {
    static final Map<String, SummaryFunction> registeredSummaryFunctions = new HashMap<String, SummaryFunction>();

    public static SummaryFunction getSummaryFunction(String functionName) {
        return registeredSummaryFunctions.get(functionName);
    }

    public static void registerSummaryFunction(String functionName, SummaryFunction function) {
        registeredSummaryFunctions.put(functionName, function);
    }

    public static Object applySummaryFunction(List detailRecords, DataSource ds, DSField field, String functionName) throws SummaryFunctionException {
        SummaryFunction function = SummaryFunctions.getSummaryFunction(functionName);
        if (function == null) {
            throw new SummaryFunctionException("applySummaryFunction() was called with unknown function '" + functionName + "'");
        }
        return function.apply(detailRecords, ds, field);
    }

    static {
        SummaryFunctions.registerSummaryFunction("sum", new sum());
        SummaryFunctions.registerSummaryFunction("min", new min());
        SummaryFunctions.registerSummaryFunction("first", new min());
        SummaryFunctions.registerSummaryFunction("max", new max());
        SummaryFunctions.registerSummaryFunction("avg", new avg());
        SummaryFunctions.registerSummaryFunction("count", new count());
        SummaryFunctions.registerSummaryFunction("concat", new concat());
        SummaryFunctions.registerSummaryFunction("array", new array());
    }

    public static interface SummaryFunction {
        public Object apply(List var1, DataSource var2, DSField var3) throws SummaryFunctionException;
    }

    public static class SummaryFunctionException
    extends Exception {
        public SummaryFunctionException(String msg) {
            super(msg);
        }
    }

    static class sum
    implements SummaryFunction {
        sum() {
        }

        @Override
        public Object apply(List detailRecords, DataSource ds, DSField field) throws SummaryFunctionException, ClassCastException {
            List records = ds.convertToRecordFormat(detailRecords);
            String fieldName = field.getName();
            String fieldType = ds.getSimpleBaseType(field.getType());
            boolean isInt = "integer".equals(fieldType);
            boolean isFloat2 = "float".equals(fieldType);
            if (!isInt && !isFloat2) {
                throw new SummaryFunctionException("SummaryFunction 'sum' was invoked for non-numeric field '" + fieldName + "'");
            }
            long intSum = 0L;
            double floatSum = 0.0;
            for (int i = 0; i < records.size(); ++i) {
                Number fieldValue = (Number)((Map)records.get(i)).get(fieldName);
                if (fieldValue == null) continue;
                if (isInt) {
                    intSum += fieldValue.longValue();
                    continue;
                }
                floatSum += fieldValue.doubleValue();
            }
            return isInt ? (double)intSum : floatSum;
        }
    }

    static class min
    implements SummaryFunction {
        min() {
        }

        @Override
        public Object apply(List detailRecords, DataSource ds, DSField field) throws SummaryFunctionException, ClassCastException {
            List records = ds.convertToRecordFormat(detailRecords);
            String fieldName = field.getName();
            String fieldType = ds.getSimpleBaseType(field.getType());
            Object min2 = null;
            for (int i = 0; i < records.size(); ++i) {
                Object fieldValue = ((Map)records.get(i)).get(fieldName);
                if (min2 == null) {
                    min2 = fieldValue;
                    continue;
                }
                if (((Comparable)fieldValue).compareTo(min2) >= 0) continue;
                min2 = fieldValue;
            }
            return min2;
        }
    }

    static class max
    implements SummaryFunction {
        max() {
        }

        @Override
        public Object apply(List detailRecords, DataSource ds, DSField field) throws SummaryFunctionException, ClassCastException {
            List records = ds.convertToRecordFormat(detailRecords);
            String fieldName = field.getName();
            String fieldType = ds.getSimpleBaseType(field.getType());
            Object max2 = null;
            for (int i = 0; i < records.size(); ++i) {
                Object fieldValue = ((Map)records.get(i)).get(fieldName);
                if (max2 == null) {
                    max2 = fieldValue;
                    continue;
                }
                if (((Comparable)fieldValue).compareTo(max2) <= 0) continue;
                max2 = fieldValue;
            }
            return max2;
        }
    }

    static class avg
    implements SummaryFunction {
        avg() {
        }

        @Override
        public Object apply(List detailRecords, DataSource ds, DSField field) throws SummaryFunctionException {
            List records = ds.convertToRecordFormat(detailRecords);
            String fieldName = field.getName();
            String fieldType = ds.getSimpleBaseType(field.getType());
            boolean isInt = "integer".equals(fieldType);
            boolean isFloat2 = "float".equals(fieldType);
            if (!isInt && !isFloat2) {
                throw new SummaryFunctionException("SummaryFunction 'avg' was invoked for non-numeric field '" + fieldName + "'");
            }
            long count2 = 0L;
            double sum2 = 0.0;
            for (int i = 0; i < records.size(); ++i) {
                Object fieldValueObj = ((Map)records.get(i)).get(fieldName);
                if (fieldValueObj == null || !(fieldValueObj instanceof Number)) continue;
                Number fieldValue = (Number)fieldValueObj;
                sum2 += fieldValue.doubleValue();
                ++count2;
            }
            return sum2 / (double)count2;
        }
    }

    static class count
    implements SummaryFunction {
        count() {
        }

        @Override
        public Object apply(List detailRecords, DataSource ds, DSField field) throws SummaryFunctionException {
            return detailRecords.size();
        }
    }

    static class concat
    implements SummaryFunction {
        concat() {
        }

        @Override
        public Object apply(List detailRecords, DataSource ds, DSField field) throws SummaryFunctionException {
            String joinStr;
            String suffix;
            List records = ds.convertToRecordFormat(detailRecords);
            String fieldName = field.getName();
            String prefix = (String)field.get("joinPrefix");
            if (prefix == null) {
                prefix = "";
            }
            if ((suffix = (String)field.get("joinSuffix")) == null) {
                suffix = "";
            }
            if ((joinStr = (String)field.get("joinString")) == null) {
                joinStr = ", ";
            }
            StringBuffer sb = new StringBuffer();
            if (prefix != null) {
                sb.append(prefix);
            }
            for (int i = 0; i < records.size(); ++i) {
                if (i > 0 && joinStr != null) {
                    sb.append(joinStr);
                }
                sb.append(((Map)records.get(i)).get(fieldName));
            }
            if (suffix != null) {
                sb.append(suffix);
            }
            return sb.toString();
        }
    }

    static class array
    implements SummaryFunction {
        array() {
        }

        @Override
        public Object apply(List detailRecords, DataSource ds, DSField field) throws SummaryFunctionException {
            List records = ds.convertToRecordFormat(detailRecords);
            ArrayList result = new ArrayList();
            String fieldName = field.getName();
            for (int i = 0; i < records.size(); ++i) {
                result.add(((Map)records.get(i)).get(fieldName));
            }
            return result;
        }
    }

    static class multiplier
    implements SummaryFunction {
        multiplier() {
        }

        @Override
        public Object apply(List detailRecords, DataSource ds, DSField field) throws SummaryFunctionException, ClassCastException {
            List records = ds.convertToRecordFormat(detailRecords);
            String fieldName = field.getName();
            String fieldType = ds.getSimpleBaseType(field.getType());
            boolean isInt = "integer".equals(fieldType);
            boolean isFloat2 = "float".equals(fieldType);
            if (!isInt && !isFloat2) {
                throw new SummaryFunctionException("SummaryFunction 'sum' was invoked for non-numeric field '" + fieldName + "'");
            }
            long intTotal = 0L;
            double floatTotal = 0.0;
            for (int i = 0; i < records.size(); ++i) {
                Number fieldValue = (Number)((Map)records.get(i)).get(fieldName);
                if (fieldValue == null) continue;
                if (isInt) {
                    intTotal *= fieldValue.longValue();
                    continue;
                }
                floatTotal *= fieldValue.doubleValue();
            }
            return isInt ? (double)intTotal : floatTotal;
        }
    }
}

