/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.jetty.jetty.servlet;

import java.io.IOException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.Servlet;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.UnavailableException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.openqa.jetty.jetty.servlet.ServletHandler;
import org.openqa.jetty.jetty.servlet.ServletHolder;
import org.openqa.jetty.log.LogFactory;
import org.openqa.jetty.util.URI;

public class Invoker
extends HttpServlet {
    private static Log log = LogFactory.getLog(Invoker.class);
    private ServletHandler _servletHandler;
    private Map.Entry _invokerEntry;
    private Map _parameters;
    private boolean _nonContextServlets;
    private boolean _verbose;

    public void init() {
        ServletContext config = this.getServletContext();
        this._servletHandler = ((ServletHandler.Context)config).getServletHandler();
        Enumeration e = this.getInitParameterNames();
        while (e.hasMoreElements()) {
            String param = (String)e.nextElement();
            String value = this.getInitParameter(param);
            String lvalue = value.toLowerCase();
            if ("nonContextServlets".equals(param)) {
                boolean bl = this._nonContextServlets = value.length() > 0 && lvalue.startsWith("t");
            }
            if ("verbose".equals(param)) {
                this._verbose = value.length() > 0 && lvalue.startsWith("t");
                continue;
            }
            if (this._parameters == null) {
                this._parameters = new HashMap();
            }
            this._parameters.put(param, value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void service(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String servlet;
        boolean included = false;
        String servlet_path = (String)request.getAttribute("javax.servlet.include.servlet_path");
        if (servlet_path == null) {
            servlet_path = request.getServletPath();
        } else {
            included = true;
        }
        String path_info = (String)request.getAttribute("javax.servlet.include.path_info");
        if (path_info == null) {
            path_info = request.getPathInfo();
        }
        if ((servlet = path_info) == null || servlet.length() <= 1) {
            response.sendError(404);
            return;
        }
        int i0 = servlet.charAt(0) == '/' ? 1 : 0;
        int i1 = servlet.indexOf(47, i0);
        ServletHolder holder = this._servletHandler.getServletHolder(servlet = i1 < 0 ? servlet.substring(i0) : servlet.substring(i0, i1));
        if (holder != null) {
            this._servletHandler.addServletHolder(holder);
            this._servletHandler.mapPathToServlet(String.valueOf(URI.addPaths(servlet_path, servlet)) + "/*", holder.getName());
        } else {
            if (servlet.endsWith(".class")) {
                servlet = servlet.substring(0, servlet.length() - 6);
            }
            if (servlet == null || servlet.length() == 0) {
                response.sendError(404);
                return;
            }
            ServletHandler servletHandler = this._servletHandler;
            synchronized (servletHandler) {
                String path;
                Map.Entry entry;
                if (this._invokerEntry == null) {
                    this._invokerEntry = this._servletHandler.getHolderEntry(servlet_path);
                }
                if ((entry = this._servletHandler.getHolderEntry(path = URI.addPaths(servlet_path, servlet))) != null && entry != this._invokerEntry) {
                    holder = (ServletHolder)entry.getValue();
                } else {
                    holder = new ServletHolder(this._servletHandler, servlet, servlet);
                    if (this._parameters != null) {
                        holder.putAll(this._parameters);
                    }
                    try {
                        holder.start();
                    }
                    catch (Exception e) {
                        log.debug((Object)"EXCEPTION ", (Throwable)e);
                        throw new UnavailableException(e.toString());
                    }
                    if (!this._nonContextServlets) {
                        Servlet s = holder.getServlet();
                        if (this._servletHandler.getClassLoader() != s.getClass().getClassLoader()) {
                            holder.stop();
                            log.warn((Object)("Dynamic servlet " + s + " not loaded from context " + request.getContextPath()));
                            throw new UnavailableException("Not in context");
                        }
                    }
                    if (this._verbose) {
                        this.log("Dynamic load '" + servlet + "' at " + path);
                    }
                    this._servletHandler.addServletHolder(holder);
                    this._servletHandler.mapPathToServlet(String.valueOf(path) + "/*", holder.getName());
                    this._servletHandler.mapPathToServlet(String.valueOf(path) + ".class/*", holder.getName());
                }
            }
        }
        if (holder != null) {
            holder.handle((ServletRequest)new Request(request, included, servlet, servlet_path, path_info), (ServletResponse)response);
        } else {
            response.sendError(404);
        }
    }

    class Request
    extends HttpServletRequestWrapper {
        String _servletPath;
        String _pathInfo;
        boolean _included;

        Request(HttpServletRequest request, boolean included, String name, String servletPath, String pathInfo) {
            super(request);
            this._included = included;
            this._servletPath = URI.addPaths(servletPath, name);
            this._pathInfo = pathInfo.substring(name.length() + 1);
            if (this._pathInfo.length() == 0) {
                this._pathInfo = null;
            }
        }

        public String getServletPath() {
            if (this._included) {
                return super.getServletPath();
            }
            return this._servletPath;
        }

        public String getPathInfo() {
            if (this._included) {
                return super.getPathInfo();
            }
            return this._pathInfo;
        }

        public Object getAttribute(String name) {
            if (this._included) {
                if (name.equals("javax.servlet.include.request_uri")) {
                    return URI.addPaths(URI.addPaths(this.getContextPath(), this._servletPath), this._pathInfo);
                }
                if (name.equals("javax.servlet.include.path_info")) {
                    return this._pathInfo;
                }
                if (name.equals("javax.servlet.include.servlet_path")) {
                    return this._servletPath;
                }
            }
            return super.getAttribute(name);
        }
    }
}

