/*
 * Smart GWT (GWT for SmartClient)
 * Copyright 2008 and beyond, Isomorphic Software, Inc.
 *
 * Smart GWT is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License version 3
 * as published by the Free Software Foundation.  Smart GWT is also
 * available under typical commercial license terms - see
 * http://smartclient.com/license
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 */
/* sgwtgen */
 
package com.smartgwt.client.ai;


import com.smartgwt.client.event.*;
import com.smartgwt.client.core.*;
import com.smartgwt.client.types.*;
import com.smartgwt.client.data.*;
import com.smartgwt.client.data.Record;
import com.smartgwt.client.data.events.*;
import com.smartgwt.client.browser.window.*;
import com.smartgwt.client.rpc.*;
import com.smartgwt.client.ai.*;
import com.smartgwt.client.callbacks.*;
import com.smartgwt.client.tools.*;
import com.smartgwt.client.bean.*;
import com.smartgwt.client.widgets.*;
import com.smartgwt.client.widgets.ai.*;
import com.smartgwt.client.widgets.events.*;
import com.smartgwt.client.widgets.form.*;
import com.smartgwt.client.widgets.form.validator.*;
import com.smartgwt.client.widgets.form.fields.*;
import com.smartgwt.client.widgets.tile.*;
import com.smartgwt.client.widgets.tile.events.*;
import com.smartgwt.client.widgets.grid.*;
import com.smartgwt.client.widgets.grid.events.*;
import com.smartgwt.client.widgets.chart.*;
import com.smartgwt.client.widgets.layout.*;
import com.smartgwt.client.widgets.layout.events.*;
import com.smartgwt.client.widgets.menu.*;
import com.smartgwt.client.widgets.tour.*;
import com.smartgwt.client.widgets.notify.*;
import com.smartgwt.client.widgets.rte.*;
import com.smartgwt.client.widgets.rte.events.*;
import com.smartgwt.client.widgets.ace.*;
import com.smartgwt.client.widgets.ace.events.*;
import com.smartgwt.client.widgets.tab.*;
import com.smartgwt.client.widgets.toolbar.*;
import com.smartgwt.client.widgets.tree.*;
import com.smartgwt.client.widgets.tree.events.*;
import com.smartgwt.client.widgets.tableview.*;
import com.smartgwt.client.widgets.viewer.*;
import com.smartgwt.client.widgets.calendar.*;
import com.smartgwt.client.widgets.calendar.events.*;
import com.smartgwt.client.widgets.cube.*;
import com.smartgwt.client.widgets.notify.*;
import com.smartgwt.client.widgets.drawing.*;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

import com.google.gwt.event.shared.*;
import com.google.gwt.dom.client.Element;
import com.google.gwt.user.client.ui.Widget;
import com.google.gwt.core.client.JavaScriptObject;

import com.smartgwt.client.util.*;
import com.smartgwt.client.util.events.*;
import com.smartgwt.client.util.workflow.*;
import com.smartgwt.client.util.workflow.Process; // required to override java.lang.Process
import com.smartgwt.client.util.tour.*;


/**
 * 
 */
@BeanFactory.FrameworkClass
public class MakeQueryDataQuestionStep extends DataQuestionStep {

    public static MakeQueryDataQuestionStep getOrCreateRef(JavaScriptObject jsObj) {
        if(jsObj == null) return null;
        return new MakeQueryDataQuestionStep(jsObj);
    }
        


    public MakeQueryDataQuestionStep(){
        
    }

    public MakeQueryDataQuestionStep(JavaScriptObject jsObj){
        
        setJavaScriptObject(jsObj);
    }



    // ********************* Properties / Attributes ***********************

    /**
     * The name of the data source to query.
     *
     * @param dataSourceName New dataSourceName value. Default value is *specified via AI*
     * @return {@link com.smartgwt.client.ai.MakeQueryDataQuestionStep MakeQueryDataQuestionStep} instance, for chaining setter calls
     * @see com.smartgwt.client.docs.GlobalId GlobalId 
     */
    public MakeQueryDataQuestionStep setDataSourceName(String dataSourceName) {
        return (MakeQueryDataQuestionStep)setAttribute("dataSourceName", dataSourceName);
    }

    /**
     * The name of the data source to query.
     *
     * @return Current dataSourceName value. Default value is *specified via AI*
     * @see com.smartgwt.client.docs.GlobalId GlobalId 
     */
    public String getDataSourceName()  {
        return getAttributeAsString("dataSourceName");
    }
    

    /**
     * A string containing a detailed description of the query to make against the specified data source.
     *
     * @param queryDescription New queryDescription value. Default value is *specified via AI*
     * @return {@link com.smartgwt.client.ai.MakeQueryDataQuestionStep MakeQueryDataQuestionStep} instance, for chaining setter calls
     */
    public MakeQueryDataQuestionStep setQueryDescription(String queryDescription) {
        return (MakeQueryDataQuestionStep)setAttribute("queryDescription", queryDescription);
    }

    /**
     * A string containing a detailed description of the query to make against the specified data source.
     *
     * @return Current queryDescription value. Default value is *specified via AI*
     */
    public String getQueryDescription()  {
        return getAttributeAsString("queryDescription");
    }
    

    /**
     * A string containing a detailed explanation of the purpose for making a query.
     *
     * @param queryPurpose New queryPurpose value. Default value is *specified via AI*
     * @return {@link com.smartgwt.client.ai.MakeQueryDataQuestionStep MakeQueryDataQuestionStep} instance, for chaining setter calls
     */
    public MakeQueryDataQuestionStep setQueryPurpose(String queryPurpose) {
        return (MakeQueryDataQuestionStep)setAttribute("queryPurpose", queryPurpose);
    }

    /**
     * A string containing a detailed explanation of the purpose for making a query.
     *
     * @return Current queryPurpose value. Default value is *specified via AI*
     */
    public String getQueryPurpose()  {
        return getAttributeAsString("queryPurpose");
    }
    

    /**
     * The value MAKE_QUERY.
     *
     * @param type New type value. Default value is null
     * @return {@link com.smartgwt.client.ai.MakeQueryDataQuestionStep MakeQueryDataQuestionStep} instance, for chaining setter calls
     */
    public MakeQueryDataQuestionStep setType(DataQuestionStepType type) {
        return (MakeQueryDataQuestionStep)setAttribute("type", type == null ? null : type.getValue());
    }

    /**
     * The value MAKE_QUERY.
     *
     * @return Current type value. Default value is null
     */
    public DataQuestionStepType getType()  {
        return EnumUtil.getEnum(DataQuestionStepType.values(), getAttribute("type"));
    }
    

    // ********************* Methods ***********************

    // ********************* Static Methods ***********************

    // ***********************************************************

}
