package com.smartgwt.client.widgets.calendar;

import java.util.Date;
import com.smartgwt.client.widgets.menu.MenuItem;

/**
 * Called to determine the hover HTML to be displayed when the user hovers over an eventCanvas in a calendar.
 */
public abstract class EventCanvasMenuCustomizer {
    
    private Calendar calendar;

    public void setCalendar(Calendar calendar) {
        this.calendar = calendar;
    }    

    /**
     * Returns the Calendar over which the hover occurred
     * @return Calendar over which the hover occurred
     */
    public Calendar getCalendar() {
        return this.calendar;
    }
    
	/**
     * If this method returns a value, it is expected to return an array of  {@link com.smartgwt.client.widgets.menu.MenuItem
     * items} applicable to the passed canvas and its event.  If an array  with valid entries is returned, the rollover {@link
     * com.smartgwt.client.widgets.calendar.Calendar#getEventCanvasContextButton context button} is shown for the passed
     * canvas.
     * @param canvas the canvas to get menu items for
     *
     * @return 
     */
    public abstract MenuItem[] getEventCanvasMenuItems(EventCanvas canvas);

}
