/*
 * Smart GWT (GWT for SmartClient)
 * Copyright 2008 and beyond, Isomorphic Software, Inc.
 *
 * Smart GWT is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License version 3
 * as published by the Free Software Foundation.  Smart GWT is also
 * available under typical commercial license terms - see
 * http://smartclient.com/license
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 */
/* sgwtgen */
 
package com.smartgwt.client.tools.stream;


import com.smartgwt.client.event.*;
import com.smartgwt.client.core.*;
import com.smartgwt.client.types.*;
import com.smartgwt.client.data.*;
import com.smartgwt.client.data.Record;
import com.smartgwt.client.data.events.*;
import com.smartgwt.client.browser.window.*;
import com.smartgwt.client.rpc.*;
import com.smartgwt.client.ai.*;
import com.smartgwt.client.callbacks.*;
import com.smartgwt.client.tools.*;
import com.smartgwt.client.bean.*;
import com.smartgwt.client.widgets.*;
import com.smartgwt.client.widgets.ai.*;
import com.smartgwt.client.widgets.events.*;
import com.smartgwt.client.widgets.form.*;
import com.smartgwt.client.widgets.form.validator.*;
import com.smartgwt.client.widgets.form.fields.*;
import com.smartgwt.client.widgets.tile.*;
import com.smartgwt.client.widgets.tile.events.*;
import com.smartgwt.client.widgets.grid.*;
import com.smartgwt.client.widgets.grid.events.*;
import com.smartgwt.client.widgets.chart.*;
import com.smartgwt.client.widgets.layout.*;
import com.smartgwt.client.widgets.layout.events.*;
import com.smartgwt.client.widgets.menu.*;
import com.smartgwt.client.widgets.tour.*;
import com.smartgwt.client.widgets.notify.*;
import com.smartgwt.client.widgets.rte.*;
import com.smartgwt.client.widgets.rte.events.*;
import com.smartgwt.client.widgets.ace.*;
import com.smartgwt.client.widgets.ace.events.*;
import com.smartgwt.client.widgets.tab.*;
import com.smartgwt.client.widgets.toolbar.*;
import com.smartgwt.client.widgets.tree.*;
import com.smartgwt.client.widgets.tree.events.*;
import com.smartgwt.client.widgets.tableview.*;
import com.smartgwt.client.widgets.viewer.*;
import com.smartgwt.client.widgets.calendar.*;
import com.smartgwt.client.widgets.calendar.events.*;
import com.smartgwt.client.widgets.cube.*;
import com.smartgwt.client.widgets.notify.*;
import com.smartgwt.client.widgets.drawing.*;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

import com.google.gwt.event.shared.*;
import com.google.gwt.dom.client.Element;
import com.google.gwt.user.client.ui.Widget;
import com.google.gwt.core.client.JavaScriptObject;

import com.smartgwt.client.util.*;
import com.smartgwt.client.util.events.*;
import com.smartgwt.client.util.workflow.*;
import com.smartgwt.client.util.workflow.Process; // required to override java.lang.Process
import com.smartgwt.client.util.tour.*;


/**
* <b><i><span style='color:red'>Note: this is currently an experimental feature and not
* covered by normal support guarantees. See {@link com.smartgwt.client.docs.Experimental
* Experimental Features} for more information.</span></i></b><br><br>
 * A JavaScript object representing the state of a live {@link com.smartgwt.client.tools.stream.EventStream} instance,
 * including all captured events retained by the stream.  When {@link com.smartgwt.client.tools.stream.EventStream#end
 * EventStream.end()} is called to complete capturing, a <code>EventStreamData</code> object is returned. <P> Note that
 * <code>EventStreamData</code> is essentially JSON, except that dates remain JavaScript {@link
 * com.smartgwt.client.util.Date}s, rather than being converted to string format.  This ensures that if you {@link
 * com.smartgwt.client.util.JSON#encode serialize} the data and then {@link com.smartgwt.client.util.JSON#decode
 * deserialize} it, dates round trip properly and time zone information is not lost.
 * @see com.smartgwt.client.tools.stream.EventStreamEvent
 * @see com.smartgwt.client.docs.Experimental Experimental Features
 */
@BeanFactory.FrameworkClass
public class EventStreamData extends DataClass {

    public static EventStreamData getOrCreateRef(JavaScriptObject jsObj) {
        if(jsObj == null) return null;
        return new EventStreamData(jsObj);
    }
        


    public EventStreamData(){
        
    }

    public EventStreamData(JavaScriptObject jsObj){
        
        setJavaScriptObject(jsObj);
    }



    // ********************* Properties / Attributes ***********************

    /**
     * A string representation of the <code>DateTime</code> when capturing for the stream was {@link
     * com.smartgwt.client.tools.stream.EventStream#end completed}.
     *
     * @return Current endTime value. Default value is null
     * @see com.smartgwt.client.tools.stream.EventStreamData#getStartTime
     */
    public String getEndTime()  {
        return getAttributeAsString("endTime");
    }
    

    /**
     * An array of the captured {@link com.smartgwt.client.tools.stream.EventStreamEvent event records} retained by the stream.
     * Only the last {@link com.smartgwt.client.tools.stream.EventStream#getMaxSize EventStream.maxSize} event records will be
     * present, though more events may have been captured since capturing {@link
     * com.smartgwt.client.tools.stream.EventStream#start started}. <P> Note that {@link
     * com.smartgwt.client.tools.stream.EventStreamData} reported via an  error callback will only contain events that have
     * occurred after the last callback, for efficiency.
     *
     * @return Current events value. Default value is null
     * @see com.smartgwt.client.tools.stream.EventStreamData#getNEvents
     */
    public EventStreamEvent[] getEvents()  {
        return com.smartgwt.client.util.ConvertTo.arrayOfEventStreamEvent(getAttributeAsJavaScriptObject("events"));
    }
    

    /**
     * The total number of events captured by the stream since capturing {@link
     * com.smartgwt.client.tools.stream.EventStream#start started}.  This value may exceed the length of the reported {@link
     * com.smartgwt.client.tools.stream.EventStreamData#getEvents events}, which only contains the most recent events.
     *
     * @return Current nEvents value. Default value is null
     */
    public Integer getNEvents()  {
        return getAttributeAsInt("nEvents");
    }
    

    /**
     * A string representation of the <code>DateTime</code> when capturing for the stream {@link
     * com.smartgwt.client.tools.stream.EventStream#start started}.
     *
     * @return Current startTime value. Default value is null
     * @see com.smartgwt.client.tools.stream.EventStreamData#getEndTime
     */
    public String getStartTime()  {
        return getAttributeAsString("startTime");
    }
    

    // ********************* Methods ***********************

    // ********************* Static Methods ***********************

    // ***********************************************************

}
