package com.smartgwt.sample.showcase.client.ai;

import com.smartgwt.client.ai.AIHoverRequest;
import com.smartgwt.client.data.AdvancedCriteria;
import com.smartgwt.client.data.Criterion;
import com.smartgwt.client.data.DataSource;
import com.smartgwt.client.types.FetchMode;
import com.smartgwt.client.types.OperatorId;
import com.smartgwt.client.widgets.Canvas;
import com.smartgwt.client.widgets.grid.ListGrid;
import com.smartgwt.client.widgets.grid.ListGridField;
import com.smartgwt.client.widgets.grid.events.CellHoverEvent;
import com.smartgwt.client.widgets.grid.events.CellHoverHandler;
import com.smartgwt.sample.showcase.client.PanelFactory;
import com.smartgwt.sample.showcase.client.ShowcasePanel;

public class SummarizeOnHoverSample extends ShowcasePanel {

    private static final String DESCRIPTION =
            "AI can be used to generate hovers for cells in a ListGrid. This can be " +
            "used to display summary information to the user or related, generally-" +
            "known external information." +
            "<p>" +
            "In the example below, hover the mouse pointer over the \"Country\" values " +
            "to see an AI-generated hover for the prompt \"a 2-4 sentence demographic " +
            "and economic description of the country\".";

    public static class Factory implements PanelFactory {
        @Override
        public String getID() {
            return "aiSummarizeOnHover";
        }

        @Override
        public String getDescription() {
            return DESCRIPTION;
        }

        @Override
        public ShowcasePanel create() {
            return new SummarizeOnHoverSample();
        }
    }

    @Override
    protected boolean isTopIntro() {
        return true;
    }

    @Override
    protected String getIntro() {
        return DESCRIPTION;
    }

    @Override
    public Canvas getViewPanel() {
        final ListGrid grid = new ListGrid();
        grid.setWidth100();
        grid.setHeight100();
        grid.setDataSource(DataSource.get("worldDS"));
        grid.setDataFetchMode(FetchMode.LOCAL);
        grid.setAutoFetchData(true);
        grid.setImplicitCriteria(new AdvancedCriteria(OperatorId.AND, new Criterion[] {
            new Criterion("continent", OperatorId.EQUALS, "Asia"),
            new Criterion("population", OperatorId.GREATER_THAN, 25_000_000)
        }));

        grid.setCanHover(true);
        grid.setShowHover(true);
        grid.setShowClippedHeaderTitlesOnHover(true);
        grid.addCellHoverHandler(new CellHoverHandler() {
            @Override
            public void onCellHover(CellHoverEvent event) {
                final int rowNum = event.getRowNum(),
                          colNum = event.getColNum();

                // Show a hover if the value is clipped or we've set an aiHoverRequest on the field.

                if (grid.cellValueIsClipped(rowNum, colNum)) {
                    return;
                }

                final ListGridField field = grid.getField(colNum);
                if (field != null && field.getAIHoverRequest() != null) {
                    return;
                }

                event.cancel();
            }
        });

        grid.setFields(new ListGridField[] {
            new ListGridField("countryCode", 70),
            new ListGridField("countryName", 235) {{
                setShowHover(true);

                final AIHoverRequest aiHoverRequest = new AIHoverRequest();
                aiHoverRequest.setPrompt("a 2-4 sentence demographic and economic description of the country");
                setAIHoverRequest(aiHoverRequest);
            }},
            new ListGridField("independence", 125),
            new ListGridField("population", 125),
            new ListGridField("gdp", 125)
        });

        return grid;
    }
}
