/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.sql.results.graph.embeddable.internal;

import org.checkerframework.checker.nullness.qual.Nullable;
import org.hibernate.engine.spi.CollectionKey;
import org.hibernate.engine.spi.EntityHolder;
import org.hibernate.metamodel.mapping.EntityMappingType;
import org.hibernate.query.spi.QueryOptions;
import org.hibernate.query.spi.QueryParameterBindings;
import org.hibernate.resource.jdbc.spi.LogicalConnectionImplementor;
import org.hibernate.spi.NavigablePath;
import org.hibernate.sql.exec.internal.BaseExecutionContext;
import org.hibernate.sql.exec.spi.Callback;
import org.hibernate.sql.results.graph.Initializer;
import org.hibernate.sql.results.graph.embeddable.internal.AggregateEmbeddableInitializer;
import org.hibernate.sql.results.graph.entity.EntityFetch;
import org.hibernate.sql.results.jdbc.spi.JdbcValuesSourceProcessingState;
import org.hibernate.sql.results.jdbc.spi.RowProcessingState;
import org.hibernate.sql.results.spi.RowReader;

public class NestedRowProcessingState
extends BaseExecutionContext
implements RowProcessingState {
    private final AggregateEmbeddableInitializer aggregateEmbeddableInitializer;
    final RowProcessingState processingState;

    public NestedRowProcessingState(AggregateEmbeddableInitializer aggregateEmbeddableInitializer, RowProcessingState processingState) {
        super(processingState.getSession());
        this.aggregateEmbeddableInitializer = aggregateEmbeddableInitializer;
        this.processingState = processingState;
    }

    public static NestedRowProcessingState wrap(AggregateEmbeddableInitializer aggregateEmbeddableInitializer, RowProcessingState processingState) {
        if (processingState instanceof NestedRowProcessingState) {
            return new NestedRowProcessingState(aggregateEmbeddableInitializer, ((NestedRowProcessingState)processingState).processingState);
        }
        return new NestedRowProcessingState(aggregateEmbeddableInitializer, processingState);
    }

    @Override
    public Object getJdbcValue(int position) {
        Object[] jdbcValue = this.aggregateEmbeddableInitializer.getJdbcValues(this.processingState);
        return jdbcValue == null ? null : jdbcValue[position];
    }

    @Override
    public JdbcValuesSourceProcessingState getJdbcValuesSourceProcessingState() {
        return this.processingState.getJdbcValuesSourceProcessingState();
    }

    @Override
    public RowReader<?> getRowReader() {
        return this.processingState.getRowReader();
    }

    @Override
    public void registerNonExists(EntityFetch fetch) {
        this.processingState.registerNonExists(fetch);
    }

    @Override
    public boolean isQueryCacheHit() {
        return this.processingState.isQueryCacheHit();
    }

    @Override
    public void finishRowProcessing() {
        this.processingState.finishRowProcessing();
    }

    @Override
    public void finishRowProcessing(boolean wasAdded) {
        this.processingState.finishRowProcessing(wasAdded);
    }

    @Override
    public Initializer resolveInitializer(@Nullable NavigablePath path) {
        return this.processingState.resolveInitializer(path);
    }

    @Override
    public QueryOptions getQueryOptions() {
        return this.processingState.getQueryOptions();
    }

    @Override
    public QueryParameterBindings getQueryParameterBindings() {
        return this.processingState.getQueryParameterBindings();
    }

    @Override
    public boolean isScrollResult() {
        return this.processingState.isScrollResult();
    }

    @Override
    public Callback getCallback() {
        return this.processingState.getCallback();
    }

    @Override
    public boolean hasCallbackActions() {
        return this.processingState.hasCallbackActions();
    }

    @Override
    public CollectionKey getCollectionKey() {
        return this.processingState.getCollectionKey();
    }

    @Override
    public Object getEntityInstance() {
        return this.processingState.getEntityInstance();
    }

    @Override
    public Object getEntityId() {
        return this.processingState.getEntityId();
    }

    @Override
    public String getEntityUniqueKeyAttributePath() {
        return this.processingState.getEntityUniqueKeyAttributePath();
    }

    @Override
    public Object getEntityUniqueKey() {
        return this.processingState.getEntityUniqueKey();
    }

    @Override
    public EntityMappingType getRootEntityDescriptor() {
        return this.processingState.getRootEntityDescriptor();
    }

    @Override
    public void registerLoadingEntityHolder(EntityHolder holder) {
        this.processingState.registerLoadingEntityHolder(holder);
    }

    @Override
    public void afterStatement(LogicalConnectionImplementor logicalConnection) {
        this.processingState.afterStatement(logicalConnection);
    }

    @Override
    public boolean hasQueryExecutionToBeAddedToStatistics() {
        return this.processingState.hasQueryExecutionToBeAddedToStatistics();
    }
}

