/*

  SmartClient Ajax RIA system
  Version v14.0p_2026-02-24/LGPL Deployment (2026-02-24)

  Copyright 2000 and beyond Isomorphic Software, Inc. All rights reserved.
  "SmartClient" is a trademark of Isomorphic Software, Inc.

  LICENSE NOTICE
     INSTALLATION OR USE OF THIS SOFTWARE INDICATES YOUR ACCEPTANCE OF
     ISOMORPHIC SOFTWARE LICENSE TERMS. If you have received this file
     without an accompanying Isomorphic Software license file, please
     contact licensing@isomorphic.com for details. Unauthorized copying and
     use of this software is a violation of international copyright law.

  DEVELOPMENT ONLY - DO NOT DEPLOY
     This software is provided for evaluation, training, and development
     purposes only. It may include supplementary components that are not
     licensed for deployment. The separate DEPLOY package for this release
     contains SmartClient components that are licensed for deployment.

  PROPRIETARY & PROTECTED MATERIAL
     This software contains proprietary materials that are protected by
     contract and intellectual property law. You are expressly prohibited
     from attempting to reverse engineer this software or modify this
     software for human readability.

  CONTACT ISOMORPHIC
     For more information regarding license rights and restrictions, or to
     report possible license violations, please contact Isomorphic Software
     by email (licensing@isomorphic.com) or web (www.isomorphic.com).

*/
//> @class CancellationController
// Provides a mechanism for canceling asynchronous operations.
// @treeLocation Client Reference/System
// @visibility external
//<
isc.defineClass("CancellationController", null, null, true);

isc.CancellationController.addClassProperties({
    

    createJointController : function (cancellationControllers) {
        var jointCC = isc.CancellationController.create({
            _isJointCC: true
            
        });

        // First find the first non-`null` CC, and also look for any that are already canceled.
        var firstCancellationController,
            firstCancellationControllerIndex;
        for (var i = 0; i < cancellationControllers.length; ++i) {
            var cancellationController = cancellationControllers[i];
            if (!cancellationController) continue;
            if (!firstCancellationController) {
                firstCancellationController = cancellationController;
                firstCancellationControllerIndex = i;
            }
            if (cancellationController.canceled) {
                jointCC.cancel(cancellationController.cancellationReason, cancellationController.cancellationInitiator);
                break;
            }
        }

        if (!firstCancellationController) return jointCC;

        for (var i = firstCancellationControllerIndex; i < cancellationControllers.length; ++i) {
            var cancellationController = cancellationControllers[i];
            if (!cancellationController) continue;

            if (!jointCC.canceled) {
                var subCCs = cancellationController._subCCs;
                if (!subCCs) subCCs = cancellationController._subCCs = [];
                subCCs.push(jointCC);
            } 
        }

        return jointCC;
    },

    //> @classMethod CancellationController.getAncestorGenerationAdjective()
    // Gets the adjective describing the <code>n</code>'th generation of ancestors.<br>
    // For example: getAncestorGenerationAdjective(2) could return "grandparent" in English locales.
    // @param n (Integer) The generation of ancestors to obtain the adjective for.
    // @return (HTMLString) The adjective describing the <code>n</code>'th generation of ancestors.
    // @group i18nMessages
    //<
    getAncestorGenerationAdjective : function (n) {
        switch (n) {
            case 1: return "parent";
            case 2: return "grandparent";
            case 3: return "great-grandparent";
            default:
                return String.formatAsOrdinalNumber(n - 2) + "-great grandparent";
        }
    },

    //> @classAttr CancellationController.ancestorCanceledReasonGeneric (HTMLString : "The ${ancestorGenerationAdjective} operation was canceled." : RW)
    // Cancellation reason that is used when a <code>CancellationController</code> created by
    // +link{CancellationController.createSubController()} is canceled by its parent,
    // grandparent, great-grandparent, etc. <code>CancellationController</code> being canceled,
    // and no specific reason was provided for why the ancestor <code>CancellationController</code>
    // was canceled.<br>
    // For example: "The great-grandparent operation was canceled."
    // @group i18nMessages
    // @visibility external
    //<
    ancestorCanceledReasonGeneric: "The ${ancestorGenerationAdjective} operation was canceled.",

    //> @classAttr CancellationController.ancestorCanceledReason (HTMLString : "The ${ancestorGenerationAdjective} operation was canceled: ${ancestorCancellationReason}" : RW)
    // Cancellation reason that is used when a <code>CancellationController</code> created by
    // +link{CancellationController.createSubController()} is canceled by its parent,
    // grandparent, great-grandparent, etc. <code>CancellationController</code> being canceled,
    // and a reason for the ancestor <code>CancellationController</code> being canceled is provided.<br>
    // For example: "The great-grandparent operation was canceled: The user requested cancellation."
    // @group i18nMessages
    // @visibility external
    //<
    ancestorCanceledReason: "The ${ancestorGenerationAdjective} operation was canceled: ${ancestorCancellationReason}",

    //> @classAttr CancellationController.componentDataSourceWasChangedReason (HTMLString : "Component ${componentID}'s dataSource was changed." : RW)
    // Cancellation reason string that is used when the +link{DataBoundComponent.dataSource, dataSource}
    // for a +link{DataBoundComponent} is changed while an asynchronous operation that depends
    // on the component's old <code>dataSource</code> was in progress.
    // @group i18nMessages
    // @visibility external
    //<
    componentDataSourceWasChangedReason: "Component ${componentID}'s dataSource was changed.",

    //> @classAttr CancellationController.componentFieldsWereChangedReason (HTMLString : "Fields were added or removed from component ${componentID}." : RW)
    // Cancellation reason string that is used when the set of fields
    // for a +link{DataBoundComponent} are changed while an asynchronous operation that depends
    // on the component's old set of fields was in progress.
    // @group i18nMessages
    // @visibility external
    //<
    componentFieldsWereChangedReason: "Fields were added or removed from component ${componentID}."
});

isc.CancellationController.addProperties({

    //> @attr CancellationController.canceled (Boolean : false : R)
    // Whether +link{cancel()} has been called.
    // @visibility external
    //<
    canceled: false,

    //> @attr CancellationController.cancellationReason (HTMLString : null : R)
    // The reason, if any, passed to the first call to +link{cancel()}.
    // @visibility external
    //<
    //cancellationReason: null,

    
    //cancellationInitiator: null,

    

    destroy : function () {
        if (!this.canceled) {
            var reason = "The CancellationController";
            
            this.cancel(reason + " was destroyed.");
        }
        this.Super("destroy", arguments);
        this.destroyed = true;
    },

    asCanceledResult : function (additionalProperties) {
        if (this.canceled) {
            var canceledResult = isc.addPropertiesWithAssign({}, additionalProperties);
            canceledResult.type = "canceled";
            canceledResult.cancellationReason = this.cancellationReason;
            canceledResult.cancellationInitiator = this.cancellationInitiator;
            
            return canceledResult;
        }
    },

    _getAbortSignal : function () {
        if (window.AbortController) {
            let abortController = this._abortController;
            if (!abortController) abortController = this._abortController = new AbortController;
            if (this.canceled) abortController.abort(this.cancellationReason);
            return abortController.signal;
        }
    },

    _getGeneration : function () {
        return this._generation || 0;
    },

    //> @method CancellationController.createSubController()
    // Creates a new +link{CancellationController} which is canceled whenever this
    // <code>CancellationController</code> is canceled.
    // <p>
    // Note that the sub-<code>CancellationController</code> may be independently canceled
    // before this parent <code>CancellationController</code> is canceled.
    // @return (CancellationController) a new +link{CancellationController} that is canceled
    // whenever this <code>CancellationController</code> is canceled.
    // @visibility external
    //<
    createSubController : function (sameGeneration) {
        var generation = this._getGeneration(),
            subCC = isc.CancellationController.create({
                _generation: sameGeneration ? generation : generation + 1
                
            });
        if (this.canceled) {
            subCC.cancel(this.cancellationReason, this.cancellationInitiator, generation);
            
        } else {
            var subCCs = this._subCCs;
            if (!subCCs) subCCs = this._subCCs = [];
            subCCs.push(subCC);
        }
        return subCC;
    },

    //> @method CancellationController.cancel()
    // Requests cancellation of all asynchronous operations that are polling +link{canceled}
    // or +link{Class.observe(), observing} this method. Also cancels any
    // +link{createSubController(), sub-<code>CancellationController</code>}s of this
    // <code>CancellationController</code> that are not already canceled.
    // <p>
    // +link{cancellationReason, this.cancellationReason} is set to the provided <code>reason</code>
    // only on the first call to cancel().
    // <p>
    // For observers of this method, the recommended practice is to capture the <code>returnVal</code>
    // and only perform the cancellation steps if the <code>returnVal</code> was <code>true</code>.
    // This is because it could happen that cancel() is called a second time before the observers
    // finish.
    // @param [reason] (HTMLString) A reason for cancellation.
    
    // @return (Boolean) <code>true</code> if this was the first call to cancel(); <code>false</code>
    // otherwise.
    // @visibility external
    //<
    
    cancel : function (reason, initiator, _canceledGeneration) {
        //!DONTOBFUSCATE  (obfuscation breaks observation)
        
        if (this.canceled) return false;

        this.canceled = true;
        this.cancellationInitiator = initiator;
        if (_canceledGeneration != null && this._getGeneration() != _canceledGeneration) {
            var messageString = isc.CancellationController[reason ? "ancestorCanceledReason" : "ancestorCanceledReasonGeneric"],
                generation = this._generation - _canceledGeneration;
            this.cancellationReason = messageString.evalDynamicString(this, {
                generation: generation,
                ancestorGenerationAdjective: isc.CancellationController.getAncestorGenerationAdjective(generation),
                ancestorCancellationReason: reason
            });
        } else {
            this.cancellationReason = reason;
        }

        if (this._abortController) this._abortController.abort(this.cancellationReason);

        var subCCs = this._subCCs;
        if (subCCs) {
            _canceledGeneration = _canceledGeneration != null ? _canceledGeneration : this._getGeneration();
            // Cancel subcontrollers in LIFO order.
            for (var ri = subCCs.length; ri > 0; --ri) {
                var subCC = subCCs[ri - 1];
                if (!subCC.canceled) {
                    if (subCC._isJointCC) subCC.cancel(this.cancellationReason, initiator);
                    else subCC.cancel(reason, initiator, _canceledGeneration);
                }
                
            }
            
            delete this._subCCs;
        }

        

        return true;
    }
});
