/*
 * Decompiled with CFR 0.152.
 */
package com.isomorphic.webdriver;

import com.isomorphic.webdriver.SmartClientWebDriver;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.firefox.FirefoxBinary;
import org.openqa.selenium.firefox.FirefoxDriver;
import org.openqa.selenium.firefox.FirefoxOptions;
import org.openqa.selenium.firefox.FirefoxProfile;
import org.openqa.selenium.remote.DesiredCapabilities;
import org.openqa.selenium.remote.RemoteWebDriver;

public class SmartClientFirefoxDriver
extends SmartClientWebDriver {
    private boolean legacyMode;

    @Override
    protected boolean isLegacy() {
        return this.legacyMode;
    }

    private static FirefoxOptions augmentOptions(FirefoxOptions options, Capabilities capabilities, FirefoxProfile profile, FirefoxBinary binary) {
        if (options == null) {
            options = new FirefoxOptions();
        }
        if (profile != null) {
            options.setProfile(profile);
        }
        if (binary != null) {
            options.setBinary(binary);
        }
        return options.merge(SmartClientFirefoxDriver.augmentCapabilities(capabilities));
    }

    private static Capabilities augmentCapabilities(Capabilities capabilities) {
        if (capabilities == null) {
            capabilities = new DesiredCapabilities();
        }
        ((DesiredCapabilities)capabilities).setCapability("nativeEvents", true);
        return capabilities;
    }

    public SmartClientFirefoxDriver() {
        this((FirefoxOptions)null);
    }

    @Deprecated
    public SmartClientFirefoxDriver(Capabilities capabilities) {
        this(SmartClientFirefoxDriver.augmentOptions(null, capabilities, null, null));
    }

    @Deprecated
    public SmartClientFirefoxDriver(FirefoxProfile profile) {
        this(SmartClientFirefoxDriver.augmentOptions(null, null, profile, null));
    }

    @Deprecated
    public SmartClientFirefoxDriver(FirefoxBinary binary) {
        this(SmartClientFirefoxDriver.augmentOptions(null, null, null, binary));
    }

    @Deprecated
    public SmartClientFirefoxDriver(FirefoxBinary binary, FirefoxProfile profile) {
        this(SmartClientFirefoxDriver.augmentOptions(null, null, profile, binary));
    }

    public SmartClientFirefoxDriver(FirefoxOptions options) {
        options = SmartClientFirefoxDriver.augmentOptions(options, null, null, null);
        this.legacyMode = options.isLegacy();
        this.setDriver((RemoteWebDriver)new FirefoxDriver(options));
    }

    public SmartClientFirefoxDriver(boolean legacyMode) {
        super((RemoteWebDriver)new FirefoxDriver(SmartClientFirefoxDriver.augmentOptions(new FirefoxOptions().setLegacy(legacyMode), null, null, null)));
    }
}

