/*
 * Smart GWT (GWT for SmartClient)
 * Copyright 2008 and beyond, Isomorphic Software, Inc.
 *
 * Smart GWT is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License version 3
 * as published by the Free Software Foundation.  Smart GWT is also
 * available under typical commercial license terms - see
 * http://smartclient.com/license
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 */
/* sgwtgen */
 
package com.smartgwt.client.widgets.form.fields;


import com.smartgwt.client.event.*;
import com.smartgwt.client.core.*;
import com.smartgwt.client.types.*;
import com.smartgwt.client.data.*;
import com.smartgwt.client.data.Record;
import com.smartgwt.client.data.events.*;
import com.smartgwt.client.browser.window.*;
import com.smartgwt.client.rpc.*;
import com.smartgwt.client.ai.*;
import com.smartgwt.client.callbacks.*;
import com.smartgwt.client.tools.*;
import com.smartgwt.client.bean.*;
import com.smartgwt.client.widgets.*;
import com.smartgwt.client.widgets.ai.*;
import com.smartgwt.client.widgets.events.*;
import com.smartgwt.client.widgets.form.*;
import com.smartgwt.client.widgets.form.validator.*;
import com.smartgwt.client.widgets.form.fields.*;
import com.smartgwt.client.widgets.tile.*;
import com.smartgwt.client.widgets.tile.events.*;
import com.smartgwt.client.widgets.grid.*;
import com.smartgwt.client.widgets.grid.events.*;
import com.smartgwt.client.widgets.chart.*;
import com.smartgwt.client.widgets.layout.*;
import com.smartgwt.client.widgets.layout.events.*;
import com.smartgwt.client.widgets.menu.*;
import com.smartgwt.client.widgets.tour.*;
import com.smartgwt.client.widgets.notify.*;
import com.smartgwt.client.widgets.rte.*;
import com.smartgwt.client.widgets.rte.events.*;
import com.smartgwt.client.widgets.ace.*;
import com.smartgwt.client.widgets.ace.events.*;
import com.smartgwt.client.widgets.tab.*;
import com.smartgwt.client.widgets.toolbar.*;
import com.smartgwt.client.widgets.tree.*;
import com.smartgwt.client.widgets.tree.events.*;
import com.smartgwt.client.widgets.tableview.*;
import com.smartgwt.client.widgets.viewer.*;
import com.smartgwt.client.widgets.calendar.*;
import com.smartgwt.client.widgets.calendar.events.*;
import com.smartgwt.client.widgets.cube.*;
import com.smartgwt.client.widgets.notify.*;
import com.smartgwt.client.widgets.drawing.*;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

import com.google.gwt.event.shared.*;
import com.google.gwt.dom.client.Element;
import com.google.gwt.user.client.ui.Widget;
import com.google.gwt.core.client.JavaScriptObject;

import com.smartgwt.client.util.*;
import com.smartgwt.client.util.events.*;
import com.smartgwt.client.util.workflow.*;
import com.smartgwt.client.util.workflow.Process; // required to override java.lang.Process
import com.smartgwt.client.util.tour.*;


/**
 * {@link com.smartgwt.client.widgets.grid.Shuttle}-based form item for choosing values from a list of options. <P> Options
 * for the Shuttle should be derived from an {@link com.smartgwt.client.widgets.form.fields.FormItem#getOptionDataSource
 * optionDataSource}.
 */
@BeanFactory.FrameworkClass
public class ShuttleItem extends CanvasItem {

    public static ShuttleItem getOrCreateRef(JavaScriptObject jsObj) {
        if (jsObj == null) return null;

        final RefDataClass existingObj = RefDataClass.getRef(jsObj);

        if (existingObj instanceof ShuttleItem) {
            existingObj.setJsObj(jsObj);
            return (ShuttleItem)existingObj;
        } else

        {
            return new ShuttleItem(jsObj);
        }
    }
        


    /**
     * Changes the defaults for Canvas AutoChildren named <code>autoChildName</code>.
     *
     * @param autoChildName name of an AutoChild to customize the defaults for.
     * @param defaults Canvas defaults to apply. These defaults override any existing properties
     * without destroying or wiping out non-overridden properties.  For usage tips on this
     * param, see {@link com.smartgwt.client.docs.SGWTProperties}.
     * @see com.smartgwt.client.docs.AutoChildUsage
     */
    public static native void changeAutoChildDefaults(String autoChildName, Canvas defaults) /*-{
        if (defaults.@com.smartgwt.client.widgets.BaseWidget::isCreated()()) {
            @com.smartgwt.client.util.ConfigUtil::warnOfPreConfigInstantiation(Ljava/lang/Class;Ljava/lang/String;Ljava/lang/String;)(ShuttleItem.@java.lang.Object::getClass()(), "changeAutoChildDefaults", "Canvas");
        }
        defaults.@com.smartgwt.client.widgets.BaseWidget::setConfigOnly(Z)(true);
        var cleanDefaultsJS = @com.smartgwt.client.util.JSOHelper::cleanProperties(Lcom/google/gwt/core/client/JavaScriptObject;Z)(defaults.@com.smartgwt.client.widgets.BaseWidget::getConfig()(), true);
        $wnd.isc.ShuttleItem.changeDefaults(autoChildName + "Defaults", cleanDefaultsJS);
    }-*/;

    /**
     * Changes the defaults for FormItem AutoChildren named <code>autoChildName</code>.
     *
     * @param autoChildName name of an AutoChild to customize the defaults for.
     * @param defaults FormItem defaults to apply. These defaults override any existing properties
     * without destroying or wiping out non-overridden properties.  For usage tips on this
     * param, see {@link com.smartgwt.client.docs.SGWTProperties}.
     * @see com.smartgwt.client.docs.AutoChildUsage
     */
    public static native void changeAutoChildDefaults(String autoChildName, FormItem defaults) /*-{
        if (defaults.@com.smartgwt.client.widgets.form.fields.FormItem::isCreated()()) {
            @com.smartgwt.client.util.ConfigUtil::warnOfPreConfigInstantiation(Ljava/lang/Class;Ljava/lang/String;Ljava/lang/String;)(ShuttleItem.@java.lang.Object::getClass()(), "changeAutoChildDefaults", "FormItem");
        }
        defaults.@com.smartgwt.client.widgets.form.fields.FormItem::setConfigOnly(Z)(true);
    	var cleanDefaultsJS = defaults.@com.smartgwt.client.widgets.form.fields.FormItem::getEditorTypeConfig()();
        $wnd.isc.ShuttleItem.changeDefaults(autoChildName + "Defaults", cleanDefaultsJS);
    }-*/;

    public static native void changePickerIconDefaults(FormItemIcon defaults) /*-{
        $wnd.isc.ShuttleItem.changeDefaults("pickerIconDefaults", defaults.@com.smartgwt.client.core.DataClass::getJsObj()());
    }-*/;

    public ShuttleItem(){
        setAttribute("editorType", "ShuttleItem");
    }

    public ShuttleItem(JavaScriptObject jsObj){
        super(jsObj);
    }


    public ShuttleItem(String name) {
        setName(name);
                setAttribute("editorType", "ShuttleItem");
    }



    // ********************* Properties / Attributes ***********************

    /**
     * If set, this item will display a value from another field to the user instead of showing the underlying data value for
     * the {@link com.smartgwt.client.widgets.form.fields.FormItem#getName field name}. <P> This property is used in two ways:
     * <P> The item will display the displayField value from the  {@link com.smartgwt.client.widgets.form.DynamicForm#getValues
     * record currently being edited} if  {@link com.smartgwt.client.widgets.form.fields.FormItem#getUseLocalDisplayFieldValue
     * FormItem.useLocalDisplayFieldValue} is true, (or if unset and the conditions outlined in the documentation for that
     * property are met). <P> If this field has an {@link com.smartgwt.client.widgets.form.fields.FormItem#getOptionDataSource
     * FormItem.optionDataSource}, this property is used by default to identify which value to use as a display value in
     * records from this related dataSource. In this usage the specified displayField must be  explicitly defined in the
     * optionDataSource to be used - see  {@link com.smartgwt.client.widgets.form.fields.FormItem#getDisplayFieldName
     * getDisplayFieldName()} for more on this behavior.<br> If not using {@link
     * com.smartgwt.client.widgets.form.fields.FormItem#getUseLocalDisplayFieldValue local display values}, the display value
     * for this item will be derived by performing a fetch against the  {@link
     * com.smartgwt.client.widgets.form.fields.FormItem#getOptionDataSource option dataSource}  to find a record where the
     * {@link com.smartgwt.client.widgets.form.fields.FormItem#getValueFieldName value field} matches  this item's value, and
     * use the <code>displayField</code> value from that record.<br> In addition to this, PickList-based form items that
     * provide a list of possible options such as the {@link com.smartgwt.client.widgets.form.fields.SelectItem} or {@link
     * com.smartgwt.client.widgets.form.fields.ComboBoxItem} will show the  <code>displayField</code> values to the user by
     * default, allowing them to choose a new data value (see {@link
     * com.smartgwt.client.widgets.form.fields.FormItem#getValueField FormItem.valueField}) from a list of user-friendly
     * display values. <P> This essentially allows the specified <code>optionDataSource</code> to be used as a server based
     * {@link valueMap}. <P> If {@link com.smartgwt.client.widgets.form.fields.FormItem#getUseLocalDisplayFieldValue local
     * display values} are being used and {@link com.smartgwt.client.widgets.form.fields.FormItem#getStoreDisplayValues
     * FormItem.storeDisplayValues} is true, selecting a new value will update both the value for this field and the associated
     * display-field value on the record being edited. <P> Note: Developers may specify the {@link
     * com.smartgwt.client.widgets.form.fields.FormItem#getForeignDisplayField FormItem.foreignDisplayField} property  in
     * addition to <code>displayField</code>. This is useful for cases where the display field name in the local dataSource
     * differs from the display field name in the optionDataSource. See the documentation for {@link
     * com.smartgwt.client.data.DataSourceField#getForeignDisplayField DataSourceField.foreignDisplayField} for more on
     * this.<br> If a foreignDisplayField is specified, as with just displayField, if  {@link
     * com.smartgwt.client.widgets.form.fields.FormItem#getUseLocalDisplayFieldValue local display values} are being used and
     * {@link com.smartgwt.client.widgets.form.fields.FormItem#getStoreDisplayValues FormItem.storeDisplayValues} is true, when
     * the user  chooses a value the associated display-field value  on the record being edited will be updated. In this case
     * it would be set to the  foreignDisplayField value from the related record. This means foreignDisplayField  is always
     * expected to be set to the equivalent field in the related dataSources.<br> Developers looking to display some
     * <i>other</i> arbitrary field(s) from the related dataSource during editing should consider using custom 
     * PickList.pickListFields instead of setting a foreignDisplayField.  <P> Note that if <code>optionDataSource</code> is set
     * and no valid display field is specified, {@link com.smartgwt.client.widgets.form.fields.FormItem#getDisplayFieldName
     * FormItem.getDisplayFieldName()} will return the dataSource title  field by default. <P> If a displayField is specified
     * for a freeform text based item (such as a  {@link com.smartgwt.client.widgets.form.fields.ComboBoxItem}), any
     * user-entered value will be treated as a display value. In this scenario, items will derive the data value for the item
     * from the first record where the displayField value matches the user-entered value. To avoid ambiguity, developers may
     * wish to avoid this usage if display values are not unique.
     *
     * @param displayField New displayField value. Default value is null
     * @return {@link com.smartgwt.client.widgets.form.fields.ShuttleItem ShuttleItem} instance, for chaining setter calls
     * @see com.smartgwt.client.widgets.form.fields.FormItem#getDisplayFieldName
     * @see com.smartgwt.client.widgets.form.fields.FormItem#invalidateDisplayValueCache
     * @see com.smartgwt.client.docs.Databinding DataBinding
     */
    public ShuttleItem setDisplayField(String displayField) {
        return (ShuttleItem)setAttribute("displayField", displayField);
    }

    /**
     * If set, this item will display a value from another field to the user instead of showing the underlying data value for
     * the {@link com.smartgwt.client.widgets.form.fields.FormItem#getName field name}. <P> This property is used in two ways:
     * <P> The item will display the displayField value from the  {@link com.smartgwt.client.widgets.form.DynamicForm#getValues
     * record currently being edited} if  {@link com.smartgwt.client.widgets.form.fields.FormItem#getUseLocalDisplayFieldValue
     * FormItem.useLocalDisplayFieldValue} is true, (or if unset and the conditions outlined in the documentation for that
     * property are met). <P> If this field has an {@link com.smartgwt.client.widgets.form.fields.FormItem#getOptionDataSource
     * FormItem.optionDataSource}, this property is used by default to identify which value to use as a display value in
     * records from this related dataSource. In this usage the specified displayField must be  explicitly defined in the
     * optionDataSource to be used - see  {@link com.smartgwt.client.widgets.form.fields.FormItem#getDisplayFieldName
     * getDisplayFieldName()} for more on this behavior.<br> If not using {@link
     * com.smartgwt.client.widgets.form.fields.FormItem#getUseLocalDisplayFieldValue local display values}, the display value
     * for this item will be derived by performing a fetch against the  {@link
     * com.smartgwt.client.widgets.form.fields.FormItem#getOptionDataSource option dataSource}  to find a record where the
     * {@link com.smartgwt.client.widgets.form.fields.FormItem#getValueFieldName value field} matches  this item's value, and
     * use the <code>displayField</code> value from that record.<br> In addition to this, PickList-based form items that
     * provide a list of possible options such as the {@link com.smartgwt.client.widgets.form.fields.SelectItem} or {@link
     * com.smartgwt.client.widgets.form.fields.ComboBoxItem} will show the  <code>displayField</code> values to the user by
     * default, allowing them to choose a new data value (see {@link
     * com.smartgwt.client.widgets.form.fields.FormItem#getValueField FormItem.valueField}) from a list of user-friendly
     * display values. <P> This essentially allows the specified <code>optionDataSource</code> to be used as a server based
     * {@link valueMap}. <P> If {@link com.smartgwt.client.widgets.form.fields.FormItem#getUseLocalDisplayFieldValue local
     * display values} are being used and {@link com.smartgwt.client.widgets.form.fields.FormItem#getStoreDisplayValues
     * FormItem.storeDisplayValues} is true, selecting a new value will update both the value for this field and the associated
     * display-field value on the record being edited. <P> Note: Developers may specify the {@link
     * com.smartgwt.client.widgets.form.fields.FormItem#getForeignDisplayField FormItem.foreignDisplayField} property  in
     * addition to <code>displayField</code>. This is useful for cases where the display field name in the local dataSource
     * differs from the display field name in the optionDataSource. See the documentation for {@link
     * com.smartgwt.client.data.DataSourceField#getForeignDisplayField DataSourceField.foreignDisplayField} for more on
     * this.<br> If a foreignDisplayField is specified, as with just displayField, if  {@link
     * com.smartgwt.client.widgets.form.fields.FormItem#getUseLocalDisplayFieldValue local display values} are being used and
     * {@link com.smartgwt.client.widgets.form.fields.FormItem#getStoreDisplayValues FormItem.storeDisplayValues} is true, when
     * the user  chooses a value the associated display-field value  on the record being edited will be updated. In this case
     * it would be set to the  foreignDisplayField value from the related record. This means foreignDisplayField  is always
     * expected to be set to the equivalent field in the related dataSources.<br> Developers looking to display some
     * <i>other</i> arbitrary field(s) from the related dataSource during editing should consider using custom 
     * PickList.pickListFields instead of setting a foreignDisplayField.  <P> Note that if <code>optionDataSource</code> is set
     * and no valid display field is specified, {@link com.smartgwt.client.widgets.form.fields.FormItem#getDisplayFieldName
     * FormItem.getDisplayFieldName()} will return the dataSource title  field by default. <P> If a displayField is specified
     * for a freeform text based item (such as a  {@link com.smartgwt.client.widgets.form.fields.ComboBoxItem}), any
     * user-entered value will be treated as a display value. In this scenario, items will derive the data value for the item
     * from the first record where the displayField value matches the user-entered value. To avoid ambiguity, developers may
     * wish to avoid this usage if display values are not unique.
     *
     * @return Current displayField value. Default value is null
     * @see com.smartgwt.client.widgets.form.fields.FormItem#getDisplayFieldName
     * @see com.smartgwt.client.widgets.form.fields.FormItem#invalidateDisplayValueCache
     * @see com.smartgwt.client.docs.Databinding DataBinding
     */
    public String getDisplayField()  {
        return getAttributeAsString("displayField");
    }
    

    /**
     * Height of the FormItem.  Can be either a number indicating a fixed height in pixels, a percentage indicating a
     * percentage of the overall form's height, or "*" indicating take whatever remaining space is available. See the {@link
     * com.smartgwt.client.docs.FormLayout} overview for details. <p> If height is specified as a String, getHeight() will
     * return -1.  Use   getHeightAsString.() in this case.<p> For form items having a {@link
     * com.smartgwt.client.widgets.form.fields.FormItem#getShowPickerIcon picker icon} (e.g. {@link
     * com.smartgwt.client.widgets.form.fields.SelectItem}, {@link com.smartgwt.client.widgets.form.fields.ComboBoxItem}) and
     * {@link com.smartgwt.client.widgets.form.fields.SpinnerItem}s, if there is no explicit  {@link
     * com.smartgwt.client.widgets.form.fields.FormItem#getPickerIconHeight FormItem.pickerIconHeight}, the pickerIcon will be
     * sized to match the available space based on the specified item height.<br> Note that if spriting is being used, and the
     * image to be displayed in these icons is specified  using css properties such as <code>background-image</code>,
     * <code>background-size</code>, changing this value may result in an unexpected appearance as the image will not
     * scale.<br> Scaleable spriting can be achieved using the {@link com.smartgwt.client.docs.SCSpriteConfig} format. See the
     * section on spriting in the {@link com.smartgwt.client.docs.Skinning skinning overview} for  further information.<br>
     * Alternatively, the {@link com.smartgwt.client.widgets.form.fields.FormItem#getPickerIconStyle pickerIconStyle} could be
     * changed to a custom CSS style name, and in the case of {@link com.smartgwt.client.widgets.form.fields.SpinnerItem}s, 
     * the {@link com.smartgwt.client.widgets.form.fields.FormItemIcon#getBaseStyle baseStyle} and {@link
     * com.smartgwt.client.widgets.form.fields.FormItemIcon#getSrc src} of the {@link
     * com.smartgwt.client.widgets.form.fields.SpinnerItem#getIncreaseIcon SpinnerItem.increaseIcon} and {@link
     * com.smartgwt.client.widgets.form.fields.SpinnerItem#getDecreaseIcon SpinnerItem.decreaseIcon} AutoChildren could be
     * customized. <p> Note that when FormItem is rendered as read-only with <code>readOnlyDisplay</code> as "static" the
     * property {@link com.smartgwt.client.widgets.form.fields.FormItem#getStaticHeight FormItem.staticHeight} is used instead.
     *
     * @param height New height value. Default value is 400
     * @return {@link com.smartgwt.client.widgets.form.fields.ShuttleItem ShuttleItem} instance, for chaining setter calls
     * @see com.smartgwt.client.widgets.form.fields.FormItem#setWidth
     * @see com.smartgwt.client.widgets.form.DynamicForm#setItemLayout
     * @see com.smartgwt.client.docs.FormLayout Form Layout
     * @see <a href="http://www.smartclient.com/smartgwt/showcase/#layout_form_filling" target="examples">Filling Example</a>
     */
    public ShuttleItem setHeight(int height) {
        return (ShuttleItem)setAttribute("height", height);
    }

    /**
     * Height of the FormItem.  Can be either a number indicating a fixed height in pixels, a percentage indicating a
     * percentage of the overall form's height, or "*" indicating take whatever remaining space is available. See the {@link
     * com.smartgwt.client.docs.FormLayout} overview for details. <p> If height is specified as a String, getHeight() will
     * return -1.  Use   getHeightAsString.() in this case.<p> For form items having a {@link
     * com.smartgwt.client.widgets.form.fields.FormItem#getShowPickerIcon picker icon} (e.g. {@link
     * com.smartgwt.client.widgets.form.fields.SelectItem}, {@link com.smartgwt.client.widgets.form.fields.ComboBoxItem}) and
     * {@link com.smartgwt.client.widgets.form.fields.SpinnerItem}s, if there is no explicit  {@link
     * com.smartgwt.client.widgets.form.fields.FormItem#getPickerIconHeight FormItem.pickerIconHeight}, the pickerIcon will be
     * sized to match the available space based on the specified item height.<br> Note that if spriting is being used, and the
     * image to be displayed in these icons is specified  using css properties such as <code>background-image</code>,
     * <code>background-size</code>, changing this value may result in an unexpected appearance as the image will not
     * scale.<br> Scaleable spriting can be achieved using the {@link com.smartgwt.client.docs.SCSpriteConfig} format. See the
     * section on spriting in the {@link com.smartgwt.client.docs.Skinning skinning overview} for  further information.<br>
     * Alternatively, the {@link com.smartgwt.client.widgets.form.fields.FormItem#getPickerIconStyle pickerIconStyle} could be
     * changed to a custom CSS style name, and in the case of {@link com.smartgwt.client.widgets.form.fields.SpinnerItem}s, 
     * the {@link com.smartgwt.client.widgets.form.fields.FormItemIcon#getBaseStyle baseStyle} and {@link
     * com.smartgwt.client.widgets.form.fields.FormItemIcon#getSrc src} of the {@link
     * com.smartgwt.client.widgets.form.fields.SpinnerItem#getIncreaseIcon SpinnerItem.increaseIcon} and {@link
     * com.smartgwt.client.widgets.form.fields.SpinnerItem#getDecreaseIcon SpinnerItem.decreaseIcon} AutoChildren could be
     * customized. <p> Note that when FormItem is rendered as read-only with <code>readOnlyDisplay</code> as "static" the
     * property {@link com.smartgwt.client.widgets.form.fields.FormItem#getStaticHeight FormItem.staticHeight} is used instead.
     *
     * <p><b>Note :</b> This method will return -1 if the underlying SmartClient JavaScript
     * attribute value cannot be expressed as a(n) int.  In that case, other
     * getters,  similarly-named but ending in <code>AsString</code>, <code>AsCanvas</code>,
     * etc., may be provided.
     *
     * @return Current height value. Default value is 400
     * @see com.smartgwt.client.widgets.form.fields.FormItem#getWidth
     * @see com.smartgwt.client.widgets.form.DynamicForm#getItemLayout
     * @see com.smartgwt.client.docs.FormLayout Form Layout
     * @see <a href="http://www.smartclient.com/smartgwt/showcase/#layout_form_filling" target="examples">Filling Example</a>
     */
    public int getHeight()  {
        if (!(getAttributeAsObject("height") instanceof Integer)) { return -1; }
        return getAttributeAsInt("height");
    }

    /**
     * Height of the FormItem.  Can be either a number indicating a fixed height in pixels, a percentage indicating a
     * percentage of the overall form's height, or "*" indicating take whatever remaining space is available. See the {@link
     * com.smartgwt.client.docs.FormLayout} overview for details. <p> If height is specified as a String, getHeight() will
     * return -1.  Use   getHeightAsString.() in this case.<p> For form items having a {@link
     * com.smartgwt.client.widgets.form.fields.FormItem#getShowPickerIcon picker icon} (e.g. {@link
     * com.smartgwt.client.widgets.form.fields.SelectItem}, {@link com.smartgwt.client.widgets.form.fields.ComboBoxItem}) and
     * {@link com.smartgwt.client.widgets.form.fields.SpinnerItem}s, if there is no explicit  {@link
     * com.smartgwt.client.widgets.form.fields.FormItem#getPickerIconHeight FormItem.pickerIconHeight}, the pickerIcon will be
     * sized to match the available space based on the specified item height.<br> Note that if spriting is being used, and the
     * image to be displayed in these icons is specified  using css properties such as <code>background-image</code>,
     * <code>background-size</code>, changing this value may result in an unexpected appearance as the image will not
     * scale.<br> Scaleable spriting can be achieved using the {@link com.smartgwt.client.docs.SCSpriteConfig} format. See the
     * section on spriting in the {@link com.smartgwt.client.docs.Skinning skinning overview} for  further information.<br>
     * Alternatively, the {@link com.smartgwt.client.widgets.form.fields.FormItem#getPickerIconStyle pickerIconStyle} could be
     * changed to a custom CSS style name, and in the case of {@link com.smartgwt.client.widgets.form.fields.SpinnerItem}s, 
     * the {@link com.smartgwt.client.widgets.form.fields.FormItemIcon#getBaseStyle baseStyle} and {@link
     * com.smartgwt.client.widgets.form.fields.FormItemIcon#getSrc src} of the {@link
     * com.smartgwt.client.widgets.form.fields.SpinnerItem#getIncreaseIcon SpinnerItem.increaseIcon} and {@link
     * com.smartgwt.client.widgets.form.fields.SpinnerItem#getDecreaseIcon SpinnerItem.decreaseIcon} AutoChildren could be
     * customized. <p> Note that when FormItem is rendered as read-only with <code>readOnlyDisplay</code> as "static" the
     * property {@link com.smartgwt.client.widgets.form.fields.FormItem#getStaticHeight FormItem.staticHeight} is used instead.
     *
     * @param height New height value. Default value is 400
     * @return {@link com.smartgwt.client.widgets.form.fields.ShuttleItem ShuttleItem} instance, for chaining setter calls
     * @see com.smartgwt.client.widgets.form.fields.FormItem#setWidth
     * @see com.smartgwt.client.widgets.form.DynamicForm#setItemLayout
     * @see com.smartgwt.client.docs.FormLayout Form Layout
     * @see <a href="http://www.smartclient.com/smartgwt/showcase/#layout_form_filling" target="examples">Filling Example</a>
     */
    public ShuttleItem setHeight(String height) {
        return (ShuttleItem)setAttribute("height", height);
    }

    /**
     * Height of the FormItem.  Can be either a number indicating a fixed height in pixels, a percentage indicating a
     * percentage of the overall form's height, or "*" indicating take whatever remaining space is available. See the {@link
     * com.smartgwt.client.docs.FormLayout} overview for details. <p> If height is specified as a String, getHeight() will
     * return -1.  Use   getHeightAsString.() in this case.<p> For form items having a {@link
     * com.smartgwt.client.widgets.form.fields.FormItem#getShowPickerIcon picker icon} (e.g. {@link
     * com.smartgwt.client.widgets.form.fields.SelectItem}, {@link com.smartgwt.client.widgets.form.fields.ComboBoxItem}) and
     * {@link com.smartgwt.client.widgets.form.fields.SpinnerItem}s, if there is no explicit  {@link
     * com.smartgwt.client.widgets.form.fields.FormItem#getPickerIconHeight FormItem.pickerIconHeight}, the pickerIcon will be
     * sized to match the available space based on the specified item height.<br> Note that if spriting is being used, and the
     * image to be displayed in these icons is specified  using css properties such as <code>background-image</code>,
     * <code>background-size</code>, changing this value may result in an unexpected appearance as the image will not
     * scale.<br> Scaleable spriting can be achieved using the {@link com.smartgwt.client.docs.SCSpriteConfig} format. See the
     * section on spriting in the {@link com.smartgwt.client.docs.Skinning skinning overview} for  further information.<br>
     * Alternatively, the {@link com.smartgwt.client.widgets.form.fields.FormItem#getPickerIconStyle pickerIconStyle} could be
     * changed to a custom CSS style name, and in the case of {@link com.smartgwt.client.widgets.form.fields.SpinnerItem}s, 
     * the {@link com.smartgwt.client.widgets.form.fields.FormItemIcon#getBaseStyle baseStyle} and {@link
     * com.smartgwt.client.widgets.form.fields.FormItemIcon#getSrc src} of the {@link
     * com.smartgwt.client.widgets.form.fields.SpinnerItem#getIncreaseIcon SpinnerItem.increaseIcon} and {@link
     * com.smartgwt.client.widgets.form.fields.SpinnerItem#getDecreaseIcon SpinnerItem.decreaseIcon} AutoChildren could be
     * customized. <p> Note that when FormItem is rendered as read-only with <code>readOnlyDisplay</code> as "static" the
     * property {@link com.smartgwt.client.widgets.form.fields.FormItem#getStaticHeight FormItem.staticHeight} is used instead.
     *
     * @return Current height value. Default value is 400
     * @see com.smartgwt.client.widgets.form.fields.FormItem#getWidth
     * @see com.smartgwt.client.widgets.form.DynamicForm#getItemLayout
     * @see com.smartgwt.client.docs.FormLayout Form Layout
     * @see <a href="http://www.smartclient.com/smartgwt/showcase/#layout_form_filling" target="examples">Filling Example</a>
     */
    public String getHeightAsString()  {
        return getAttributeAsString("height");
    }
    

    /**
     * The optionDataSource for a shuttle item will be applied to the {@link com.smartgwt.client.widgets.grid.Shuttle} as
     * {@link com.smartgwt.client.widgets.grid.Shuttle#getDataSource Shuttle.dataSource}. <P> If no explicit optionDataSource
     * was specified it may be automatically derived - see {@link
     * com.smartgwt.client.widgets.form.fields.FormItem#getOptionDataSource FormItem.getOptionDataSource()} for details.
     *
     * @param optionDataSource New optionDataSource value. Default value is null
     * @return {@link com.smartgwt.client.widgets.form.fields.ShuttleItem ShuttleItem} instance, for chaining setter calls
     */
    public ShuttleItem setOptionDataSource(DataSource optionDataSource) {
        return (ShuttleItem)setAttribute("optionDataSource", optionDataSource == null ? null : optionDataSource.getOrCreateJsObj());
    }

    /**
     * The optionDataSource for a shuttle item will be applied to the {@link com.smartgwt.client.widgets.grid.Shuttle} as
     * {@link com.smartgwt.client.widgets.grid.Shuttle#getDataSource Shuttle.dataSource}. <P> If no explicit optionDataSource
     * was specified it may be automatically derived - see {@link
     * com.smartgwt.client.widgets.form.fields.FormItem#getOptionDataSource FormItem.getOptionDataSource()} for details.
     *
     * @return Current optionDataSource value. Default value is null
     */
    public DataSource getOptionDataSource()  {
        return DataSource.getOrCreateRef(getAttributeAsJavaScriptObject("optionDataSource"));
    }
    

    /**
     * The ShuttleItem generates a {@link com.smartgwt.client.widgets.grid.Shuttle} {@link com.smartgwt.client.types.AutoChild}
     * as its  {@link com.smartgwt.client.widgets.form.fields.CanvasItem#getCanvas canvas}.
     * <p>
     * This component is an AutoChild named "shuttle".  For an overview of how to use and
     * configure AutoChildren, see {@link com.smartgwt.client.docs.AutoChildUsage Using AutoChildren}.
     *
     * @return Current shuttle value. Default value is null
     */
    public Shuttle getShuttle()  {
        return (Shuttle)Shuttle.getByJSObject(getAttributeAsJavaScriptObject("shuttle"));
    }
    

    /**
     * Which {@link com.smartgwt.client.widgets.grid.Shuttle#getFields Shuttle.fields} should be displayed in the {@link
     * com.smartgwt.client.widgets.grid.Shuttle}. <P> If not specified, the grids within the shuttle will show a single field
     * containing the {@link com.smartgwt.client.widgets.form.fields.FormItem#getDisplayFieldName displayField}, if specified
     * otherwise the {@link com.smartgwt.client.widgets.form.fields.FormItem#getValueFieldName valueField} for the item
     *
     * @param shuttleFields New shuttleFields value. Default value is null
     * @return {@link com.smartgwt.client.widgets.form.fields.ShuttleItem ShuttleItem} instance, for chaining setter calls
     */
    public ShuttleItem setShuttleFields(ListGridField... shuttleFields) {
        return (ShuttleItem)setAttribute("shuttleFields", shuttleFields);
    }

    /**
     * Which {@link com.smartgwt.client.widgets.grid.Shuttle#getFields Shuttle.fields} should be displayed in the {@link
     * com.smartgwt.client.widgets.grid.Shuttle}. <P> If not specified, the grids within the shuttle will show a single field
     * containing the {@link com.smartgwt.client.widgets.form.fields.FormItem#getDisplayFieldName displayField}, if specified
     * otherwise the {@link com.smartgwt.client.widgets.form.fields.FormItem#getValueFieldName valueField} for the item
     *
     * @return Current shuttleFields value. Default value is null
     */
    public ListGridField[] getShuttleFields()  {
        return com.smartgwt.client.util.ConvertTo.arrayOfListGridField(getAttributeAsJavaScriptObject("shuttleFields"));
    }
    

    /**
     * The value field for a shuttle item will be applied to the {@link com.smartgwt.client.widgets.grid.Shuttle} as {@link
     * com.smartgwt.client.widgets.grid.Shuttle#getValueField Shuttle.valueField}. <P> If no explicit valueField was specified
     * it may be automatically derived - see {@link com.smartgwt.client.widgets.form.fields.FormItem#getValueFieldName
     * FormItem.getValueFieldName()} for details.
     *
     * @param valueField New valueField value. Default value is null
     * @return {@link com.smartgwt.client.widgets.form.fields.ShuttleItem ShuttleItem} instance, for chaining setter calls
     */
    public ShuttleItem setValueField(String valueField) {
        return (ShuttleItem)setAttribute("valueField", valueField);
    }

    /**
     * The value field for a shuttle item will be applied to the {@link com.smartgwt.client.widgets.grid.Shuttle} as {@link
     * com.smartgwt.client.widgets.grid.Shuttle#getValueField Shuttle.valueField}. <P> If no explicit valueField was specified
     * it may be automatically derived - see {@link com.smartgwt.client.widgets.form.fields.FormItem#getValueFieldName
     * FormItem.getValueFieldName()} for details.
     *
     * @return Current valueField value. Default value is null
     */
    public String getValueField()  {
        return getAttributeAsString("valueField");
    }
    

    /**
     * Width of the FormItem.  Can be either a number indicating a fixed width in pixels, or "*" indicating the FormItem fills
     * the space allocated to it's column (or columns, for a {@link com.smartgwt.client.widgets.form.fields.FormItem#getColSpan
     * column spanning} item).  You may also use "100%" as a synonym for "*", but other percentages are not supported. <P> Note
     * that for "absolute" item layout rather than the default "table" layout, the rules for specifying the width are slightly
     * different.  All percent sizes are allowed, but not "*".  See {@link
     * com.smartgwt.client.widgets.form.DynamicForm#getItemLayout DynamicForm.itemLayout} for further details. <P> If width is
     * specified as a String, getWidth() will return -1.  Use   getWidthAsString.() in this case.<p> See the {@link
     * com.smartgwt.client.docs.FormLayout} overview for details.
     *
     * @param width New width value. Default value is 400
     * @return {@link com.smartgwt.client.widgets.form.fields.ShuttleItem ShuttleItem} instance, for chaining setter calls
     * @see com.smartgwt.client.widgets.form.fields.FormItem#setLinearWidth
     * @see com.smartgwt.client.widgets.form.fields.FormItem#setHeight
     * @see com.smartgwt.client.widgets.form.DynamicForm#setItemLayout
     * @see com.smartgwt.client.docs.FormLayout Form Layout
     * @see <a href="http://www.smartclient.com/smartgwt/showcase/#layout_form_spanning" target="examples">Spanning Example</a>
     */
    public ShuttleItem setWidth(int width) {
        return (ShuttleItem)setAttribute("width", width);
    }

    /**
     * Width of the FormItem.  Can be either a number indicating a fixed width in pixels, or "*" indicating the FormItem fills
     * the space allocated to it's column (or columns, for a {@link com.smartgwt.client.widgets.form.fields.FormItem#getColSpan
     * column spanning} item).  You may also use "100%" as a synonym for "*", but other percentages are not supported. <P> Note
     * that for "absolute" item layout rather than the default "table" layout, the rules for specifying the width are slightly
     * different.  All percent sizes are allowed, but not "*".  See {@link
     * com.smartgwt.client.widgets.form.DynamicForm#getItemLayout DynamicForm.itemLayout} for further details. <P> If width is
     * specified as a String, getWidth() will return -1.  Use   getWidthAsString.() in this case.<p> See the {@link
     * com.smartgwt.client.docs.FormLayout} overview for details.
     *
     * <p><b>Note :</b> This method will return -1 if the underlying SmartClient JavaScript
     * attribute value cannot be expressed as a(n) int.  In that case, other
     * getters,  similarly-named but ending in <code>AsString</code>, <code>AsCanvas</code>,
     * etc., may be provided.
     *
     * @return Current width value. Default value is 400
     * @see com.smartgwt.client.widgets.form.fields.FormItem#getLinearWidth
     * @see com.smartgwt.client.widgets.form.fields.FormItem#getHeight
     * @see com.smartgwt.client.widgets.form.DynamicForm#getItemLayout
     * @see com.smartgwt.client.docs.FormLayout Form Layout
     * @see <a href="http://www.smartclient.com/smartgwt/showcase/#layout_form_spanning" target="examples">Spanning Example</a>
     */
    public int getWidth()  {
        if (!(getAttributeAsObject("width") instanceof Integer)) { return -1; }
        return getAttributeAsInt("width");
    }

    /**
     * Width of the FormItem.  Can be either a number indicating a fixed width in pixels, or "*" indicating the FormItem fills
     * the space allocated to it's column (or columns, for a {@link com.smartgwt.client.widgets.form.fields.FormItem#getColSpan
     * column spanning} item).  You may also use "100%" as a synonym for "*", but other percentages are not supported. <P> Note
     * that for "absolute" item layout rather than the default "table" layout, the rules for specifying the width are slightly
     * different.  All percent sizes are allowed, but not "*".  See {@link
     * com.smartgwt.client.widgets.form.DynamicForm#getItemLayout DynamicForm.itemLayout} for further details. <P> If width is
     * specified as a String, getWidth() will return -1.  Use   getWidthAsString.() in this case.<p> See the {@link
     * com.smartgwt.client.docs.FormLayout} overview for details.
     *
     * @param width New width value. Default value is 400
     * @return {@link com.smartgwt.client.widgets.form.fields.ShuttleItem ShuttleItem} instance, for chaining setter calls
     * @see com.smartgwt.client.widgets.form.fields.FormItem#setLinearWidth
     * @see com.smartgwt.client.widgets.form.fields.FormItem#setHeight
     * @see com.smartgwt.client.widgets.form.DynamicForm#setItemLayout
     * @see com.smartgwt.client.docs.FormLayout Form Layout
     * @see <a href="http://www.smartclient.com/smartgwt/showcase/#layout_form_spanning" target="examples">Spanning Example</a>
     */
    public ShuttleItem setWidth(String width) {
        return (ShuttleItem)setAttribute("width", width);
    }

    /**
     * Width of the FormItem.  Can be either a number indicating a fixed width in pixels, or "*" indicating the FormItem fills
     * the space allocated to it's column (or columns, for a {@link com.smartgwt.client.widgets.form.fields.FormItem#getColSpan
     * column spanning} item).  You may also use "100%" as a synonym for "*", but other percentages are not supported. <P> Note
     * that for "absolute" item layout rather than the default "table" layout, the rules for specifying the width are slightly
     * different.  All percent sizes are allowed, but not "*".  See {@link
     * com.smartgwt.client.widgets.form.DynamicForm#getItemLayout DynamicForm.itemLayout} for further details. <P> If width is
     * specified as a String, getWidth() will return -1.  Use   getWidthAsString.() in this case.<p> See the {@link
     * com.smartgwt.client.docs.FormLayout} overview for details.
     *
     * @return Current width value. Default value is 400
     * @see com.smartgwt.client.widgets.form.fields.FormItem#getLinearWidth
     * @see com.smartgwt.client.widgets.form.fields.FormItem#getHeight
     * @see com.smartgwt.client.widgets.form.DynamicForm#getItemLayout
     * @see com.smartgwt.client.docs.FormLayout Form Layout
     * @see <a href="http://www.smartclient.com/smartgwt/showcase/#layout_form_spanning" target="examples">Spanning Example</a>
     */
    public String getWidthAsString()  {
        return getAttributeAsString("width");
    }
    

    // ********************* Methods ***********************

    // ********************* Static Methods ***********************

    /** 
     * Class level method to set the default properties of this class.  If set, then all
     * existing and subsequently created instances of this class will automatically have
     * default properties corresponding to
     * the properties of the class instance passed to this function.
     * This is a powerful feature that eliminates the need for users to create a separate
     * hierarchy of subclasses that only alter the default properties of this class. Can also
     * be used for skinning / styling purposes.  <P> <b>Note:</b> This method is intended for
     * setting default attributes only and will affect all instances of the underlying class
     * (including those automatically generated in JavaScript).  This method should not be used
     * to apply standard EventHandlers or override methods for a class - use a custom subclass
     * instead.  Calling this method after instances have been created can result in undefined
     * behavior, since it bypasses any setters and a class instance may have already examined 
     * a particular property and not be expecting any changes through this route.
     *
     * @param shuttleItemProperties properties that should be used as new defaults when instances of this class are created
     * @see com.smartgwt.client.docs.SGWTProperties
     */
    public static native void setDefaultProperties(ShuttleItem shuttleItemProperties) /*-{
        if (shuttleItemProperties.@com.smartgwt.client.widgets.form.fields.FormItem::isCreated()()) {
            @com.smartgwt.client.util.ConfigUtil::warnOfPreConfigInstantiation(Ljava/lang/Class;Ljava/lang/String;Ljava/lang/Class;)(ShuttleItem.@java.lang.Object::getClass()(), "setDefaultProperties", shuttleItemProperties.@java.lang.Object::getClass()());
        }
        shuttleItemProperties.@com.smartgwt.client.widgets.form.fields.FormItem::setConfigOnly(Z)(true);
    	var properties = shuttleItemProperties.@com.smartgwt.client.widgets.form.fields.FormItem::getConfig()();
        $wnd.isc.ShuttleItem.addProperties(properties);
    }-*/;

    // ***********************************************************

}
