
package com.smartgwt.client.docs;

/**
 * <h3>Handling concurrent edits in Smart GWT DataSources</h3>
 * How do Smart GWT DataSources handle multiple users making changes to the same record? <P>
 * Consider a scenario where two users - <i>userA</i> and <i>userB</i> - are logged  into the same
 * application and viewing the same set of records in a Smart GWT application: <ul> 
 * <li><i>userA</i> makes a change to a record and {@link
 * com.smartgwt.client.widgets.form.DynamicForm#saveData saves the edit}</li>  <li><i>userB</i>
 * then makes another change to the same record and saves their edit</li> </ul> By default Smart
 * GWT dataSources have simple "most recent edit wins" behavior, so the changes made by userB will
 * be preserved in the dataSource permanent storage - though if {@link
 * com.smartgwt.client.docs.serverds.DataSource#sparseUpdates DataSource.sparseUpdates} is false,
 * any changes made by <i>userA</i> to fields that were not explicitly edited by <i>userB</i> will
 * also be preserved. <P> In this case when <i>userA</i> performs their first edit (before
 * <i>userB</i> has attempted a save), <i>userB</i> will not see <i>userA</i>'s changes unless
 * they explicitly re-fetch the data. Similarly, <i>userA</i> will not see <i>userB</i>'s
 * subsequent edit without a re-fetch. <P> In many applications this behavior is acceptable but
 * there may be cases where users will need to see other users' updates as they occur, and simple
 * "last edit wins"  is not sufficient. There are 2 things you can do to make this more
 * sophisticated: <P> <b>Broadcasting changes:</b><br> The {@link
 * com.smartgwt.client.data.DataSource#updateCaches DataSource.updateCaches()} method is a way to
 * notify a DataSource that a change has occurred. It will update its client-side caches to
 * reflect the change and databound components showing the record will be refreshed as
 * appropriate. <P> Developers using the Smart GWT server and {@link
 * com.smartgwt.client.docs.Messaging} may use this feature to propogate changes from the server
 * to the client. <P> See this <a
 * href='https://isomorphic.atlassian.net/wiki/spaces/Main/pages/525130/How+to+propagate+data+source+changes+to+all+clients+by+using+the+Real-Time+Messaging+Module'
 * target='_blank'>blog post</a>  for details on this approach.  <P> <b>Detecting concurrent
 * edits:</b><br> Note that even if an application is using Realtime Messaging or some  similar
 * approach to notify users of external edits as soon as they occur,  it is still possible to get
 * concurrent edit attempts on the same record. <P> In our original scenario - if <i>userB</i> hit
 * their save button after <i>userA</i> but before the server had processed <i>userA</i>'s
 * request, <i>userB</i>'s edit would essentially be based on "stale" values.  <P> One way to
 * detect this is to have custom server logic compare {@link
 * com.smartgwt.client.data.DSRequest#getOldValues DSRequest.oldValues} with the current values
 * for the edited record and disallow the edit when this occurs. <P> See this <a
 * href='https://isomorphic.atlassian.net/wiki/spaces/Main/pages/525045/Detecting+concurrent+edits+with+long+transactions'
 * target='_blank'>blog post</a> for details on using oldValues to detect concurrent edits.
 */
public interface ConcurrentEdits {
}
