/*
 * Smart GWT (GWT for SmartClient)
 * Copyright 2008 and beyond, Isomorphic Software, Inc.
 *
 * Smart GWT is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License version 3
 * as published by the Free Software Foundation.  Smart GWT is also
 * available under typical commercial license terms - see
 * http://smartclient.com/license
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 */
/* sgwtgen */
 
package com.smartgwt.client.ai;


import com.smartgwt.client.event.*;
import com.smartgwt.client.core.*;
import com.smartgwt.client.types.*;
import com.smartgwt.client.data.*;
import com.smartgwt.client.data.Record;
import com.smartgwt.client.data.events.*;
import com.smartgwt.client.browser.window.*;
import com.smartgwt.client.rpc.*;
import com.smartgwt.client.ai.*;
import com.smartgwt.client.callbacks.*;
import com.smartgwt.client.tools.*;
import com.smartgwt.client.bean.*;
import com.smartgwt.client.widgets.*;
import com.smartgwt.client.widgets.ai.*;
import com.smartgwt.client.widgets.events.*;
import com.smartgwt.client.widgets.form.*;
import com.smartgwt.client.widgets.form.validator.*;
import com.smartgwt.client.widgets.form.fields.*;
import com.smartgwt.client.widgets.tile.*;
import com.smartgwt.client.widgets.tile.events.*;
import com.smartgwt.client.widgets.grid.*;
import com.smartgwt.client.widgets.grid.events.*;
import com.smartgwt.client.widgets.chart.*;
import com.smartgwt.client.widgets.layout.*;
import com.smartgwt.client.widgets.layout.events.*;
import com.smartgwt.client.widgets.menu.*;
import com.smartgwt.client.widgets.tour.*;
import com.smartgwt.client.widgets.notify.*;
import com.smartgwt.client.widgets.rte.*;
import com.smartgwt.client.widgets.rte.events.*;
import com.smartgwt.client.widgets.ace.*;
import com.smartgwt.client.widgets.ace.events.*;
import com.smartgwt.client.widgets.tab.*;
import com.smartgwt.client.widgets.toolbar.*;
import com.smartgwt.client.widgets.tree.*;
import com.smartgwt.client.widgets.tree.events.*;
import com.smartgwt.client.widgets.tableview.*;
import com.smartgwt.client.widgets.viewer.*;
import com.smartgwt.client.widgets.calendar.*;
import com.smartgwt.client.widgets.calendar.events.*;
import com.smartgwt.client.widgets.cube.*;
import com.smartgwt.client.widgets.notify.*;
import com.smartgwt.client.widgets.drawing.*;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

import com.google.gwt.event.shared.*;
import com.google.gwt.dom.client.Element;
import com.google.gwt.user.client.ui.Widget;
import com.google.gwt.core.client.JavaScriptObject;

import com.smartgwt.client.util.*;
import com.smartgwt.client.util.events.*;
import com.smartgwt.client.util.workflow.*;
import com.smartgwt.client.util.workflow.Process; // required to override java.lang.Process
import com.smartgwt.client.util.tour.*;


/**
 * The result for a batch of records in a record summarization operation.
 */
@BeanFactory.FrameworkClass
public class SummarizeRecordsPartialResult extends AsyncOperationResult {

    public static SummarizeRecordsPartialResult getOrCreateRef(JavaScriptObject jsObj) {
        if (jsObj == null) return null;

        final RefDataClass existingObj = RefDataClass.getRef(jsObj);

        if (existingObj instanceof SummarizeRecordsPartialResult) {
            existingObj.setJsObj(jsObj);
            return (SummarizeRecordsPartialResult)existingObj;
        } else

        {
            return new SummarizeRecordsPartialResult(jsObj);
        }
    }
        


    public SummarizeRecordsPartialResult(){
        
    }

    public SummarizeRecordsPartialResult(JavaScriptObject jsObj){
        
        setJavaScriptObject(jsObj);
    }



    // ********************* Properties / Attributes ***********************

    /**
     * The number of records in the batch.
     *
     * @param length New length value. Default value is *initialized by the implementation*
     * @return {@link com.smartgwt.client.ai.SummarizeRecordsPartialResult SummarizeRecordsPartialResult} instance, for chaining setter calls
     */
    public SummarizeRecordsPartialResult setLength(Integer length) {
        return (SummarizeRecordsPartialResult)setAttribute("length", length);
    }

    /**
     * The number of records in the batch.
     *
     * @return Current length value. Default value is *initialized by the implementation*
     */
    public Integer getLength()  {
        return getAttributeAsInt("length");
    }
    

    /**
     * If successful and the {@link com.smartgwt.client.ai.SummarizeRecordsRequest#getAIFieldRequest
     * SummarizeRecordsRequest.aiFieldRequest} is {@link com.smartgwt.client.ai.AI#isAIFieldRequestNumerical numerical}, <ul>
     * <li>If the <code>valueClass</code> is ORDINAL,     the 0-based index of the category in the ordered list of {@link
     * com.smartgwt.client.ai.AIFieldRequest#getCategories AIFieldRequest.categories} <li>The computed numerical value </ul> ..
     * for the corresponding records in the batch. <p> This array will have the same {@link
     * com.smartgwt.client.ai.SummarizeRecordsPartialResult#getLength length} as the batch.
     *
     * @param recordNumericalSummaries New recordNumericalSummaries value. Default value is *initialized by the implementation*
     * @return {@link com.smartgwt.client.ai.SummarizeRecordsPartialResult SummarizeRecordsPartialResult} instance, for chaining setter calls
     */
    public SummarizeRecordsPartialResult setRecordNumericalSummaries(int... recordNumericalSummaries) {
        return (SummarizeRecordsPartialResult)setAttribute("recordNumericalSummaries", recordNumericalSummaries);
    }

    /**
     * If successful and the {@link com.smartgwt.client.ai.SummarizeRecordsRequest#getAIFieldRequest
     * SummarizeRecordsRequest.aiFieldRequest} is {@link com.smartgwt.client.ai.AI#isAIFieldRequestNumerical numerical}, <ul>
     * <li>If the <code>valueClass</code> is ORDINAL,     the 0-based index of the category in the ordered list of {@link
     * com.smartgwt.client.ai.AIFieldRequest#getCategories AIFieldRequest.categories} <li>The computed numerical value </ul> ..
     * for the corresponding records in the batch. <p> This array will have the same {@link
     * com.smartgwt.client.ai.SummarizeRecordsPartialResult#getLength length} as the batch.
     *
     * @return Current recordNumericalSummaries value. Default value is *initialized by the implementation*
     */
    public int[] getRecordNumericalSummaries()  {
        return com.smartgwt.client.util.ConvertTo.arrayOfint(getAttributeAsJavaScriptObject("recordNumericalSummaries"));
    }
    

    /**
     * If successful and the {@link com.smartgwt.client.ai.SummarizeRecordsRequest#getAIFieldRequest
     * SummarizeRecordsRequest.aiFieldRequest} is not {@link com.smartgwt.client.ai.AI#isAIFieldRequestNumerical numerical},
     * the generated record summaries (text) or unordered categories for the corresponding records in the batch. <p> This array
     * will have the same {@link com.smartgwt.client.ai.SummarizeRecordsPartialResult#getLength length} as the batch.
     *
     * @param recordSummaries New recordSummaries value. Default value is *initialized by the implementation*
     * @return {@link com.smartgwt.client.ai.SummarizeRecordsPartialResult SummarizeRecordsPartialResult} instance, for chaining setter calls
     */
    public SummarizeRecordsPartialResult setRecordSummaries(String... recordSummaries) {
        return (SummarizeRecordsPartialResult)setAttribute("recordSummaries", recordSummaries);
    }

    /**
     * If successful and the {@link com.smartgwt.client.ai.SummarizeRecordsRequest#getAIFieldRequest
     * SummarizeRecordsRequest.aiFieldRequest} is not {@link com.smartgwt.client.ai.AI#isAIFieldRequestNumerical numerical},
     * the generated record summaries (text) or unordered categories for the corresponding records in the batch. <p> This array
     * will have the same {@link com.smartgwt.client.ai.SummarizeRecordsPartialResult#getLength length} as the batch.
     *
     * @return Current recordSummaries value. Default value is *initialized by the implementation*
     */
    public String[] getRecordSummaries()  {
        return com.smartgwt.client.util.ConvertTo.arrayOfString(getAttributeAsJavaScriptObject("recordSummaries"));
    }
    

    /**
     * Starting index of the batch within the {@link com.smartgwt.client.ai.SummarizeRecordsRequest#getRecords records} of the
     * {@link com.smartgwt.client.ai.SummarizeRecordsRequest}.
     *
     * @param startIndex New startIndex value. Default value is *initialized by the implementation*
     * @return {@link com.smartgwt.client.ai.SummarizeRecordsPartialResult SummarizeRecordsPartialResult} instance, for chaining setter calls
     */
    public SummarizeRecordsPartialResult setStartIndex(Integer startIndex) {
        return (SummarizeRecordsPartialResult)setAttribute("startIndex", startIndex);
    }

    /**
     * Starting index of the batch within the {@link com.smartgwt.client.ai.SummarizeRecordsRequest#getRecords records} of the
     * {@link com.smartgwt.client.ai.SummarizeRecordsRequest}.
     *
     * @return Current startIndex value. Default value is *initialized by the implementation*
     */
    public Integer getStartIndex()  {
        return getAttributeAsInt("startIndex");
    }
    

    // ********************* Methods ***********************

    // ********************* Static Methods ***********************

    // ***********************************************************

}
