package com.smartgwt.client.types;


/*
 * Smart GWT (GWT for SmartClient)
 * Copyright 2008 and beyond, Isomorphic Software, Inc.
 *
 * Smart GWT is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License version 3
 * as published by the Free Software Foundation.  Smart GWT is also
 * available under typical commercial license terms - see
 * http://smartclient.com/license
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 */
/* sgwtgen */
 
/**
 * The possible access types for records with a null {@link com.smartgwt.client.docs.serverds.DataSource#ownerIdField
 * ownerIdField} (only applicable if <code>ownerIdField</code> is specified)
 */
public enum NullAccessType implements ValueEnum {
    /**
     * The default value, means that users have no access to records with a null <code>ownerIdField</code>. In this case, users
     * can only see their own records (ie,  those where the <code>ownerIdField</code> matches the currently authenticaed user's
     * id)
     * <P>
     * If this enumerated value is used in a {@link com.smartgwt.client.docs.ComponentXML Component XML}
     * file or server-side DataSource descriptor (.ds.xml file), use the value "none".
     */
    NONE("none"),
    /**
     * Users are allowed read-only access to records with a null <code>ownerIdField</code>. In this case, users can see records
     * with a null owner as  well as their own records.
     * <P>
     * If this enumerated value is used in a {@link com.smartgwt.client.docs.ComponentXML Component XML}
     * file or server-side DataSource descriptor (.ds.xml file), use the value "view".
     */
    VIEW("view"),
    /**
     * Users are allowed read, update and delete access to records with a null <code>ownerIdField</code>. In this case, users
     * can see and fully manage records with  a null owner, as well as their own records.
     * <P>
     * If this enumerated value is used in a {@link com.smartgwt.client.docs.ComponentXML Component XML}
     * file or server-side DataSource descriptor (.ds.xml file), use the value "edit".
     */
    EDIT("edit");
    private String value;

    NullAccessType(String value) {
        this.value = value;
    }

    public String getValue() {
        return this.value;
    }
}
