/*
 * Smart GWT (GWT for SmartClient)
 * Copyright 2008 and beyond, Isomorphic Software, Inc.
 *
 * Smart GWT is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License version 3
 * as published by the Free Software Foundation.  Smart GWT is also
 * available under typical commercial license terms - see
 * http://smartclient.com/license
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 */
/* sgwtgen */
 
package com.smartgwt.client.callbacks;

import com.smartgwt.client.ai.BuildUIViaAIResponse;

public interface BuildUIViaAICustomValidationResultCallback {

    /** 
     * This will be provided to a  BuildUIViaAICustomValidator() to continue the build-UI process after performing the custom
     * validation.
     *
     * @param workingResponse The working response, modified according to the result of custom validation.
     * @param validationContext Any object or value to pass to the next invocation of the validator on retry.
     */
	public void execute(BuildUIViaAIResponse workingResponse, Object validationContext);
} 
