/*
 * Smart GWT (GWT for SmartClient)
 * Copyright 2008 and beyond, Isomorphic Software, Inc.
 *
 * Smart GWT is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License version 3
 * as published by the Free Software Foundation.  Smart GWT is also
 * available under typical commercial license terms - see
 * http://smartclient.com/license
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 */
/* sgwtgen */
 
package com.smartgwt.client.ai;


import com.smartgwt.client.event.*;
import com.smartgwt.client.core.*;
import com.smartgwt.client.types.*;
import com.smartgwt.client.data.*;
import com.smartgwt.client.data.Record;
import com.smartgwt.client.data.events.*;
import com.smartgwt.client.browser.window.*;
import com.smartgwt.client.rpc.*;
import com.smartgwt.client.ai.*;
import com.smartgwt.client.callbacks.*;
import com.smartgwt.client.tools.*;
import com.smartgwt.client.bean.*;
import com.smartgwt.client.widgets.*;
import com.smartgwt.client.widgets.ai.*;
import com.smartgwt.client.widgets.events.*;
import com.smartgwt.client.widgets.form.*;
import com.smartgwt.client.widgets.form.validator.*;
import com.smartgwt.client.widgets.form.fields.*;
import com.smartgwt.client.widgets.tile.*;
import com.smartgwt.client.widgets.tile.events.*;
import com.smartgwt.client.widgets.grid.*;
import com.smartgwt.client.widgets.grid.events.*;
import com.smartgwt.client.widgets.chart.*;
import com.smartgwt.client.widgets.layout.*;
import com.smartgwt.client.widgets.layout.events.*;
import com.smartgwt.client.widgets.menu.*;
import com.smartgwt.client.widgets.tour.*;
import com.smartgwt.client.widgets.notify.*;
import com.smartgwt.client.widgets.rte.*;
import com.smartgwt.client.widgets.rte.events.*;
import com.smartgwt.client.widgets.ace.*;
import com.smartgwt.client.widgets.ace.events.*;
import com.smartgwt.client.widgets.tab.*;
import com.smartgwt.client.widgets.toolbar.*;
import com.smartgwt.client.widgets.tree.*;
import com.smartgwt.client.widgets.tree.events.*;
import com.smartgwt.client.widgets.tableview.*;
import com.smartgwt.client.widgets.viewer.*;
import com.smartgwt.client.widgets.calendar.*;
import com.smartgwt.client.widgets.calendar.events.*;
import com.smartgwt.client.widgets.cube.*;
import com.smartgwt.client.widgets.notify.*;
import com.smartgwt.client.widgets.drawing.*;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

import com.google.gwt.event.shared.*;
import com.google.gwt.dom.client.Element;
import com.google.gwt.user.client.ui.Widget;
import com.google.gwt.core.client.JavaScriptObject;

import com.smartgwt.client.util.*;
import com.smartgwt.client.util.events.*;
import com.smartgwt.client.util.workflow.*;
import com.smartgwt.client.util.workflow.Process; // required to override java.lang.Process
import com.smartgwt.client.util.tour.*;


/**
 * Represents a request to AI for data-bound UI elements.
 */
@BeanFactory.FrameworkClass
public class BuildDataBoundUIViaAIRequest extends BuildUIViaAIRequest {

    public static BuildDataBoundUIViaAIRequest getOrCreateRef(JavaScriptObject jsObj) {
        if (jsObj == null) return null;

        final RefDataClass existingObj = RefDataClass.getRef(jsObj);

        if (existingObj instanceof BuildDataBoundUIViaAIRequest) {
            existingObj.setJsObj(jsObj);
            return (BuildDataBoundUIViaAIRequest)existingObj;
        } else

        {
            return new BuildDataBoundUIViaAIRequest(jsObj);
        }
    }
        


    public BuildDataBoundUIViaAIRequest(){
        
    }

    public BuildDataBoundUIViaAIRequest(JavaScriptObject jsObj){
        
        setJavaScriptObject(jsObj);
    }



    // ********************* Properties / Attributes ***********************

    /**
     * The list of allowed, data-bound UI types. The following types are supported by default: <ul> <li>"list" - A {@link
     * com.smartgwt.client.widgets.grid.ListGrid} displaying some data from a data source in a list or grid <li>"chart" - A
     * {@link com.smartgwt.client.widgets.chart.FacetChart} displaying some data from a data source as a chart <li>"value" - A
     * {@link com.smartgwt.client.widgets.Label} displaying a single value (scalar) derived from the data in a data source
     * </ul>
     *
     * @param allowedUITypes New allowedUITypes value. Default value is null
     * @return {@link com.smartgwt.client.ai.BuildDataBoundUIViaAIRequest BuildDataBoundUIViaAIRequest} instance, for chaining setter calls
     */
    public BuildDataBoundUIViaAIRequest setAllowedUITypes(String... allowedUITypes) {
        return (BuildDataBoundUIViaAIRequest)setAttribute("allowedUITypes", allowedUITypes);
    }

    /**
     * The list of allowed, data-bound UI types. The following types are supported by default: <ul> <li>"list" - A {@link
     * com.smartgwt.client.widgets.grid.ListGrid} displaying some data from a data source in a list or grid <li>"chart" - A
     * {@link com.smartgwt.client.widgets.chart.FacetChart} displaying some data from a data source as a chart <li>"value" - A
     * {@link com.smartgwt.client.widgets.Label} displaying a single value (scalar) derived from the data in a data source
     * </ul>
     *
     * @return Current allowedUITypes value. Default value is null
     */
    public String[] getAllowedUITypes()  {
        return com.smartgwt.client.util.ConvertTo.arrayOfString(getAttributeAsJavaScriptObject("allowedUITypes"));
    }
    

    /**
     * Global IDs of the data sources made available to AI for satisfying the user's request. If not specified, then the data
     * sources of the application will be considered the available data sources.
     *
     * @param availableDataSources New availableDataSources value. Default value is null
     * @return {@link com.smartgwt.client.ai.BuildDataBoundUIViaAIRequest BuildDataBoundUIViaAIRequest} instance, for chaining setter calls
     * @see com.smartgwt.client.docs.GlobalId GlobalId 
     */
    public BuildDataBoundUIViaAIRequest setAvailableDataSources(String... availableDataSources) {
        return (BuildDataBoundUIViaAIRequest)setAttribute("availableDataSources", availableDataSources);
    }

    /**
     * Global IDs of the data sources made available to AI for satisfying the user's request. If not specified, then the data
     * sources of the application will be considered the available data sources.
     *
     * @return Current availableDataSources value. Default value is null
     * @see com.smartgwt.client.docs.GlobalId GlobalId 
     */
    public String[] getAvailableDataSources()  {
        return com.smartgwt.client.util.ConvertTo.arrayOfString(getAttributeAsJavaScriptObject("availableDataSources"));
    }
    

    // ********************* Methods ***********************

    // ********************* Static Methods ***********************

    // ***********************************************************

}
