package com.smartgwt.client.types;


/*
 * Smart GWT (GWT for SmartClient)
 * Copyright 2008 and beyond, Isomorphic Software, Inc.
 *
 * Smart GWT is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License version 3
 * as published by the Free Software Foundation.  Smart GWT is also
 * available under typical commercial license terms - see
 * http://smartclient.com/license
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 */
/* sgwtgen */
 
/**
 * For <code>SQLDataSource</code> only, the strategy to use to harmonize multiple records when {@link
 * com.smartgwt.client.data.DataSource#addData addData()} is called with a list of records, and  {@link
 * com.smartgwt.client.docs.serverds.DataSource#multiInsertStrategy multiInsertStrategy} "multipleValues" is in force, and
 * the supplied records do not all contain exactly the same fields.  Harmonization is necessary because we only specify a
 * single list of fields to the multi-insert, and each of the  multiple <code>VALUES</code> clauses must exactly match that
 * list of fields or we will get  either SQL errors or corrupted inserts, depending on the underlying database
 */
public enum MultiInsertNonMatchingStrategy implements ValueEnum {
    /**
     * Drop all records in the record list that do not contain exactly the same fields as the first record
     * <P>
     * If this enumerated value is used in a {@link com.smartgwt.client.docs.ComponentXML Component XML}
     * file or server-side DataSource descriptor (.ds.xml file), use the value "dropRecords".
     */
    DROPRECORDS("dropRecords"),
    /**
     * Make all records match the first record in the record list, by dropping any fields from the second and subsequent
     * records that  are not present on the first record. If the first record in the record list contains values for field(s)
     * that are missing in any other record in the record list, the other record(s) will be padded with nulls. This is similar
     * to the "padWithNulls" setting below, but it only  serves to make the second and subsequent records the same as the
     * first, rather than considering all fields on all records
     * <P>
     * If this enumerated value is used in a {@link com.smartgwt.client.docs.ComponentXML Component XML}
     * file or server-side DataSource descriptor (.ds.xml file), use the value "dropFields".
     */
    DROPFIELDS("dropFields"),
    /**
     * Assemble a list of all fields that appear on ANY record in the record list, and ensure that ALL records in the record
     * list include a value  for each of those fields by modifying records to specify a null value for any field(s) the record
     * is missing
     * <P>
     * If this enumerated value is used in a {@link com.smartgwt.client.docs.ComponentXML Component XML}
     * file or server-side DataSource descriptor (.ds.xml file), use the value "padWithNulls".
     */
    PADWITHNULLS("padWithNulls");
    private String value;

    MultiInsertNonMatchingStrategy(String value) {
        this.value = value;
    }

    public String getValue() {
        return this.value;
    }
}
